/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

public class RemoveGameTree
extends AbstractCommand {
    private final GameTree parent_;
    private final GameTree target_;
    private GameTree[] children_;
    private Node extensionPoint_;

    public RemoveGameTree(GameTree gameTree, GameTree gameTree2) {
        ArgumentChecker.throwIfNull((Object)gameTree, (Object)gameTree2);
        if (!gameTree.containsDirectly(gameTree2)) {
            throw new IllegalArgumentException(gameTree2 + " is not a child of " + gameTree);
        }
        this.parent_ = gameTree;
        this.target_ = gameTree2;
        this.children_ = null;
        this.extensionPoint_ = null;
    }

    protected void executeCommand() {
        this.children_ = this.parent_.getChildren();
        this.parent_.removeGameTree(this.target_);
        GameTree[] gameTreeArray = this.parent_.getChildren();
        if (gameTreeArray.length != 1) {
            this.extensionPoint_ = null;
        } else {
            GameTree gameTree = gameTreeArray[0];
            this.extensionPoint_ = this.parent_.getSequence().getLast();
            for (Node node : gameTree.getSequence()) {
                this.parent_.getSequence().addLast(node);
            }
            this.parent_.clearGameTree();
            for (GameTree gameTree2 : gameTree.getChildren()) {
                this.parent_.addGameTree(gameTree2);
            }
        }
    }

    protected void undoCommand() {
        if (this.extensionPoint_ != null) {
            Node node = this.parent_.getSequence().getLast();
            while (node != this.extensionPoint_) {
                node = this.parent_.getSequence().removeLast();
            }
            this.parent_.getSequence().addLast(node);
            GameTree gameTree = this.children_[0] == this.target_ ? this.children_[1] : this.children_[0];
            for (GameTree gameTree2 : this.parent_.getChildren()) {
                gameTree.addGameTree(gameTree2);
            }
            this.extensionPoint_ = null;
        }
        this.parent_.clearGameTree();
        for (int i = 0; i < this.children_.length; ++i) {
            this.parent_.addGameTree(this.children_[i]);
        }
        this.children_ = null;
    }
}

