/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.pc;

import java.util.ArrayList;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.cmd.CreateGameTree;
import org.unitarou.sgf.cmd.RemoveGameTree;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.pc.DefaultWrongProblemConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaribariKids
extends DefaultWrongProblemConverter {
    private static final String SUFFIX_CORRECT = "@0";
    private static final String SUFFIX_WRONG = "@1";

    @Override
    public boolean isSatisfied(GameTree gameTree) {
        for (Property property : BasicFinder.findAll(gameTree, SgfId.COMMENT)) {
            String string = property.getString().trim();
            if (!this.isCorrect(string) && !this.isWrong(string)) continue;
            return true;
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            if (!this.isSatisfied(gameTree2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCorrectNode(Node node) {
        Property property = node.getProperty(SgfId.COMMENT);
        if (property == null) {
            return false;
        }
        return this.isCorrect(property.getString());
    }

    private boolean isCorrect(String string) {
        return string.endsWith(SUFFIX_CORRECT);
    }

    private boolean isWrongNode(Node node) {
        Property property = node.getProperty(SgfId.COMMENT);
        if (property == null) {
            return false;
        }
        return this.isWrong(property.getString());
    }

    private boolean isWrong(String string) {
        return string.endsWith(SUFFIX_WRONG);
    }

    @Override
    protected void addYukinoshitaConfig(GameTree gameTree, Property property, Property property2, boolean bl) {
        for (GameTree[] gameTreeArray : gameTree.getSequence()) {
            if (this.isWrongNode((Node)gameTreeArray)) {
                gameTreeArray.addProperty(property2);
                continue;
            }
            if (!this.isCorrectNode((Node)gameTreeArray)) continue;
            this.addSituationTag(gameTree, property, bl);
            if (!bl) {
                gameTreeArray.addProperty(property);
                continue;
            }
            return;
        }
        int n = 0;
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.addYukinoshitaConfig(gameTree2, property, property2, bl && n == 0);
            ++n;
        }
    }

    @Override
    public void appendConfig(RootGameTree rootGameTree) {
        Object object;
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        SgfColor sgfColor = BasicFinder.firstMove(rootGameTree);
        if (sgfColor == null) {
            return;
        }
        rootGameTree.setSize(rootGameTree.getSize());
        Property property = new Property(sgfColor.situationType(), SgfDouble.EMPHASIZED.getString());
        Property property2 = new Property(sgfColor.opposite().situationType(), SgfDouble.EMPHASIZED.getString());
        this.appendPassMove(rootGameTree, sgfColor, rootGameTree.getSize());
        this.appendConfigImpl(rootGameTree, property, property2, true);
        Sequence sequence = rootGameTree.getSequence();
        Sequence.Iterator iterator = sequence.iterator();
        Node node = (Node)iterator.next();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext() && !((Node)(object = (Node)iterator.next())).contains(PropertyType.MOVE)) {
            for (Property property3 : ((Node)object).getProperties()) {
                node.addProperty(property3);
            }
            arrayList.add(object);
        }
        for (Node node2 : arrayList) {
            sequence.remove(node2);
        }
    }

    private void appendConfigImpl(GameTree gameTree, Property property, Property property2, boolean bl) {
        boolean bl2 = false;
        for (GameTree[] gameTreeArray : gameTree.getSequence()) {
            bl2 |= this.appendSuffix((Node)gameTreeArray, property, SUFFIX_CORRECT);
            bl2 |= this.appendSuffix((Node)gameTreeArray, property2, SUFFIX_WRONG);
        }
        if (!bl2 && !gameTree.getSequence().isEmpty() && gameTree.getChildrenSize() == 0) {
            Node node = gameTree.getSequence().getLast();
            if (bl) {
                this.appendSuffixInComment(node, SUFFIX_CORRECT);
            } else {
                this.appendSuffixInComment(node, SUFFIX_WRONG);
            }
        }
        int n = 0;
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.appendConfigImpl(gameTree2, property, property2, bl && n == 0);
            ++n;
        }
    }

    private boolean appendSuffix(Node node, Property property, String string) {
        Property property2 = node.getProperty(property.sgfId());
        if (!property.equals(property2)) {
            return false;
        }
        this.appendSuffixInComment(node, string);
        return true;
    }

    private void appendSuffixInComment(Node node, String string) {
        Property property = node.getProperty(SgfId.COMMENT);
        if (property == null) {
            property = new Property(SgfId.COMMENT, "");
        }
        Value value = property.getValue();
        String string2 = value.getString().trim();
        string2 = this.removeIfEndWith(string2, SUFFIX_CORRECT);
        string2 = this.removeIfEndWith(string2, SUFFIX_WRONG);
        property.setValue(new Value(string2 + string, value.getOpenUtr()));
        node.addProperty(property);
    }

    /*
     * WARNING - void declaration
     */
    private void appendPassMove(GameTree gameTree, SgfColor sgfColor, SgfSize sgfSize) {
        void var8_16;
        Node node = null;
        for (Node node2 : gameTree.getSequence()) {
            if (node == null) {
                node = node2;
                continue;
            }
            Property property = node2.getProperty(sgfColor.moveType());
            if (property == null) {
                node = node2;
                continue;
            }
            SgfPoint object = SgfPoint.parseMoveQuietly(sgfSize, property.getString());
            if (object == null) {
                node = node2;
                continue;
            }
            if (object.equals(SgfPoint.createPass(sgfSize))) {
                node = node2;
                continue;
            }
            CreateGameTree createGameTree = new CreateGameTree(gameTree, node, this.createPassTree(sgfColor, sgfSize));
            createGameTree.execute();
            break;
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.appendPassMove(gameTree2, sgfColor, sgfSize);
        }
        boolean bl = false;
        GameTree[] gameTreeArray = gameTree.getChildren();
        int n = gameTreeArray.length;
        boolean bl2 = false;
        while (var8_16 < n) {
            Property property;
            SgfPoint sgfPoint;
            GameTree gameTree3 = gameTreeArray[var8_16];
            Node node2 = this.findFirstMove(gameTree3, sgfColor);
            if (node2 != null && (sgfPoint = SgfPoint.parseMoveQuietly(sgfSize, (property = node2.getProperty(sgfColor.moveType())).getString())) != null) {
                bl = true;
                if (sgfPoint.equals(SgfPoint.createPass(sgfSize))) {
                    return;
                }
            }
            ++var8_16;
        }
        if (bl) {
            gameTree.addGameTree(this.createPassTree(sgfColor, sgfSize));
        }
    }

    private Node findFirstMove(GameTree gameTree, SgfColor sgfColor) {
        for (Node node : gameTree.getSequence()) {
            if (node.contains(sgfColor.moveType())) {
                return node;
            }
            if (!node.contains(sgfColor.opposite().moveType())) continue;
            return null;
        }
        return null;
    }

    private GameTree createPassTree(SgfColor sgfColor, SgfSize sgfSize) {
        GameTree gameTree = new GameTree();
        Property property = new Property(sgfColor.moveType(), SgfPoint.createPass(sgfSize).getString());
        Node node = new Node(property);
        gameTree.getSequence().addFirst(node);
        return gameTree;
    }

    @Override
    public void removeConfig(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.removeConfigImpl(rootGameTree);
        this.removeSinglePassTree(rootGameTree, rootGameTree.getSize());
    }

    private void removeConfigImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            Property property = node.getProperty(SgfId.COMMENT);
            if (property == null) continue;
            Value object = property.getValue();
            String string = object.getString().trim();
            string = this.removeIfEndWith(string, SUFFIX_CORRECT);
            if ((string = this.removeIfEndWith(string, SUFFIX_WRONG)).length() == 0) {
                node.removeProperty(property.sgfId());
                continue;
            }
            property.setValue(new Value(string, object.getOpenUtr()));
            node.addProperty(property);
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.removeConfigImpl(gameTree2);
        }
    }

    private String removeIfEndWith(String string, String string2) {
        return string.endsWith(string2) ? string.substring(0, string.length() - string2.length()) : string;
    }

    protected void removeSinglePassTree(GameTree gameTree, SgfSize sgfSize) {
        ArrayList<GameTree> arrayList = new ArrayList<GameTree>();
        this.retrieveRemovedTree(gameTree, sgfSize, arrayList);
        while (!arrayList.isEmpty()) {
            for (GameTree gameTree2 : arrayList) {
                RemoveGameTree removeGameTree = new RemoveGameTree(gameTree, gameTree2);
                removeGameTree.execute();
            }
            arrayList.clear();
            this.retrieveRemovedTree(gameTree, sgfSize, arrayList);
        }
        for (GameTree gameTree3 : gameTree.getChildren()) {
            this.removeSinglePassTree(gameTree3, sgfSize);
        }
    }

    private void retrieveRemovedTree(GameTree gameTree, SgfSize sgfSize, List<GameTree> list) {
        for (GameTree gameTree2 : gameTree.getChildren()) {
            if (gameTree2.getSequence().size() != 1) continue;
            Node node = gameTree2.getSequence().getFirst();
            Stone stone = Stone.create(node, sgfSize);
            if (!SgfPoint.createPass(sgfSize).equals(stone.getPoint())) continue;
            list.add(gameTree2);
        }
    }
}

