/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.provider.plp;

import java.util.HashSet;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;

public class BasicPropertyLabelProvider
implements PropertyLabelProvider {
    private static final Messages messages_s_ = Messages.createByPackage(BasicPropertyLabelProvider.class);
    private static final Message LB_NAME = new Message(BasicPropertyLabelProvider.class, "lbName");
    private CoordinatesLabelProvider clProvider_ = CoordinatesLabelProvider.CONTEXT.defaultValue();

    public String displayName() {
        return LB_NAME.get();
    }

    public void setCoordinatesLabelProvider(CoordinatesLabelProvider coordinatesLabelProvider) {
        ArgumentChecker.throwIfNull((Object)coordinatesLabelProvider);
        this.clProvider_ = coordinatesLabelProvider;
    }

    public CoordinatesLabelProvider getCoordinatesLabelProvider() {
        return this.clProvider_;
    }

    public String getLabel(GameType gameType, Property property) {
        ArgumentChecker.throwIfNull((Object)gameType, (Object)property);
        switch (property.sgfId().valueType()) {
            case DOUBLE: 
            case COLOR: {
                return this.getLabelWithValue(gameType, property);
            }
        }
        return this.getLabelWithIdOnly(gameType, property);
    }

    private String getLabelWithValue(GameType gameType, Property property) {
        String string = Messages.createKey(BasicPropertyLabelProvider.class, gameType.getString() + '.' + property.sgfId().id() + '.');
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : property.getStrings()) {
            String string3 = string + string2;
            if (messages_s_.contains(string3)) {
                hashSet.add(messages_s_.get(string3));
                continue;
            }
            hashSet.add(property.sgfId().displayName());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : hashSet) {
            stringBuilder.append(string4).append(", ");
        }
        if (!hashSet.isEmpty()) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    private String getLabelWithIdOnly(GameType gameType, Property property) {
        String string = Messages.createKey(BasicPropertyLabelProvider.class, gameType.getString() + '.' + property.sgfId().id());
        if (messages_s_.contains(string)) {
            return messages_s_.get(string);
        }
        return property.sgfId().displayName();
    }
}

