/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.unitarou.swt.USashFormData;
import org.unitarou.swt.USashFormLayout;

public class USashForm
extends Composite {
    private int sashWidth_ = 3;
    private int sashStyle_;
    private Sash[] sashes_ = new Sash[0];
    private Color background_ = null;
    private Color foreground_ = null;
    private Control[] controls_ = new Control[0];
    private Control maxControl_ = null;
    private final Listener sashListener_;
    private final PaintListener sashPaintaListener_;

    public USashForm(Composite composite, int n) {
        super(composite, USashForm.checkStyle(n));
        super.setLayout((Layout)new USashFormLayout());
        int n2 = this.sashStyle_ = (n & 0x200) != 0 ? 256 : 512;
        if ((n & 0x800) != 0) {
            this.sashStyle_ |= 0x800;
        }
        if ((n & 0x10000) != 0) {
            this.sashStyle_ |= 0x10000;
        }
        this.sashListener_ = new Listener(){

            public void handleEvent(Event event) {
                USashForm.this.onDragSash(event);
            }
        };
        this.sashPaintaListener_ = new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Sash sash = (Sash)paintEvent.widget;
                Color color = sash.getDisplay().getSystemColor(20);
                Color color2 = sash.getDisplay().getSystemColor(18);
                Point point = sash.getSize();
                if (0 != (sash.getStyle() & 0x100)) {
                    int n = point.y / 2;
                    int n2 = n + 1;
                    paintEvent.gc.setForeground(color);
                    paintEvent.gc.drawLine(0, n, point.x, n);
                    paintEvent.gc.setForeground(color2);
                    paintEvent.gc.drawLine(0, n2, point.x, n2);
                } else {
                    int n = point.x / 2;
                    int n3 = n + 1;
                    paintEvent.gc.setForeground(color);
                    paintEvent.gc.drawLine(n, 0, n, point.y);
                    paintEvent.gc.setForeground(color2);
                    paintEvent.gc.drawLine(n3, 0, n3, point.y);
                }
            }
        };
    }

    private static int checkStyle(int n) {
        int n2 = 0x6000800;
        return n & n2;
    }

    public int getOrientation() {
        return (this.sashStyle_ & 0x200) != 0 ? 256 : 512;
    }

    public int getStyle() {
        int n = super.getStyle();
        n |= this.getOrientation() == 512 ? 512 : 256;
        if ((this.sashStyle_ & 0x10000) != 0) {
            n |= 0x10000;
        }
        return n;
    }

    public Control getMaximizedControl() {
        return this.maxControl_;
    }

    public int[] getWeights() {
        this.checkWidget();
        Control[] controlArray = this.getControls(false);
        int[] nArray = new int[controlArray.length];
        for (int i = 0; i < controlArray.length; ++i) {
            Object object = controlArray[i].getLayoutData();
            nArray[i] = object != null && object instanceof USashFormData ? (int)(((USashFormData)object).weight * 1000L >> 16) : 200;
        }
        return nArray;
    }

    Control[] getControls(boolean bl) {
        Control[] controlArray = this.getChildren();
        Control[] controlArray2 = new Control[]{};
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] instanceof Sash || bl && !controlArray[i].getVisible()) continue;
            Control[] controlArray3 = new Control[controlArray2.length + 1];
            System.arraycopy(controlArray2, 0, controlArray3, 0, controlArray2.length);
            controlArray3[controlArray2.length] = controlArray[i];
            controlArray2 = controlArray3;
        }
        return controlArray2;
    }

    void onDragSash(Event event) {
        Sash sash = (Sash)event.widget;
        int n = -1;
        for (int i = 0; i < this.sashes_.length; ++i) {
            if (this.sashes_[i] != sash) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return;
        }
        Control control = this.controls_[n];
        Control control2 = this.controls_[n + 1];
        this.checkAndCreateLayoutData(control);
        this.checkAndCreateLayoutData(control2);
        Rectangle rectangle = control.getBounds();
        Rectangle rectangle2 = control2.getBounds();
        USashFormData uSashFormData = (USashFormData)control.getLayoutData();
        USashFormData uSashFormData2 = (USashFormData)control2.getLayoutData();
        Rectangle rectangle3 = sash.getBounds();
        Rectangle rectangle4 = this.getClientArea();
        boolean bl = false;
        if (this.getOrientation() == 256) {
            bl = rectangle.width < uSashFormData.getDragMinimum() || rectangle2.width < uSashFormData2.getDragMinimum();
            int n2 = rectangle2.x + rectangle2.width - rectangle.x;
            int n3 = event.x - rectangle3.x;
            rectangle.width += n3;
            rectangle2.x += n3;
            rectangle2.width -= n3;
            if (rectangle.width < uSashFormData.getDragMinimum()) {
                rectangle.width = uSashFormData.getDragMinimum();
                rectangle2.x = rectangle.x + rectangle.width + rectangle3.width;
                rectangle2.width = n2 - rectangle2.x;
                event.x = rectangle.x + rectangle.width;
                event.doit = false;
            }
            if (rectangle2.width < uSashFormData2.getDragMinimum()) {
                rectangle.width = n2 - uSashFormData2.getDragMinimum() - rectangle3.width;
                rectangle2.x = rectangle.x + rectangle.width + rectangle3.width;
                rectangle2.width = uSashFormData2.getDragMinimum();
                event.x = rectangle.x + rectangle.width;
                event.doit = false;
            }
            this.updateHorizontalLayoutData(rectangle4, control, rectangle);
            this.updateHorizontalLayoutData(rectangle4, control2, rectangle2);
        } else {
            bl = rectangle.height < uSashFormData.getDragMinimum() || rectangle2.height < uSashFormData2.getDragMinimum();
            int n4 = rectangle2.y + rectangle2.height - rectangle.y;
            int n5 = event.y - rectangle3.y;
            rectangle.height += n5;
            rectangle2.y += n5;
            rectangle2.height -= n5;
            if (rectangle.height < uSashFormData.getDragMinimum()) {
                rectangle.height = uSashFormData.getDragMinimum();
                rectangle2.y = rectangle.y + rectangle.height + rectangle3.height;
                rectangle2.height = n4 - rectangle2.y;
                event.y = rectangle.y + rectangle.height;
                event.doit = false;
            }
            if (rectangle2.height < uSashFormData2.getDragMinimum()) {
                rectangle.height = n4 - uSashFormData2.getDragMinimum() - rectangle3.height;
                rectangle2.y = rectangle.y + rectangle.height + rectangle3.height;
                rectangle2.height = uSashFormData2.getDragMinimum();
                event.y = rectangle.y + rectangle.height;
                event.doit = false;
            }
            this.updateVerticalLayoutData(rectangle4, control, rectangle);
            this.updateVerticalLayoutData(rectangle4, control2, rectangle2);
        }
        if (bl || event.doit && event.detail != 1) {
            control.setBounds(rectangle);
            sash.setBounds(event.x, event.y, event.width, event.height);
            control2.setBounds(rectangle2);
        }
    }

    private void checkAndCreateLayoutData(Control control) {
        Object object = control.getLayoutData();
        if (object == null || !(object instanceof USashFormData)) {
            control.setLayoutData((Object)new USashFormData());
        }
    }

    private void updateHorizontalLayoutData(Rectangle rectangle, Control control, Rectangle rectangle2) {
        USashFormData uSashFormData = (USashFormData)control.getLayoutData();
        if (0 < uSashFormData.getActualSize()) {
            uSashFormData.setActualSize(rectangle2.width);
        } else {
            uSashFormData.weight = (((long)rectangle2.width << 16) + (long)rectangle.width - 1L) / (long)rectangle.width;
        }
    }

    private void updateVerticalLayoutData(Rectangle rectangle, Control control, Rectangle rectangle2) {
        USashFormData uSashFormData = (USashFormData)control.getLayoutData();
        if (0 < uSashFormData.getActualSize()) {
            uSashFormData.setActualSize(rectangle2.height);
        } else {
            uSashFormData.weight = (((long)rectangle2.height << 16) + (long)rectangle.height - 1L) / (long)rectangle.height;
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
        if (this.getOrientation() == n) {
            return;
        }
        if (n != 256 && n != 512) {
            SWT.error((int)5);
        }
        this.sashStyle_ &= 0xFFFFFCFF;
        this.sashStyle_ |= n == 512 ? 256 : 512;
        for (int i = 0; i < this.sashes_.length; ++i) {
            this.sashes_[i].dispose();
            this.sashes_[i] = this.createSash();
        }
        this.layout(false);
    }

    private Sash createSash() {
        Sash sash = new Sash((Composite)this, this.sashStyle_);
        sash.setBackground(this.background_);
        sash.setForeground(this.foreground_);
        sash.addListener(13, this.sashListener_);
        sash.addPaintListener(this.sashPaintaListener_);
        return sash;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background_ = color;
        for (int i = 0; i < this.sashes_.length; ++i) {
            this.sashes_[i].setBackground(this.background_);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground_ = color;
        for (int i = 0; i < this.sashes_.length; ++i) {
            this.sashes_[i].setForeground(this.foreground_);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximizedControl(Control control) {
        this.checkWidget();
        if (control == null) {
            if (this.maxControl_ != null) {
                this.maxControl_ = null;
                this.layout(false);
                for (int i = 0; i < this.sashes_.length; ++i) {
                    this.sashes_[i].setVisible(true);
                }
            }
            return;
        }
        for (int i = 0; i < this.sashes_.length; ++i) {
            this.sashes_[i].setVisible(false);
        }
        this.maxControl_ = control;
        this.layout(false);
    }

    public void setWeights(int[] nArray) {
        int n;
        this.checkWidget();
        Control[] controlArray = this.getControls(false);
        if (nArray == null || nArray.length != controlArray.length) {
            SWT.error((int)5);
            return;
        }
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0) {
                nArray2[n] = -nArray[n];
                nArray[n] = 0;
            }
            n2 += nArray[n];
        }
        if (n2 == 0) {
            SWT.error((int)5);
        }
        for (n = 0; n < controlArray.length; ++n) {
            Object object = controlArray[n].getLayoutData();
            if (object == null || !(object instanceof USashFormData)) {
                object = new USashFormData();
                controlArray[n].setLayoutData(object);
            }
            USashFormData uSashFormData = (USashFormData)object;
            uSashFormData.weight = (((long)nArray[n] << 16) + (long)n2 - 1L) / (long)n2;
            uSashFormData.setActualSize(nArray2[n]);
        }
        this.layout(false);
    }

    public void setDragMinimums(int[] nArray) {
        this.checkWidget();
        Control[] controlArray = this.getControls(false);
        if (nArray == null || nArray.length != controlArray.length) {
            SWT.error((int)5);
            return;
        }
        for (int i = 0; i < controlArray.length; ++i) {
            Object object;
            if (nArray[i] <= 0) {
                SWT.error((int)5);
            }
            if ((object = controlArray[i].getLayoutData()) == null || !(object instanceof USashFormData)) {
                object = new USashFormData();
                controlArray[i].setLayoutData(object);
            }
            USashFormData uSashFormData = (USashFormData)object;
            uSashFormData.setDragMinimum(nArray[i]);
        }
    }

    public int getSashWidth() {
        return this.sashWidth_;
    }

    public void setSashWidth(int n) {
        this.sashWidth_ = n;
    }

    int getWholeSashWidth() {
        return this.sashes_.length > 0 ? this.sashWidth_ + this.sashes_[0].getBorderWidth() * 2 : this.sashWidth_;
    }

    public int getSashStyle() {
        return this.sashStyle_;
    }

    public void setSashStyle(int n) {
        this.sashStyle_ = n;
    }

    boolean updateSashAndControl() {
        int n;
        Sash[] sashArray;
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width <= 1 || rectangle.height <= 1) {
            return false;
        }
        Control[] controlArray = this.getControls(true);
        if (this.controls_.length == 0 && controlArray.length == 0) {
            return false;
        }
        this.controls_ = controlArray;
        if (this.maxControl_ != null && !this.maxControl_.isDisposed()) {
            for (int i = 0; i < this.controls_.length; ++i) {
                if (this.controls_[i] != this.maxControl_) {
                    this.controls_[i].setBounds(-200, -200, 0, 0);
                    continue;
                }
                this.controls_[i].setBounds(rectangle);
            }
            return false;
        }
        if (this.sashes_.length < this.controls_.length - 1) {
            sashArray = new Sash[this.controls_.length - 1];
            System.arraycopy(this.sashes_, 0, sashArray, 0, this.sashes_.length);
            for (n = this.sashes_.length; n < sashArray.length; ++n) {
                sashArray[n] = this.createSash();
            }
            this.sashes_ = sashArray;
        }
        if (this.sashes_.length > this.controls_.length - 1) {
            if (this.controls_.length == 0) {
                for (int i = 0; i < this.sashes_.length; ++i) {
                    this.sashes_[i].dispose();
                }
                this.sashes_ = new Sash[0];
            } else {
                sashArray = new Sash[this.controls_.length - 1];
                System.arraycopy(this.sashes_, 0, sashArray, 0, sashArray.length);
                for (n = this.controls_.length - 1; n < this.sashes_.length; ++n) {
                    this.sashes_[n].dispose();
                }
                this.sashes_ = sashArray;
            }
        }
        return this.controls_.length != 0;
    }

    Control[] getControls() {
        Control[] controlArray = new Control[this.controls_.length];
        System.arraycopy(this.controls_, 0, controlArray, 0, controlArray.length);
        return controlArray;
    }

    Sash[] getSashes() {
        Sash[] sashArray = new Sash[this.sashes_.length];
        System.arraycopy(this.sashes_, 0, sashArray, 0, sashArray.length);
        return sashArray;
    }
}

