/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.type.SgfSize;

public class NodeTree {
    private static final Log log_s_ = LogFactory.getLog(NodeTree.class);
    private final RootGameTree rootGameTree_;
    private final GameTree parentGameTree_;
    private final GameTree gameTree_;
    private final Node node_;

    public NodeTree(Node node, GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)node, (Object)gameTree);
        this.node_ = node;
        this.gameTree_ = gameTree;
        this.parentGameTree_ = this.gameTree_.getParent();
        GameTree gameTree2 = Sgfs.getRoot(this.gameTree_);
        if (!(gameTree2 instanceof RootGameTree)) {
            throw new IllegalArgumentException("Root tree must be an instance of RootGameTree.");
        }
        this.rootGameTree_ = (RootGameTree)gameTree2;
    }

    public GameTree getGameTree() {
        return this.gameTree_;
    }

    public GameTree getParentGameTree() {
        return this.parentGameTree_;
    }

    public RootGameTree getRootGameTree() {
        return this.rootGameTree_;
    }

    public boolean isChildrenStyle() {
        return this.rootGameTree_.getStyle().isChildrenStyle();
    }

    public SgfSize getSize() {
        return this.rootGameTree_.getSize();
    }

    public boolean isFirstNode() {
        return this.gameTree_.getSequence().getFirst() == this.node_;
    }

    public boolean isLastNode() {
        Node node = this.gameTree_.getSequence().getLast();
        return node == null ? true : node == this.node_;
    }

    private boolean hasChildVariation() {
        return this.rootGameTree_.getStyle().isChildrenStyle() && this.isLastNode();
    }

    private boolean hasSiblingVariation() {
        return !this.rootGameTree_.getStyle().isChildrenStyle() && this.isFirstNode() && this.parentGameTree_ != null;
    }

    public int getVariationSize() {
        return this.hasChildVariation() ? this.gameTree_.getChildrenSize() : (this.hasSiblingVariation() ? this.parentGameTree_.getChildrenSize() : 0);
    }

    public GameTree[] getVariation() {
        GameTree[] gameTreeArray = this.hasChildVariation() ? this.gameTree_.getChildren() : (this.hasSiblingVariation() ? this.parentGameTree_.getChildren() : new GameTree[]{});
        if (log_s_.isEnabled(LogLevel.TRACE)) {
            for (GameTree gameTree : gameTreeArray) {
                GameTree gameTree2 = Sgfs.getRoot(gameTree);
                if (gameTree2 instanceof RootGameTree) {
                    log_s_.log(LogLevel.TRACE, "{0}''s Root is {1}", gameTree, gameTree2);
                    continue;
                }
                log_s_.log(LogLevel.TRACE, "{0} does not have RootGameTree. Root is {1}", gameTree, gameTree2);
            }
        }
        return gameTreeArray;
    }
}

