/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialCommand
extends NodeListCommand {
    private final String displayName_;
    private final NodeListCommand[] commands_;

    public SequentialCommand(String string, NodeListCommand ... nodeListCommandArray) {
        ArgumentChecker.throwIfNull((Object)string);
        ArgumentChecker.throwIfNull(nodeListCommandArray);
        this.displayName_ = string;
        this.commands_ = nodeListCommandArray;
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        EnumSet<ModelInfluence> enumSet = EnumSet.noneOf(ModelInfluence.class);
        for (NodeListCommand nodeListCommand : this.commands_) {
            enumSet.addAll(nodeListCommand.getInfluence());
        }
        return enumSet;
    }

    @Override
    public String displayName() {
        return this.displayName_;
    }

    @Override
    protected boolean setup() {
        boolean bl = true;
        for (NodeListCommand nodeListCommand : this.commands_) {
            nodeListCommand.setNodeListEditor(this.getNodeListEditor());
            bl &= nodeListCommand.setup();
            this.setExecutedNodeIndex(nodeListCommand.getExecutedNodeIndex());
            this.setUndoneNodeIndex(nodeListCommand.getUndoneNodeIndex());
        }
        return bl;
    }

    @Override
    protected void executeNodeListCommand() {
        for (int i = 0; i < this.commands_.length; ++i) {
            this.commands_[i].execute();
        }
    }

    @Override
    protected void undoNodeListCommand() {
        for (int i = this.commands_.length - 1; 0 <= i; --i) {
            this.commands_[i].undo();
        }
    }
}

