/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.DbSearchToolController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.WindowControllerListener;
import org.unitarou.yukinoshita.view.jface.JFaceCollectionController;
import org.unitarou.yukinoshita.view.jface.act.JFaceMenuManager;
import org.unitarou.yukinoshita.view.jface.db.RecordFinderPanel;
import org.unitarou.yukinoshita.view.jface.gm.CollectionSingleFrame;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceWindow
extends ApplicationWindow
implements Adaptable,
WindowController {
    private static final String MARK_EDITED = "*";
    private static ImageResource[] IMG_APPS = null;
    public static final Message NT_YUKINOSHITA = new Message(JFaceWindow.class, "ntYukinoshita");
    public static final Message NT_YUKINOSHITA_FILE = new Message(JFaceWindow.class, "ntYukinoshitaFile");
    private static final ContextValue<int[]> SIZE = new ContextValue<int[]>(JFaceWindow.class, "size", new int[]{800, 640});
    private final int id_;
    private final JFaceMenuManager menuManager_;
    private CTabFolder tabFolder_;
    private final Adapter adapter_;
    private final ShellAdapter shellAdapter_;
    private final Notifier notifier_;
    private final List<WindowControllerListener> listeners_;

    public static synchronized Image[] getAppIcons() {
        if (IMG_APPS == null) {
            IMG_APPS = new ImageResource[2];
            JFaceWindow.IMG_APPS[0] = new ImageResource(JFaceWindow.class, "iconApp16.png");
            JFaceWindow.IMG_APPS[1] = new ImageResource(JFaceWindow.class, "iconApp32.png");
        }
        return new Image[]{IMG_APPS[0].get(), IMG_APPS[1].get()};
    }

    public JFaceWindow(Shell shell, int n) {
        super(shell);
        this.id_ = n;
        this.listeners_ = new ArrayList<WindowControllerListener>();
        this.menuManager_ = new JFaceMenuManager(this);
        this.tabFolder_ = null;
        super.addMenuBar();
        this.adapter_ = new Adapter();
        this.shellAdapter_ = new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                JFaceWindow.this.closeThis(shellEvent);
            }
        };
        this.notifier_ = new Notifier();
    }

    private void closeThis(ShellEvent shellEvent) {
        shellEvent.doit = this.closeAllTabs();
        if (shellEvent.doit) {
            super.close();
        }
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void create() {
        super.create();
        this.getShell().setData("widgetKey", (Object)this.shellId());
    }

    private String shellId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JFaceWindow.class.getName()).append('#').append(this.id_);
        return stringBuilder.toString();
    }

    @Override
    protected Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        Shell shell = this.getShell();
        shell.setImages(JFaceWindow.getAppIcons());
        shell.setText(NT_YUKINOSHITA.get((Object)"2.2.7"));
        if ("carbon".equals(SWT.getPlatform())) {
            shell.setLayout((Layout)new FillLayout());
        }
        this.setupDnD();
        this.tabFolder_ = new CTabFolder(composite, 2240);
        this.tabFolder_.setSimple(false);
        this.tabFolder_.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent cTabFolderEvent) {
                CollectionController collectionController = (CollectionController)cTabFolderEvent.item.getData();
                cTabFolderEvent.doit = JFaceWindow.this.closeTab(collectionController);
                if (cTabFolderEvent.doit) {
                    cTabFolderEvent.item.setData(null);
                    cTabFolderEvent.item.dispose();
                    JFaceWindow.this.changeCurrentTabItem();
                }
            }
        });
        this.tabFolder_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JFaceWindow.this.changeCurrentTabItem();
            }
        });
        Display display = this.tabFolder_.getDisplay();
        this.tabFolder_.setSelectionBackground(new Color[]{display.getSystemColor(20), display.getSystemColor(22)}, new int[]{100}, true);
        CurrentContext currentContext = Yukinoshita.context(null);
        int[] nArray = currentContext.getAttribute(SIZE);
        this.getShell().setSize(nArray[0], nArray[1]);
        return this.tabFolder_;
    }

    private void setupDnD() {
        DropTarget dropTarget = new DropTarget((Control)this.getShell(), 17);
        FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] transferArray = new Transfer[]{fileTransfer};
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                dropTargetEvent.detail = 1;
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                String[] stringArray = (String[])dropTargetEvent.data;
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    Collection collection = FileManager.instance().open(file);
                    if (collection == null) {
                        return;
                    }
                    FileManager.instance().insertFileHistory(file);
                    JFaceWindow.this.registerCollection(collection, null, false, 0);
                }
            }
        });
    }

    private void changeCurrentTabItem() {
        CollectionController collectionController = this.getActiveCollectionController();
        for (WindowControllerListener object : this.listeners_) {
            object.changeActive(collectionController);
        }
        if (collectionController != null) {
            RgtProxy rgtProxy = collectionController.getCollectionProxy().getActive();
            NodeView nodeView = rgtProxy.getCurrentNodeView();
            for (NodeMonitor nodeMonitor : collectionController.getEventBroker().getListeners(NodeMonitor.class)) {
                nodeMonitor.currentChanged(nodeView);
            }
        }
        this.updateFileInfo();
    }

    private void updateFileInfo() {
        String string;
        CTabItem cTabItem = this.tabFolder_.getSelection();
        CollectionController collectionController = this.getActiveCollectionController();
        if (cTabItem == null || collectionController == null) {
            this.getShell().setText(NT_YUKINOSHITA.get((Object)"2.2.7"));
            return;
        }
        File file = collectionController.getCollection().getFile();
        String string2 = string = file != null ? file.getName() : cTabItem.getText();
        if (string.startsWith(MARK_EDITED)) {
            string = string.substring(MARK_EDITED.length());
        }
        cTabItem.setText(collectionController.isChanged() ? MARK_EDITED + string : string);
        String string3 = file != null ? file.getAbsolutePath() : this.tabFolder_.getSelection().getText();
        this.getShell().setText(NT_YUKINOSHITA_FILE.get("2.2.7", string3));
    }

    @Override
    protected ShellListener getShellListener() {
        return this.shellAdapter_;
    }

    @Override
    protected MenuManager createMenuManager() {
        MenuManager menuManager = super.createMenuManager();
        this.menuManager_.createMenu(menuManager);
        return menuManager;
    }

    @Override
    public boolean close() {
        if (this.closeAllTabs()) {
            return super.close();
        }
        return false;
    }

    private boolean closeAllTabs() {
        for (CTabItem cTabItem : this.tabFolder_.getItems()) {
            CollectionController collectionController = (CollectionController)cTabItem.getData();
            boolean bl = this.closeTab(collectionController);
            if (!bl) {
                return false;
            }
            cTabItem.setData(null);
            cTabItem.dispose();
        }
        return true;
    }

    private boolean closeTab(CollectionController collectionController) {
        if (collectionController == null) {
            return true;
        }
        return collectionController.doClosing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCollection(Collection collection, String string, boolean bl, int n) {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() == null && string == null) {
            throw new IllegalArgumentException("No tabName");
        }
        if (collection.getFile() != null) {
            string = collection.getFile().getName();
        }
        Application application = Yukinoshita.application();
        try {
            application.setCursorType(Application.CursorType.WAIT);
            CollectionSingleFrame collectionSingleFrame = new CollectionSingleFrame();
            Control control = collectionSingleFrame.createContents((Composite)this.tabFolder_);
            CTabItem cTabItem = new CTabItem(this.tabFolder_, 0);
            cTabItem.setText(string);
            cTabItem.setControl(control);
            this.tabFolder_.setSelection(cTabItem);
            JFaceCollectionController jFaceCollectionController = new JFaceCollectionController(collection, this, collectionSingleFrame, bl, n);
            jFaceCollectionController.getEventBroker().addView(this);
            this.notifier_.setEventBroker(jFaceCollectionController.getEventBroker());
            cTabItem.setData((Object)jFaceCollectionController);
            this.changeCurrentTabItem();
        }
        finally {
            application.setCursorType(Application.CursorType.NONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDbSearch(DbSearchToolController dbSearchToolController) {
        ArgumentChecker.throwIfNull((Object)dbSearchToolController);
        Application application = Yukinoshita.application();
        try {
            application.setCursorType(Application.CursorType.WAIT);
            RecordFinderPanel recordFinderPanel = new RecordFinderPanel();
            Control control = recordFinderPanel.createContents((Composite)this.tabFolder_);
            CTabItem cTabItem = new CTabItem(this.tabFolder_, 0);
            cTabItem.setText("DB Search");
            cTabItem.setControl(control);
            this.tabFolder_.setSelection(cTabItem);
        }
        finally {
            application.setCursorType(Application.CursorType.NONE);
        }
    }

    @Override
    public CollectionController getActiveCollectionController() {
        CTabItem cTabItem = this.tabFolder_.getSelection();
        return cTabItem != null ? (CollectionController)cTabItem.getData() : null;
    }

    @Override
    public List<CollectionController> getCollectionControllers() {
        CTabItem[] cTabItemArray = this.tabFolder_.getItems();
        ArrayList<CollectionController> arrayList = new ArrayList<CollectionController>(cTabItemArray.length);
        for (int i = 0; i < cTabItemArray.length; ++i) {
            CollectionController collectionController = (CollectionController)cTabItemArray[i].getData();
            if (collectionController == null) continue;
            arrayList.add(collectionController);
        }
        return arrayList;
    }

    @Override
    public boolean closeActive() {
        CTabItem cTabItem = this.tabFolder_.getSelection();
        if (cTabItem == null) {
            return false;
        }
        CollectionController collectionController = (CollectionController)cTabItem.getData();
        if (this.closeTab(collectionController)) {
            cTabItem.setData(null);
            cTabItem.dispose();
            this.changeCurrentTabItem();
            return true;
        }
        return false;
    }

    @Override
    public void addListener(WindowControllerListener windowControllerListener) {
        if (windowControllerListener != null) {
            this.listeners_.add(windowControllerListener);
        }
    }

    @Override
    public void removeListener(WindowControllerListener windowControllerListener) {
        this.listeners_.remove(windowControllerListener);
    }

    @Override
    public void defaultLayout() {
        int[] nArray = SIZE.defaultValue();
        this.getShell().setSize(nArray[0], nArray[1]);
        CollectionController collectionController = this.getActiveCollectionController();
        if (collectionController == null) {
            return;
        }
        for (LayoutMonitor layoutMonitor : collectionController.getEventBroker().getListeners(LayoutMonitor.class)) {
            layoutMonitor.defaultLayout();
        }
    }

    @Override
    public void loadLayout() {
        CurrentContext currentContext = Yukinoshita.context(null);
        int[] nArray = currentContext.getAttribute(SIZE);
        this.getShell().setSize(nArray[0], nArray[1]);
        CollectionController collectionController = this.getActiveCollectionController();
        if (collectionController == null) {
            return;
        }
        for (LayoutMonitor layoutMonitor : collectionController.getEventBroker().getListeners(LayoutMonitor.class)) {
            layoutMonitor.loadLayout();
        }
    }

    @Override
    public void saveLayout() {
        CurrentContext currentContext = Yukinoshita.context(null);
        Point point = this.getShell().getSize();
        currentContext.setAttribute(SIZE, new int[]{point.x, point.y});
        CollectionController collectionController = this.getActiveCollectionController();
        if (collectionController == null) {
            Yukinoshita.context().save();
            return;
        }
        for (LayoutMonitor layoutMonitor : collectionController.getEventBroker().getListeners(LayoutMonitor.class)) {
            layoutMonitor.saveLayout();
        }
        Yukinoshita.context().save();
    }

    private class Notifier
    extends TieredModelEventNotifier {
        private Notifier() {
        }

        protected Adaptable[] getAdaptables() {
            return new Adaptable[]{JFaceWindow.this.menuManager_};
        }
    }

    private class Adapter
    implements GameMonitor,
    GameInfoNodeMonitor,
    NodeMonitor {
        private Adapter() {
        }

        public void update(RgtProxy rgtProxy) {
            JFaceWindow.this.updateFileInfo();
        }

        public void currentChanged(NodeView nodeView) {
            JFaceWindow.this.updateFileInfo();
        }

        public void gameInfoChanged(NodeView nodeView) {
            JFaceWindow.this.updateFileInfo();
        }
    }
}

