/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.swt.AlphaBlender;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter;

public class ClamshellStonePainter
extends AbstractStonePainter {
    private static final Message LB_DISPLAY_NAME = new Message(ClamshellStonePainter.class, "lbDisplayName");
    private static final ImageResource[] TEXTURES = new ImageResource[]{new ImageResource(ClamshellStonePainter.class, "Meretrix_lusoria_yuki_01.png"), new ImageResource(ClamshellStonePainter.class, "Meretrix_lusoria_yuki_02.png"), new ImageResource(ClamshellStonePainter.class, "Meretrix_lusoria_yuki_03.png"), new ImageResource(ClamshellStonePainter.class, "Meretrix_lusoria_yuki_04.png"), new ImageResource(ClamshellStonePainter.class, "Meretrix_lusoria_yuki_05.png"), new ImageResource(ClamshellStonePainter.class, "Meretrix_lusoria_yuki_06.png")};
    private static final ColorResource COLOR_WHITE_BODY = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_BLACK_BODY = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_WHITE_LABEL = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_BLACK_LABEL = new ColorResource(255, 255, 255);
    private static final ColorResource COLOR_LAST_LABEL = new ColorResource(255, 0, 0);
    private static final ColorResource COLOR_LAST = new ColorResource(204, 0, 0);
    private static final FontResource FONT_MOVE_NUMBER = new FontResource("Helvetica", 10, 0);

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    public ImageData[] createWhiteStone(Point point) {
        ImageData[] imageDataArray = new ImageData[TEXTURES.length];
        for (int i = 0; i < imageDataArray.length; ++i) {
            ImageData imageData = TEXTURES[i].getImageData();
            ImageData imageData2 = this.createWhiteStoneImpl(point, imageData);
            imageDataArray[i] = this.createStoneImpl(point, imageData2);
        }
        return imageDataArray;
    }

    public ImageData[] createBlackStone(Point point) {
        ImageData imageData = this.createStoneImage(point, COLOR_BLACK_BODY.get(), 0);
        byte[] byArray = this.createStoneAlpha(point, 255);
        imageData.setAlphas(0, 0, byArray.length, byArray, 0);
        return new ImageData[]{this.createStoneImpl(point, imageData)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createWhiteStoneImpl(Point point, ImageData imageData) {
        ImageData imageData2;
        ImageData imageData3 = imageData.scaledTo(point.x, point.y);
        byte[] byArray = this.createStoneAlpha(point, 80);
        imageData3.setAlphas(0, 0, byArray.length, byArray, 0);
        ImageData imageData4 = this.createStoneImage(point, COLOR_WHITE_BODY.get(), 190);
        Image image = null;
        Image image2 = null;
        GC gC = null;
        ImageData imageData5 = null;
        try {
            image = new Image(null, imageData4);
            gC = new GC((Drawable)image);
            image2 = new Image(null, imageData3);
            gC.drawImage(image2, 0, 0);
            imageData5 = image.getImageData();
            byArray = this.createStoneAlpha(point, 255);
            imageData5.setAlphas(0, 0, byArray.length, byArray, 0);
            imageData2 = imageData5;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(image2);
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly((Resource)image);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)image2);
        Swts.disposeQuietly((Resource)gC);
        Swts.disposeQuietly((Resource)image);
        return imageData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createStoneImpl(Point point, ImageData imageData) {
        ImageData imageData2;
        ImageData imageData3 = this.createShadow(point);
        byte[] byArray = new byte[imageData.alphaData.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = AlphaBlender.opaquer(imageData.alphaData[i], imageData3.alphaData[i]);
        }
        Image image = null;
        GC gC = null;
        Image image2 = null;
        try {
            image = new Image(null, imageData3);
            gC = new GC((Drawable)image);
            image2 = new Image(null, imageData);
            gC.drawImage(image2, 0, 0);
            ImageData imageData4 = image.getImageData();
            imageData4.setAlphas(0, 0, byArray.length, byArray, 0);
            imageData2 = imageData4;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(image2);
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly((Resource)image);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)image2);
        Swts.disposeQuietly((Resource)gC);
        Swts.disposeQuietly((Resource)image);
        return imageData2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createStoneAlpha(Point point, int n) {
        byte[] byArray;
        Image image = null;
        GC gC = null;
        try {
            image = new Image(null, point.x, point.y);
            gC = new GC((Drawable)image);
            gC.setBackground(ColorResource.get(new RGB(0, 0, 0)));
            gC.fillRectangle(image.getBounds());
            gC.setBackground(ColorResource.get(new RGB(n, n, n)));
            Point point2 = this.getStoneRect(point);
            gC.fillOval(0, 0, point2.x + 1, point2.y + 1);
            ImageData imageData = image.getImageData();
            byArray = AlphaBlender.createAlphaByPixels(imageData);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC);
        Swts.disposeQuietly((Resource)image);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createShadow(Point point) {
        ImageData imageData;
        Image image = null;
        GC gC = null;
        byte[] byArray = null;
        int n = this.getShadowOffset(point);
        try {
            image = new Image(null, point.x, point.y);
            gC = new GC((Drawable)image);
            gC.setBackground(ColorResource.get(new RGB(0, 0, 0)));
            gC.fillRectangle(image.getBounds());
            gC.setBackground(ColorResource.get(new RGB(160, 160, 160)));
            gC.fillOval(n * 3, n * 3, point.x - n * 3, point.y - n * 3);
            gC.setLineWidth(1);
            gC.setLineStyle(1);
            gC.setForeground(ColorResource.get(new RGB(80, 80, 80)));
            gC.drawOval(n * 3, n * 3, point.x - n * 3 - 1, point.y - n * 3 - 1);
            byArray = AlphaBlender.createAlphaByPixels(image.getImageData());
            gC.setBackground(COLOR_TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            gC.setBackground(ColorResource.get(new RGB(0, 0, 0)));
            gC.fillOval(n * 3, n * 3, point.x - n * 3 + 1, point.y - n * 3 + 1);
            ImageData imageData2 = image.getImageData();
            imageData2.setAlphas(0, 0, byArray.length, byArray, 0);
            imageData = imageData2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC);
        Swts.disposeQuietly((Resource)image);
        return imageData;
    }

    private Point getStoneRect(Point point) {
        int n = this.getShadowOffset(point);
        return new Point(point.x - n, point.y - n);
    }

    private int getShadowOffset(Point point) {
        return point.x / 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createStoneImage(Point point, Color color, int n) {
        ImageData imageData;
        Image image = null;
        GC gC = null;
        int n2 = this.getShadowOffset(point);
        try {
            image = new Image(null, point.x, point.y);
            gC = new GC((Drawable)image);
            gC.setBackground(COLOR_TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            gC.setBackground(color);
            gC.fillOval(0, 0, point.x - n2, point.y - n2);
            int n3 = -1;
            int n4 = point.x - n2 + 1;
            int n5 = n4 / 2;
            for (double d = (double)n5; d >= 1.0; d -= 1.0) {
                int n6 = (int)((double)n5 - d);
                int n7 = (int)((double)n6 / (double)n4 * 160.0 + (double)n);
                if (255 < n7) {
                    n7 = 255;
                }
                if (n3 == -1) {
                    n3 = n7;
                }
                Color color2 = new Color((Device)Display.getCurrent(), n7, n7, n7);
                gC.setBackground(color2);
                double d2 = (int)((double)n6 * 0.75);
                double d3 = (double)n4 - (double)(n6 * 4) / 3.0;
                int n8 = (int)d2;
                int n9 = (int)(d3 - d2);
                gC.fillOval(n8, n8, n9, n9);
                color2.dispose();
            }
            gC.setLineWidth(1);
            gC.setLineStyle(1);
            Color color3 = new Color((Device)Display.getCurrent(), n3, n3, n3);
            gC.setForeground(color3);
            gC.drawOval(0, 0, point.x - n2, point.y - n2);
            color3.dispose();
            ImageData imageData2 = image.getImageData();
            imageData2.transparentPixel = imageData2.getPixel(0, 0);
            imageData = imageData2;
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly(image);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC);
        Swts.disposeQuietly((Resource)image);
        return imageData;
    }

    protected void paintLabel(GC gC, Rectangle rectangle, String string, SgfColor sgfColor, boolean bl) {
        Point point = Geometry.getSize(rectangle);
        Point point2 = this.getStoneRect(point);
        int n = point2.x;
        gC.setFont(FONT_MOVE_NUMBER.getInCircle(gC, string, n));
        Point point3 = gC.textExtent(string);
        Color color = bl ? COLOR_LAST_LABEL.get() : (SgfColor.BLACK.equals(sgfColor) ? COLOR_BLACK_LABEL.get() : COLOR_WHITE_LABEL.get());
        int n2 = this.getShadowOffset(point) / 2;
        gC.setForeground(color);
        gC.drawText(string, rectangle.x + rectangle.width / 2 - point3.x / 2 - n2, rectangle.y + rectangle.height / 2 - point3.y / 2 - n2, true);
    }

    protected void paintLastMoveMark(GC gC, Rectangle rectangle, SgfColor sgfColor) {
        Point point = this.getStoneRect(Geometry.getSize(rectangle));
        rectangle = Geometry.createRectangle(Geometry.getLocation(rectangle), point);
        gC.setLineWidth(2);
        gC.setLineStyle(1);
        gC.setBackground(COLOR_LAST.get());
        Rectangle rectangle2 = Rectangles.createScaled(rectangle, 0.4);
        gC.fillOval(rectangle2.x, rectangle2.y, rectangle2.width + 1, rectangle2.height + 1);
    }
}

