/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.HashSet;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.sgf.util.RootGameTreeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FingerprintQuery {
    private boolean enableInverse_ = true;
    private SgfSize sgfSize_;
    private byte[][] nonTargetAreas_;
    private byte[][] fingerprints_;
    private int similarity_;
    private boolean isEnabled_;

    public FingerprintQuery() {
        this.createCondition(RootGameTreeFactory.createGame(SgfSize.DEFAULT, new Handicap(0)), new HashSet<SgfPoint>(SgfSize.DEFAULT.all()));
        this.similarity_ = 0;
    }

    public void setCondition(RootGameTree rootGameTree, Set<SgfPoint> set, int n) {
        ArgumentChecker.throwIfNull((Object)rootGameTree, set);
        this.similarity_ = n;
        this.createCondition(rootGameTree, set);
    }

    private void createCondition(RootGameTree rootGameTree, Set<SgfPoint> set) {
        this.sgfSize_ = rootGameTree.getSize();
        this.fingerprints_ = Fingerprints.calcAllFingerprint(rootGameTree);
        this.nonTargetAreas_ = Fingerprints.calcAllFingerprint(this.sgfSize_, set, (byte)0, (byte)3);
        if (!this.enableInverse_) {
            return;
        }
    }

    public boolean isEnabled() {
        return this.isEnabled_;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled_ = bl;
    }

    public byte[][] getFingerprints() {
        return this.fingerprints_;
    }

    public byte[][] getNonTargetAreas() {
        return this.nonTargetAreas_;
    }

    public SgfSize getSgfSize() {
        return this.sgfSize_;
    }

    public int getSimilarity() {
        return this.similarity_;
    }
}

