/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebErrorPrivate;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.CERT_CONTEXT;
import org.eclipse.swt.internal.win32.CERT_INFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class WebFrameLoadDelegate {
    COMObject iWebFrameLoadDelegate;
    int refCount = 0;
    Browser browser;
    String html;
    String url;
    static final String OBJECTNAME_EXTERNAL = "external";

    WebFrameLoadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    void addEventHandlers(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('keydown', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
            stringBuffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
            this.browser.execute(stringBuffer.toString());
            stringBuffer = new StringBuffer("window.SWTmousehandler = function SWTmousehandler(e) {");
            stringBuffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button + 1, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            stringBuffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseover', SWTmousehandler, true);");
            stringBuffer.append("document.addEventListener('mouseout', SWTmousehandler, true);");
            this.browser.execute(stringBuffer.toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer("for (var i = 0; i < frames.length; i++) {");
            stringBuffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            stringBuffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            stringBuffer.append('}');
            this.browser.execute(stringBuffer.toString());
        }
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[17];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 3;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 2;
        nArray[12] = 5;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 3;
        nArray[16] = 4;
        this.iWebFrameLoadDelegate = new COMObject(nArray){

            public long method0(long[] lArray) {
                return WebFrameLoadDelegate.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return WebFrameLoadDelegate.this.AddRef();
            }

            public long method2(long[] lArray) {
                return WebFrameLoadDelegate.this.Release();
            }

            public long method3(long[] lArray) {
                return WebFrameLoadDelegate.this.didStartProvisionalLoadForFrame(lArray[0], lArray[1]);
            }

            public long method4(long[] lArray) {
                return -2147467263L;
            }

            public long method5(long[] lArray) {
                return WebFrameLoadDelegate.this.didFailProvisionalLoadWithError(lArray[0], lArray[1], lArray[2]);
            }

            public long method6(long[] lArray) {
                return WebFrameLoadDelegate.this.didCommitLoadForFrame(lArray[0], lArray[1]);
            }

            public long method7(long[] lArray) {
                return WebFrameLoadDelegate.this.didReceiveTitle(lArray[0], lArray[1], lArray[2]);
            }

            public long method8(long[] lArray) {
                return -2147467263L;
            }

            public long method9(long[] lArray) {
                return WebFrameLoadDelegate.this.didFinishLoadForFrame(lArray[0], lArray[1]);
            }

            public long method10(long[] lArray) {
                return -2147467263L;
            }

            public long method11(long[] lArray) {
                return WebFrameLoadDelegate.this.didChangeLocationWithinPageForFrame(lArray[0], lArray[1]);
            }

            public long method12(long[] lArray) {
                return 0L;
            }

            public long method13(long[] lArray) {
                return -2147467263L;
            }

            public long method14(long[] lArray) {
                return 0L;
            }

            public long method15(long[] lArray) {
                return 0L;
            }

            public long method16(long[] lArray) {
                return WebFrameLoadDelegate.this.didClearWindowObject(lArray[0], lArray[1], lArray[2], lArray[3]);
            }
        };
        long l = this.iWebFrameLoadDelegate.ppVtable;
        long[] lArray = new long[1];
        COM.MoveMemory(lArray, l, OS.PTR_SIZEOF);
        long[] lArray2 = new long[17];
        COM.MoveMemory(lArray2, lArray[0], OS.PTR_SIZEOF * lArray2.length);
        lArray2[12] = WebKit_win32.willPerformClientRedirectToURL_CALLBACK(lArray2[12]);
        COM.MoveMemory(lArray[0], lArray2, OS.PTR_SIZEOF * lArray2.length);
    }

    int didChangeLocationWithinPageForFrame(long l, long l2) {
        int n;
        SWTEventListener[] sWTEventListenerArray;
        TypedEvent typedEvent;
        IWebFrame iWebFrame = new IWebFrame(l2);
        long[] lArray = new long[1];
        int n2 = iWebFrame.dataSource(lArray);
        if (n2 != 0 || lArray[0] == 0L) {
            return 0;
        }
        IWebDataSource iWebDataSource = new IWebDataSource(lArray[0]);
        lArray[0] = 0L;
        n2 = iWebDataSource.request(lArray);
        iWebDataSource.Release();
        if (n2 != 0 || lArray[0] == 0L) {
            return 0;
        }
        IWebURLRequest iWebURLRequest = new IWebURLRequest(lArray[0]);
        lArray[0] = 0L;
        n2 = iWebURLRequest.URL(lArray);
        iWebURLRequest.Release();
        if (n2 != 0 || lArray[0] == 0L) {
            return 0;
        }
        String string = WebKit.extractBSTR(lArray[0]);
        COM.SysFreeString(lArray[0]);
        if (string.length() == 0) {
            return 0;
        }
        if (string.equals("file:///")) {
            string = "about:blank";
        } else {
            int n3 = "file:///".length();
            if (string.startsWith("file:///") && string.charAt(n3) == '#') {
                string = "about:blank" + string.substring(n3);
            }
        }
        Display display = this.browser.getDisplay();
        lArray[0] = 0L;
        IWebView iWebView = new IWebView(l);
        n2 = iWebView.mainFrame(lArray);
        boolean bl = false;
        if (n2 == 0 && lArray[0] != 0L) {
            bl = l2 == lArray[0];
            new IWebFrame(lArray[0]).Release();
        }
        if (bl) {
            typedEvent = new StatusTextEvent(this.browser);
            typedEvent.display = display;
            typedEvent.widget = this.browser;
            typedEvent.text = string;
            sWTEventListenerArray = this.browser.webBrowser.statusTextListeners;
            n = 0;
            while (n < sWTEventListenerArray.length) {
                sWTEventListenerArray[n].changed((StatusTextEvent)typedEvent);
                ++n;
            }
        }
        typedEvent = new LocationEvent(this.browser);
        ((LocationEvent)typedEvent).display = display;
        ((LocationEvent)typedEvent).widget = this.browser;
        ((LocationEvent)typedEvent).location = string;
        ((LocationEvent)typedEvent).top = bl;
        sWTEventListenerArray = this.browser.webBrowser.locationListeners;
        n = 0;
        while (n < sWTEventListenerArray.length) {
            sWTEventListenerArray[n].changed((LocationEvent)typedEvent);
            ++n;
        }
        return 0;
    }

    int didClearWindowObject(long l, long l2, long l3, long l4) {
        Object object;
        WebKit_win32.JSGlobalContextRetain(l2);
        long l5 = WebKit_win32.JSContextGetGlobalObject(l2);
        long l6 = ((WebKit)this.browser.webBrowser).webViewData;
        long l7 = WebKit_win32.JSObjectMake(l2, WebKit.ExternalClass, l6);
        byte[] byArray = null;
        try {
            byArray = "external\u0000".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = "external\u0000".getBytes();
        }
        long l8 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        WebKit_win32.JSObjectSetProperty(l2, l5, l8, l7, 0L, null);
        WebKit_win32.JSStringRelease(l8);
        Enumeration enumeration = this.browser.webBrowser.functions.elements();
        while (enumeration.hasMoreElements()) {
            object = (BrowserFunction)enumeration.nextElement();
            this.browser.execute(((BrowserFunction)object).functionString);
        }
        object = new IWebView(l);
        long[] lArray = new long[1];
        ((IWebView)object).mainFrame(lArray);
        boolean bl = lArray[0] == l4;
        new IWebFrame(lArray[0]).Release();
        this.addEventHandlers(bl);
        return 0;
    }

    int didCommitLoadForFrame(long l, long l2) {
        LocationListener[] locationListenerArray;
        Object object;
        IWebFrame iWebFrame = new IWebFrame(l2);
        long[] lArray = new long[1];
        int n = iWebFrame.dataSource(lArray);
        if (n != 0 || lArray[0] == 0L) {
            return 0;
        }
        IWebDataSource iWebDataSource = new IWebDataSource(lArray[0]);
        lArray[0] = 0L;
        n = iWebDataSource.request(lArray);
        iWebDataSource.Release();
        if (n != 0 || lArray[0] == 0L) {
            return 0;
        }
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(lArray[0]);
        lArray[0] = 0L;
        n = iWebMutableURLRequest.URL(lArray);
        iWebMutableURLRequest.Release();
        if (n != 0 || lArray[0] == 0L) {
            return 0;
        }
        String string = WebKit.extractBSTR(lArray[0]);
        COM.SysFreeString(lArray[0]);
        if (string.length() == 0) {
            return 0;
        }
        if (string.equals("file:///")) {
            string = "about:blank";
        } else {
            int n2 = "file:///".length();
            if (string.startsWith("file:///") && string.charAt(n2) == '#') {
                string = "about:blank" + string.substring(n2);
            }
        }
        Display display = this.browser.getDisplay();
        lArray[0] = 0L;
        IWebView iWebView = new IWebView(l);
        n = iWebView.mainFrame(lArray);
        boolean bl = false;
        if (n == 0 && lArray[0] != 0L) {
            bl = l2 == lArray[0];
            new IWebFrame(lArray[0]).Release();
        }
        if (bl) {
            this.url = string;
            if (string.startsWith("about:blank") && this.html != null) {
                return 0;
            }
            object = this.browser.webBrowser.functions.elements();
            while (object.hasMoreElements()) {
                locationListenerArray = (BrowserFunction)object.nextElement();
                this.browser.webBrowser.execute(locationListenerArray.functionString);
            }
            locationListenerArray = new ProgressEvent(this.browser);
            locationListenerArray.display = display;
            locationListenerArray.widget = this.browser;
            locationListenerArray.current = 1;
            locationListenerArray.total = 100;
            ProgressListener[] progressListenerArray = this.browser.webBrowser.progressListeners;
            int n3 = 0;
            while (n3 < progressListenerArray.length) {
                progressListenerArray[n3].changed((ProgressEvent)locationListenerArray);
                ++n3;
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = display;
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            StatusTextListener[] statusTextListenerArray = this.browser.webBrowser.statusTextListeners;
            int n4 = 0;
            while (n4 < statusTextListenerArray.length) {
                statusTextListenerArray[n4].changed(statusTextEvent);
                ++n4;
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
        }
        object = new LocationEvent(this.browser);
        ((LocationEvent)object).display = display;
        ((LocationEvent)object).widget = this.browser;
        ((LocationEvent)object).location = string;
        ((LocationEvent)object).top = bl;
        locationListenerArray = this.browser.webBrowser.locationListeners;
        int n5 = 0;
        while (n5 < locationListenerArray.length) {
            locationListenerArray[n5].changed((LocationEvent)object);
            ++n5;
        }
        return 0;
    }

    int didFailProvisionalLoadWithError(long l, long l2, long l3) {
        IWebError iWebError = new IWebError(l2);
        int[] nArray = new int[1];
        int n = iWebError.code(nArray);
        if (-1000 < nArray[0]) {
            return 0;
        }
        String string = null;
        long[] lArray = new long[1];
        n = iWebError.failingURL(lArray);
        if (n == 0 && lArray[0] != 0L) {
            string = WebKit.extractBSTR(lArray[0]);
            COM.SysFreeString(lArray[0]);
        }
        if (string != null && -1204 <= nArray[0] && nArray[0] <= -1200) {
            long[] lArray2 = new long[1];
            n = iWebError.localizedDescription(lArray2);
            if (n != 0 || lArray2[0] == 0L) {
                return 0;
            }
            String string2 = WebKit.extractBSTR(lArray2[0]);
            COM.SysFreeString(lArray2[0]);
            lArray2[0] = 0L;
            n = iWebError.QueryInterface(WebKit_win32.IID_IWebErrorPrivate, lArray2);
            if (n != 0 || lArray2[0] == 0L) {
                return 0;
            }
            IWebErrorPrivate iWebErrorPrivate = new IWebErrorPrivate(lArray2[0]);
            lArray2[0] = 0L;
            long[] lArray3 = new long[1];
            n = iWebErrorPrivate.sslPeerCertificate(lArray3);
            iWebErrorPrivate.Release();
            if (n != 0 || lArray3[0] == 0L) {
                return 0;
            }
            if (this.showCertificateDialog(l, string, string2, lArray3[0])) {
                IWebFrame iWebFrame = new IWebFrame(l3);
                n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebMutableURLRequest, 0L, WebKit_win32.IID_IWebMutableURLRequest, lArray2);
                if (n != 0 || lArray2[0] == 0L) {
                    lArray3[0] = 0L;
                    return 0;
                }
                IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(lArray2[0]);
                iWebMutableURLRequest.setURL(lArray[0]);
                iWebMutableURLRequest.setAllowsAnyHTTPSCertificate();
                iWebFrame.loadRequest(iWebMutableURLRequest.getAddress());
                iWebMutableURLRequest.Release();
            }
            lArray3[0] = 0L;
            return 0;
        }
        long[] lArray4 = new long[1];
        n = iWebError.localizedDescription(lArray4);
        if (n != 0 || lArray4[0] == 0L) {
            return 0;
        }
        String string3 = WebKit.extractBSTR(lArray4[0]);
        COM.SysFreeString(lArray4[0]);
        if (!this.browser.isDisposed()) {
            String string4 = string != null ? String.valueOf(string) + "\n\n" : "";
            string4 = String.valueOf(string4) + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{string3});
            MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
            messageBox.setMessage(string4);
            messageBox.open();
        }
        return 0;
    }

    int didFinishLoadForFrame(long l, long l2) {
        Object object;
        IWebView iWebView = new IWebView(l);
        long[] lArray = new long[1];
        int n = iWebView.mainFrame(lArray);
        if (n != 0 || lArray[0] == 0L) {
            return 0;
        }
        boolean bl = l2 == lArray[0];
        new IWebFrame(lArray[0]).Release();
        if (!bl) {
            return 0;
        }
        if (this.html != null && this.getUrl().startsWith("about:blank")) {
            ((WebKit)this.browser.webBrowser).loadingText = true;
            long l3 = WebKit.createBSTR(this.html);
            long l4 = ((WebKit)this.browser.webBrowser).untrustedText ? WebKit.createBSTR("about:blank") : WebKit.createBSTR("file:///");
            object = new IWebFrame(l2);
            ((IWebFrame)object).loadHTMLString(l3, l4);
            this.html = null;
        }
        if (!((WebKit)this.browser.webBrowser).loadingText) {
            int n2;
            SWTEventListener[] sWTEventListenerArray;
            TypedEvent typedEvent;
            if (this.browser.isDisposed()) {
                return 0;
            }
            Display display = this.browser.getDisplay();
            IWebFrame iWebFrame = new IWebFrame(l2);
            long[] lArray2 = new long[1];
            n = iWebFrame.dataSource(lArray2);
            if (n != 0 || lArray2[0] == 0L) {
                return 0;
            }
            IWebDataSource iWebDataSource = new IWebDataSource(lArray2[0]);
            lArray2[0] = 0L;
            n = iWebDataSource.pageTitle(lArray2);
            iWebDataSource.Release();
            if (n != 0) {
                return 0;
            }
            object = null;
            if (lArray2[0] != 0L) {
                object = WebKit.extractBSTR(lArray2[0]);
                COM.SysFreeString(lArray2[0]);
            }
            if (object == null || ((String)object).length() == 0) {
                typedEvent = new TitleEvent(this.browser);
                typedEvent.display = display;
                typedEvent.widget = this.browser;
                typedEvent.title = this.getUrl();
                sWTEventListenerArray = this.browser.webBrowser.titleListeners;
                n2 = 0;
                while (n2 < sWTEventListenerArray.length) {
                    sWTEventListenerArray[n2].changed((TitleEvent)typedEvent);
                    ++n2;
                }
                if (this.browser.isDisposed()) {
                    return 0;
                }
            }
            typedEvent = new ProgressEvent(this.browser);
            ((ProgressEvent)typedEvent).display = display;
            ((ProgressEvent)typedEvent).widget = this.browser;
            ((ProgressEvent)typedEvent).current = 100;
            ((ProgressEvent)typedEvent).total = 100;
            sWTEventListenerArray = this.browser.webBrowser.progressListeners;
            n2 = 0;
            while (n2 < sWTEventListenerArray.length) {
                sWTEventListenerArray[n2].completed((ProgressEvent)typedEvent);
                ++n2;
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
        }
        ((WebKit)this.browser.webBrowser).loadingText = false;
        return 0;
    }

    int didReceiveTitle(long l, long l2, long l3) {
        IWebView iWebView = new IWebView(l);
        long[] lArray = new long[1];
        int n = iWebView.mainFrame(lArray);
        if (n != 0 || l3 == 0L) {
            return 0;
        }
        if (l3 == lArray[0]) {
            String string = WebKit.extractBSTR(l2);
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            TitleListener[] titleListenerArray = this.browser.webBrowser.titleListeners;
            int n2 = 0;
            while (n2 < titleListenerArray.length) {
                titleListenerArray[n2].changed(titleEvent);
                ++n2;
            }
        }
        new IWebFrame(lArray[0]).Release();
        return 0;
    }

    int didStartProvisionalLoadForFrame(long l, long l2) {
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebFrameLoadDelegate != null) {
            this.iWebFrameLoadDelegate.dispose();
            this.iWebFrameLoadDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebFrameLoadDelegate.getAddress();
    }

    String getUrl() {
        if (this.url == null || this.url.length() == 0) {
            return "about:blank";
        }
        return this.url;
    }

    int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(l2, new long[]{this.iWebFrameLoadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebFrameLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebFrameLoadDelegate)) {
            COM.MoveMemory(l2, new long[]{this.iWebFrameLoadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebFrameLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    boolean showCertificateDialog(long l, String string, String string2, final long l2) {
        Shell shell = this.browser.getShell();
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setText(Compatibility.getMessage("SWT_InvalidCert_Title"));
        shell2.setLayout(new GridLayout());
        Label label = new Label(shell2, 64);
        String string3 = null;
        try {
            string3 = new URL(string).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            string3 = string;
        }
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(Compatibility.getMessage("SWT_InvalidCert_Message", new String[]{string3}));
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage(string2));
        stringBuffer.append("\n");
        stringBuffer.append(Compatibility.getMessage("SWT_InvalidCert_Connect"));
        stringBuffer.append("\n");
        label.setText(stringBuffer.toString());
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n2, n);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final boolean[] blArray = new boolean[1];
        final Button[] buttonArray = new Button[3];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == buttonArray[2]) {
                    WebFrameLoadDelegate.this.showCertificate(shell2, l2);
                } else {
                    blArray[0] = event.widget == buttonArray[0];
                    shell2.close();
                }
            }
        };
        Composite composite = new Composite(shell2, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(3, true));
        buttonArray[0] = new Button(composite, 8);
        buttonArray[0].setText(SWT.getMessage("SWT_Continue"));
        buttonArray[0].setLayoutData(new GridData(768));
        buttonArray[0].addListener(13, listener);
        buttonArray[1] = new Button(composite, 8);
        buttonArray[1].setText(SWT.getMessage("SWT_Cancel"));
        buttonArray[1].setLayoutData(new GridData(768));
        buttonArray[1].addListener(13, listener);
        buttonArray[2] = new Button(composite, 8);
        buttonArray[2].setText(SWT.getMessage("SWT_ViewCertificate"));
        buttonArray[2].setLayoutData(new GridData(768));
        buttonArray[2].addListener(13, listener);
        shell2.setDefaultButton(buttonArray[0]);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n3 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n4 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n3, n4);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return blArray[0];
    }

    void showCertificate(Shell shell, long l) {
        Object object;
        CERT_CONTEXT cERT_CONTEXT = new CERT_CONTEXT();
        OS.MoveMemory(cERT_CONTEXT, l, CERT_CONTEXT.sizeof);
        CERT_INFO cERT_INFO = new CERT_INFO();
        OS.MoveMemory(cERT_INFO, cERT_CONTEXT.pCertInfo, CERT_INFO.sizeof);
        int n = OS.CertNameToStr(1, cERT_INFO.Issuer, 1, null, 0);
        TCHAR tCHAR = new TCHAR(0, n);
        OS.CertNameToStr(1, cERT_INFO.Issuer, 1, tCHAR, n);
        String string = tCHAR.toString(0, tCHAR.strlen());
        n = OS.CertNameToStr(1, cERT_INFO.Subject, 1, null, 0);
        tCHAR = new TCHAR(0, n);
        OS.CertNameToStr(1, cERT_INFO.Subject, 1, tCHAR, n);
        String string2 = tCHAR.toString(0, tCHAR.strlen());
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        OS.FileTimeToSystemTime(cERT_INFO.NotBefore, sYSTEMTIME);
        String string3 = String.valueOf(sYSTEMTIME.wDay) + "/" + sYSTEMTIME.wMonth + "/" + sYSTEMTIME.wYear;
        String string4 = String.valueOf(sYSTEMTIME.wHour) + ":" + sYSTEMTIME.wMinute + ":" + sYSTEMTIME.wSecond;
        sYSTEMTIME = new SYSTEMTIME();
        OS.FileTimeToSystemTime(cERT_INFO.NotAfter, sYSTEMTIME);
        String string5 = String.valueOf(sYSTEMTIME.wDay) + "/" + sYSTEMTIME.wMonth + "/" + sYSTEMTIME.wYear;
        String string6 = String.valueOf(sYSTEMTIME.wHour) + ":" + sYSTEMTIME.wMinute + ":" + sYSTEMTIME.wSecond;
        n = cERT_INFO.SerialNumber.cbData;
        byte[] byArray = new byte[n];
        OS.MoveMemory(byArray, cERT_INFO.SerialNumber.pbData, n);
        String string7 = new String();
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = 0xFF & byArray[n2];
            object = Integer.toHexString(n3);
            if (((String)object).length() == 1) {
                string7 = String.valueOf(string7) + "0";
            }
            string7 = String.valueOf(string7) + (String)object + " ";
            --n2;
        }
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setText(SWT.getMessage("SWT_Certificate"));
        shell2.setLayout(new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(shell2, 0);
        tabFolder.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        tabFolder.setLayout(new FillLayout());
        object = new TabItem(tabFolder, 0);
        ((TabItem)object).setText(SWT.getMessage("SWT_General"));
        Composite composite = new Composite(tabFolder, 2048);
        composite.setLayout(new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(1, 0x1000000, false, false));
        label.setText(Compatibility.getMessage("SWT_IssuedTo", new Object[]{string2}));
        Label label2 = new Label(composite, 0);
        label2.setLayoutData(new GridData(1, 0x1000000, false, false));
        label2.setText(Compatibility.getMessage("SWT_IssuedFrom", new Object[]{string}));
        Label label3 = new Label(composite, 0);
        label3.setLayoutData(new GridData(1, 0x1000000, false, false));
        label3.setText(Compatibility.getMessage("SWT_ValidFromTo", new Object[]{string3, string5}));
        ((TabItem)object).setControl(composite);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SWT.getMessage("SWT_Details"));
        Table table = new Table(tabFolder, 67588);
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(SWT.getMessage("SWT_Field"));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(SWT.getMessage("SWT_Value"));
        TableItem tableItem = new TableItem(table, 0);
        String string8 = "V" + String.valueOf(cERT_INFO.dwVersion + 1);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Version"), string8});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_SerialNumber"), string7});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Issuer"), string});
        tableItem = new TableItem(table, 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(", ");
        stringBuffer.append(string4);
        stringBuffer.append(" GMT");
        tableItem.setText(new String[]{SWT.getMessage("SWT_ValidFrom"), stringBuffer.toString()});
        tableItem = new TableItem(table, 0);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string5);
        stringBuffer2.append(", ");
        stringBuffer2.append(string6);
        stringBuffer2.append(" GMT");
        tableItem.setText(new String[]{SWT.getMessage("SWT_ValidTo"), stringBuffer2.toString()});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Subject"), string2});
        int n4 = 0;
        while (n4 < table.getColumnCount()) {
            table.getColumn(n4).pack();
            ++n4;
        }
        tabItem.setControl(table);
        Button button = new Button(shell2, 8);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        gridData.widthHint = 75;
        button.setLayoutData(gridData);
        button.setText(SWT.getMessage("SWT_OK"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        shell2.pack();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        int n5 = shell.getLocation().x + (rectangle.width - rectangle2.width) / 2;
        int n6 = shell.getLocation().y + (rectangle.height - rectangle2.height) / 2;
        shell2.setLocation(n5, n6);
        shell2.open();
        Display display = this.browser.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

