/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

public class CTabItem
extends Item {
    CTabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    Control control;
    String toolTipText;
    String shortenedText;
    int shortenedTextWidth;
    Font font;
    Image disabledImage;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    int closeImageState = 8;
    int state = 0;
    boolean showClose = false;
    boolean showing = false;

    public CTabItem(CTabFolder cTabFolder, int n) {
        this(cTabFolder, n, cTabFolder.getItemCount());
    }

    public CTabItem(CTabFolder cTabFolder, int n, int n2) {
        super(cTabFolder, n);
        this.showClose = (n & 0x40) != 0;
        cTabFolder.createItem(this, n2);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.shortenedText = null;
        this.font = null;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public CTabFolder getParent() {
        return this.parent;
    }

    public boolean getShowClose() {
        this.checkWidget();
        return this.showClose;
    }

    public String getToolTipText() {
        String string;
        this.checkWidget();
        if (this.toolTipText == null && this.shortenedText != null && !this.shortenedText.equals(string = this.getText())) {
            return string;
        }
        return this.toolTipText;
    }

    public boolean isShowing() {
        this.checkWidget();
        return this.showing;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int n = this.parent.indexOf(this);
            if (n == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                int n2 = this.parent.getSelectionIndex();
                Control control2 = null;
                if (n2 != -1) {
                    control2 = this.parent.getItem(n2).getControl();
                }
                if (this.control != control2) {
                    this.control.setVisible(false);
                }
            }
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.disabledImage = image;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (font == null && this.font == null) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        Image image2 = this.getImage();
        if (image == null && image2 == null) {
            return;
        }
        if (image != null && image.equals(image2)) {
            return;
        }
        super.setImage(image);
        if (!this.parent.updateTabHeight(false)) {
            if (image2 != null && image != null) {
                Rectangle rectangle = image2.getBounds();
                Rectangle rectangle2 = image.getBounds();
                if (rectangle2.width == rectangle.width && rectangle2.height == rectangle.height) {
                    if (this.showing) {
                        boolean bl;
                        int n = this.parent.indexOf(this);
                        boolean bl2 = bl = n == this.parent.selectedIndex;
                        if (bl || this.parent.showUnselectedImage) {
                            int n2;
                            CTabFolderRenderer cTabFolderRenderer = this.parent.renderer;
                            Rectangle rectangle3 = cTabFolderRenderer.computeTrim(n, 0, 0, 0, 0, 0);
                            int n3 = this.x - rectangle3.x;
                            if (bl) {
                                GC gC = new GC(this.parent);
                                if (this.parent.single && (this.parent.showClose || this.showClose)) {
                                    n3 += cTabFolderRenderer.computeSize((int)-8, (int)0, (GC)gC, (int)-1, (int)-1).x;
                                }
                                int n4 = Math.min(this.x + this.width, this.parent.getRightItemEdge(gC));
                                gC.dispose();
                                n2 = n4 - n3 - (rectangle3.width + rectangle3.x);
                                if (!this.parent.single && this.closeRect.width > 0) {
                                    n2 -= this.closeRect.width + 4;
                                }
                            } else {
                                n2 = this.x + this.width - n3 - (rectangle3.width + rectangle3.x);
                                if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                                    n2 -= this.closeRect.width + 4;
                                }
                            }
                            if (rectangle2.width < n2) {
                                int n5 = this.y + (this.height - rectangle2.height) / 2 + (this.parent.onBottom ? -1 : 1);
                                this.parent.redraw(n3, n5, rectangle2.width, rectangle2.height, false);
                            }
                        }
                    }
                    return;
                }
            }
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setShowClose(boolean bl) {
        this.checkWidget();
        if (this.showClose == bl) {
            return;
        }
        this.showClose = bl;
        this.parent.updateItems();
        this.parent.redrawTabs();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        this.shortenedText = null;
        this.shortenedTextWidth = 0;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

