/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;

public final class FontData {
    public String name;
    public float height;
    public int style;
    public byte[] string;
    String lang;
    String country;
    String variant;

    public FontData() {
        this("", 12, 0);
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = 0;
        int n2 = string.indexOf(124);
        if (n2 == -1) {
            SWT.error(5);
        }
        String string2 = string.substring(n, n2);
        try {
            if (Integer.parseInt(string2) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((n2 = string.indexOf(124, n = n2 + 1)) == -1) {
            SWT.error(5);
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            SWT.error(5);
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        if (n2 == -1) {
            SWT.error(5);
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        this.setName(string3);
        this.setHeight(f);
        this.setStyle(n3);
        if (n2 == -1) {
            return;
        }
        String string4 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            return;
        }
        String string5 = string.substring(n, n2);
        if (string4.equals("GTK") && string5.equals("1")) {
            return;
        }
    }

    public FontData(String string, int n, int n2) {
        this.setName(string);
        this.setHeight(n);
        this.setStyle(n2);
    }

    FontData(String string, float f, int n) {
        this.setName(string);
        this.setHeight(f);
        this.setStyle(n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData fontData = (FontData)object;
        return this.name.equals(fontData.name) && this.height == fontData.height && this.style == fontData.style;
    }

    public int getHeight() {
        return (int)(0.5f + this.height);
    }

    float getHeightF() {
        return this.height;
    }

    public String getLocale() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '_';
        if (this.lang != null) {
            stringBuffer.append(this.lang);
            stringBuffer.append(c);
        }
        if (this.country != null) {
            stringBuffer.append(this.country);
            stringBuffer.append(c);
        }
        if (this.variant != null) {
            stringBuffer.append(this.variant);
        }
        if ((n = (string = stringBuffer.toString()).length()) > 0 && string.charAt(n - 1) == c) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.getHeight() << 8 ^ this.style;
    }

    public void setHeight(int n) {
        if (n < 0) {
            SWT.error(5);
        }
        this.height = n;
        this.string = null;
    }

    void setHeight(float f) {
        if (f < 0.0f) {
            SWT.error(5);
        }
        this.height = f;
        this.string = null;
    }

    public void setLocale(String string) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (string != null) {
            int n;
            int n2 = 95;
            int n3 = string.length();
            int n4 = string.indexOf(n2);
            if (n4 == -1) {
                n4 = n = n3;
            } else {
                n = string.indexOf(n2, n4 + 1);
                if (n == -1) {
                    n = n3;
                }
            }
            if (n4 > 0) {
                this.lang = string.substring(0, n4);
            }
            if (n > n4 + 1) {
                this.country = string.substring(n4 + 1, n);
            }
            if (n3 > n + 1) {
                this.variant = string.substring(n + 1);
            }
        }
    }

    public void setName(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.name = string;
        this.string = null;
    }

    public void setStyle(int n) {
        this.style = n;
        this.string = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("1|");
        stringBuffer.append(this.getName());
        stringBuffer.append("|");
        stringBuffer.append(this.getHeightF());
        stringBuffer.append("|");
        stringBuffer.append(this.getStyle());
        stringBuffer.append("|");
        stringBuffer.append("GTK|1|");
        return stringBuffer.toString();
    }
}

