/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.io;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.IntComparator;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.util.StopWatch;
import org.unitarou.util.Units;

public class FileMappedIntArray
implements Closeable {
    private static final Log log_s_;
    private static final String TEMP_FILE_PREFIX = "org_unitarou_lang_io_IntFileMapList";
    private static final String TEMP_FILE_POSTFIX = ".mia";
    private static final Pattern TEMP_PATTERN;
    private final File mapFile_;
    private final RandomAccessFile raf_;
    private final FileChannel fc_;
    private long arrayLength_;
    private int windowSize_;
    private transient int numOfWindows_;
    private int numOfHeapSortThread_;
    private int numOfMergeSortThread_;
    private final AccessWindowMap accessWindowMap_;

    public FileMappedIntArray(File file) throws IOException {
        this(file, 524288, 4);
    }

    public FileMappedIntArray(File file, int n, int n2) throws IOException {
        ArgumentChecker.throwIfNull((Object)file);
        ArgumentChecker.throwIfOutOfBounds(n, 1L, Integer.MAX_VALUE);
        ArgumentChecker.throwIfOutOfBounds(n2, 2L, 65536L);
        this.windowSize_ = n;
        this.numOfWindows_ = n2;
        this.numOfHeapSortThread_ = this.calcThreadOfUpperLimitInHeapSort();
        this.numOfMergeSortThread_ = this.calcThreadOfUpperLimitInMergeSort();
        this.accessWindowMap_ = new AccessWindowMap();
        this.mapFile_ = file;
        this.raf_ = new RandomAccessFile(this.mapFile_, "rw");
        this.fc_ = this.raf_.getChannel();
        FileLock fileLock = this.fc_.tryLock();
        if (fileLock == null) {
            Ios.closeQuietly((Closeable)this);
            throw new IOException("Can't get file lock");
        }
        this.arrayLength_ = this.fc_.size() / 4L;
    }

    private int calcThreadOfUpperLimitInHeapSort() {
        return Math.min(this.numOfWindows_, Runtime.getRuntime().availableProcessors() + 1);
    }

    private int calcThreadOfUpperLimitInMergeSort() {
        return Math.min(Math.max(this.numOfWindows_ / 2, 1), Runtime.getRuntime().availableProcessors() + 1);
    }

    public File getMapFile() {
        return this.mapFile_;
    }

    public void setWindowSize(int n) {
        ArgumentChecker.throwIfOutOfBounds(n, 1L, Integer.MAX_VALUE);
        this.flash();
        this.windowSize_ = n;
    }

    public int getWindowSize() {
        return this.windowSize_;
    }

    public void setNumOfWindows(int n) {
        ArgumentChecker.throwIfOutOfBounds(n, 2L, 65536L);
        this.flash();
        this.numOfWindows_ = n;
    }

    public int getNumOfWindows() {
        return this.numOfWindows_;
    }

    public int getNumOfHeapSortThread() {
        return this.numOfHeapSortThread_;
    }

    public void setNumOfHeapSortThread(int n) {
        ArgumentChecker.throwIfZeroOrLess(n);
        this.numOfHeapSortThread_ = Math.min(n, this.calcThreadOfUpperLimitInHeapSort());
    }

    public int getNumOfMergeSortThread() {
        return this.numOfMergeSortThread_;
    }

    public void setNumOfMergeSortThread(int n) {
        ArgumentChecker.throwIfZeroOrLess(n);
        this.numOfMergeSortThread_ = Math.min(n, this.calcThreadOfUpperLimitInMergeSort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.fc_.isOpen()) {
            return;
        }
        FileMappedIntArray fileMappedIntArray = this;
        synchronized (fileMappedIntArray) {
            for (AccessWindow accessWindow : this.accessWindowMap_.values()) {
                Ios.closeQuietly((Closeable)accessWindow);
            }
        }
        Ios.closeQuietly(this.fc_, this.raf_);
    }

    public boolean isOpen() {
        return this.fc_.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.fc_.isOpen()) {
                log_s_.log(LogLevel.WARN, "Client has not call close().");
                Ios.closeQuietly((Closeable)this);
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flash() {
        FileMappedIntArray fileMappedIntArray = this;
        synchronized (fileMappedIntArray) {
            for (AccessWindow accessWindow : this.accessWindowMap_.values()) {
                Ios.closeQuietly((Closeable)accessWindow);
            }
            this.accessWindowMap_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.arrayLength_ = 0L;
            FileMappedIntArray fileMappedIntArray = this;
            synchronized (fileMappedIntArray) {
                this.accessWindowMap_.clear();
            }
            this.fc_.truncate(0L);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessWindow findOrCreate(long l) {
        try {
            FileMappedIntArray fileMappedIntArray = this;
            synchronized (fileMappedIntArray) {
                Long l2 = this.getSlotKey(l);
                AccessWindow accessWindow = (AccessWindow)this.accessWindowMap_.get(l2);
                if (accessWindow != null) {
                    return accessWindow;
                }
                long l3 = l2 * (long)this.windowSize_;
                accessWindow = new AccessWindow(this.fc_, this.arrayLength_, l3, this.windowSize_);
                this.accessWindowMap_.put(l2, accessWindow);
                return accessWindow;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Long getSlotKey(long l) {
        long l2 = l / (long)this.windowSize_;
        Long l3 = l2;
        return l3;
    }

    public long add(int n) {
        AccessWindow accessWindow = this.findOrCreate(this.arrayLength_);
        accessWindow.add(n);
        ++this.arrayLength_;
        return this.arrayLength_;
    }

    public void remove(long l, long l2) {
        ArgumentChecker.throwIfOutOfBounds(l, 0L, this.arrayLength_);
        ArgumentChecker.throwIfOutOfBounds(l2, l, this.arrayLength_ + 1L);
        long l3 = this.getSlotKey(l);
        Iterator iterator = this.accessWindowMap_.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (l3 > (Long)entry.getKey()) continue;
            Ios.closeQuietly((Closeable)entry.getValue());
            iterator.remove();
        }
        long l4 = l2 - l;
        try {
            this.fc_.position(l2 * 4L);
            this.fc_.transferFrom(this.fc_, l * 4L, (this.arrayLength_ - l2) * 4L);
            this.fc_.truncate((this.arrayLength_ - l4) * 4L);
            this.arrayLength_ -= l4;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void set(long l, int n) {
        this.throwIfOutOfBounds(l);
        AccessWindow accessWindow = this.findOrCreate(l);
        accessWindow.set(l, n);
    }

    public int get(long l) {
        this.throwIfOutOfBounds(l);
        AccessWindow accessWindow = this.findOrCreate(l);
        return accessWindow.get(l);
    }

    public IntBuffer loadAllData() {
        try {
            this.flash();
            int n = (int)this.size();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n * 4);
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            this.fc_.read(byteBuffer, 0L);
            return intBuffer;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void throwIfOutOfBounds(long l) {
        if (l < 0L || this.arrayLength_ < l) {
            throw new IndexOutOfBoundsException("Bad index: " + l);
        }
    }

    public long size() {
        return this.arrayLength_;
    }

    public long onMemorySize() {
        long l = 0L;
        for (AccessWindow accessWindow : this.accessWindowMap_.values()) {
            l += (long)accessWindow.size();
        }
        return l;
    }

    public void sort(final IntComparator intComparator) {
        long l;
        Object object;
        if (this.arrayLength_ == 0L) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        ExecutorService executorService = Executors.newFixedThreadPool(this.numOfHeapSortThread_);
        try {
            long l2 = this.arrayLength_ / (long)this.windowSize_ + (long)(this.arrayLength_ % (long)this.windowSize_ == 0L ? 0 : 1);
            object = new CountDownLatch((int)l2);
            for (long i = 0L; i < l2; ++i) {
                l = i * (long)this.windowSize_;
                executorService.execute(new Runnable((CountDownLatch)object){
                    final /* synthetic */ CountDownLatch val$latch;
                    {
                        this.val$latch = countDownLatch;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            StopWatch stopWatch = new StopWatch();
                            AccessWindow accessWindow = FileMappedIntArray.this.findOrCreate(l);
                            accessWindow.heapSort(intComparator);
                            if (log_s_.isEnabled(LogLevel.TRACE)) {
                                log_s_.log(LogLevel.TRACE, stopWatch.stopSecond("Heap Sort END@", Units.formatByte(l)));
                            }
                        }
                        finally {
                            this.val$latch.countDown();
                        }
                    }
                });
            }
            ((CountDownLatch)object).await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            executorService.shutdown();
        }
        this.flash();
        log_s_.log(LogLevel.DEBUG, stopWatch.stopSecond("Heap Sort END"));
        stopWatch.start();
        Object object2 = null;
        try {
            File file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_POSTFIX);
            object2 = new FileMappedIntArray(file, this.windowSize_, this.numOfWindows_);
            ((FileMappedIntArray)object2).fc_.write(ByteBuffer.allocate(4), (this.arrayLength_ - 1L) * 4L);
            ((FileMappedIntArray)object2).arrayLength_ = this.arrayLength_;
            object = this;
            int n = this.windowSize_;
            ExecutorService executorService2 = Executors.newFixedThreadPool(this.numOfMergeSortThread_);
            while ((long)n <= this.arrayLength_) {
                long l3;
                l = this.arrayLength_ / (long)n + (long)(this.arrayLength_ % (long)n == 0L ? 0 : 1);
                long l4 = l - l % 2L;
                CountDownLatch countDownLatch = new CountDownLatch((int)(l4 / 2L));
                for (l3 = 0L; l3 < l4; l3 += 2L) {
                    executorService2.execute(new MergeSorter(intComparator, new SubIntArray((FileMappedIntArray)object, l3 * (long)n, Math.min((l3 + 1L) * (long)n, this.arrayLength_)), new SubIntArray((FileMappedIntArray)object, (l3 + 1L) * (long)n, Math.min((l3 + 2L) * (long)n, this.arrayLength_)), new SubIntArray((FileMappedIntArray)object2, l3 * (long)n, Math.min((l3 + 2L) * (long)n, this.arrayLength_)), countDownLatch));
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                ((FileMappedIntArray)object2).flash();
                if (l4 != l) {
                    for (long i = l3 = l4 * (long)n; i < this.arrayLength_; ++i) {
                        ((FileMappedIntArray)object2).set(i, ((FileMappedIntArray)object).get(i));
                    }
                    ((FileMappedIntArray)object2).flash();
                    ((FileMappedIntArray)object).flash();
                }
                Object object3 = object2;
                object2 = object;
                object = object3;
                log_s_.log(LogLevel.DEBUG, stopWatch.stopSecond("Merge Sort END@", Units.formatByte(n *= 2)));
                stopWatch.start();
            }
            executorService2.shutdown();
            if (object2 == this) {
                for (l = 0L; l < this.arrayLength_; ++l) {
                    this.set(l, ((FileMappedIntArray)object).get(l));
                }
                object2 = object;
            }
            this.flash();
            log_s_.log(LogLevel.DEBUG, stopWatch.stopSecond("Sort END"));
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                Ios.closeQuietly(object2);
                throw throwable;
            }
        }
        Ios.closeQuietly((Closeable)object2);
    }

    static {
        File[] fileArray;
        log_s_ = LogFactory.getLog(FileMappedIntArray.class);
        TEMP_PATTERN = Pattern.compile("org_unitarou_lang_io_IntFileMapList\\d+\\.mia");
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return TEMP_PATTERN.matcher(string).matches();
            }
        })) {
            String string2 = file2.delete() ? "OK" : "Failure";
            log_s_.log(LogLevel.DEBUG, "Try to delete {0} ...{1}", file2, string2);
        }
    }

    private static class MergeSorter
    implements Runnable {
        private final IntComparator intComparator_;
        private final SubIntArray src1_;
        private final SubIntArray src2_;
        private final SubIntArray des_;
        private final CountDownLatch latch_;

        MergeSorter(IntComparator intComparator, SubIntArray subIntArray, SubIntArray subIntArray2, SubIntArray subIntArray3, CountDownLatch countDownLatch) {
            this.intComparator_ = intComparator;
            this.src1_ = subIntArray;
            this.src2_ = subIntArray2;
            this.des_ = subIntArray3;
            this.latch_ = countDownLatch;
            assert (this.src1_.length() + this.src2_.length() == this.des_.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                StopWatch stopWatch = new StopWatch();
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                int n = this.src1_.get(l);
                int n2 = this.src2_.get(l2);
                while (l3 < this.des_.length()) {
                    if (this.intComparator_.compare(n, n2) <= 0) {
                        this.des_.set(l3, n);
                        ++l3;
                        if (++l != this.src1_.length()) {
                            n = this.src1_.get(l);
                            continue;
                        }
                        while (l3 < this.des_.length()) {
                            this.des_.set(l3, n2);
                            ++l3;
                            if (++l2 == (long)this.src2_.length_) continue;
                            n2 = this.src2_.get(l2);
                        }
                        continue;
                    }
                    this.des_.set(l3, n2);
                    ++l3;
                    if (++l2 != this.src2_.length()) {
                        n2 = this.src2_.get(l2);
                        continue;
                    }
                    while (l3 < this.des_.length()) {
                        this.des_.set(l3, n);
                        ++l3;
                        if (++l == (long)this.src1_.length_) continue;
                        n = this.src1_.get(l);
                    }
                }
                if (log_s_.isEnabled(LogLevel.TRACE)) {
                    log_s_.log(LogLevel.TRACE, stopWatch.stopSecond("Merge Sort END@", Units.formatByte(this.des_.start_), "-", Units.formatByte(this.des_.end_)));
                }
            }
            catch (Throwable throwable) {
                Ios.closeQuietly(this.src1_, this.src2_, this.des_);
                this.latch_.countDown();
                throw throwable;
            }
            Ios.closeQuietly(this.src1_, this.src2_, this.des_);
            this.latch_.countDown();
        }
    }

    private static class SubIntArray
    implements Closeable {
        private final FileMappedIntArray baseArray_;
        private final long start_;
        private final long end_;
        private final int length_;
        private AccessWindow accessWindow_;

        SubIntArray(FileMappedIntArray fileMappedIntArray, long l, long l2) {
            this.baseArray_ = fileMappedIntArray;
            this.start_ = l;
            this.end_ = l2;
            this.length_ = (int)(this.end_ - this.start_);
            this.accessWindow_ = null;
        }

        public void close() throws IOException {
            Ios.closeQuietly((Closeable)this.accessWindow_);
        }

        long length() {
            return this.length_;
        }

        int get(long l) {
            this.checkPosition(l);
            return this.accessWindow_.get(this.start_ + l);
        }

        void set(long l, int n) {
            this.checkPosition(l);
            this.accessWindow_.set(this.start_ + l, n);
        }

        private void checkPosition(long l) {
            if (l < 0L || (long)this.length_ <= l) {
                throw new IndexOutOfBoundsException(String.valueOf(l));
            }
            long l2 = this.start_ + l;
            if (this.accessWindow_ == null || !this.accessWindow_.contains(l2)) {
                this.createAccessWindow(l2);
            }
        }

        private void createAccessWindow(long l) {
            try {
                Ios.closeQuietly((Closeable)this.accessWindow_);
                this.accessWindow_ = new AccessWindow(this.baseArray_.fc_, this.baseArray_.arrayLength_, l, Math.min((int)((long)this.length_ - (l - this.start_)), this.baseArray_.windowSize_));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AccessWindowMap
    extends LinkedHashMap<Long, AccessWindow> {
        private static final long serialVersionUID = 1958183774704289950L;

        public AccessWindowMap() {
            super(FileMappedIntArray.this.numOfWindows_, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, AccessWindow> entry) {
            if (this.size() <= FileMappedIntArray.this.numOfWindows_) {
                return false;
            }
            Ios.closeQuietly((Closeable)entry.getValue());
            return true;
        }
    }

    private static class AccessWindow
    implements Closeable {
        private final FileChannel fileChannel_;
        private final long startPosition_;
        private final int windowLength_;
        private final ByteBuffer byteBuffer_;
        private final IntBuffer window_;
        private boolean isEdited_;

        AccessWindow(FileChannel fileChannel, long l, long l2, int n) throws IOException {
            ArgumentChecker.throwIfNull((Object)fileChannel);
            ArgumentChecker.throwIfZeroOrLess(n);
            ArgumentChecker.throwIfNegative(l2);
            this.fileChannel_ = fileChannel;
            this.startPosition_ = l2;
            this.windowLength_ = n;
            this.byteBuffer_ = ByteBuffer.allocate(this.windowLength_ * 4);
            this.window_ = this.byteBuffer_.asIntBuffer();
            this.fileChannel_.read(this.byteBuffer_, this.startPosition_ * 4L);
            if (l < this.startPosition_ + (long)this.windowLength_) {
                this.window_.limit((int)(l - this.startPosition_));
            }
        }

        public synchronized void close() throws IOException {
            if (!this.isEdited_) {
                return;
            }
            this.byteBuffer_.position(0);
            this.byteBuffer_.limit(this.window_.limit() * 4);
            this.fileChannel_.write(this.byteBuffer_, this.startPosition_ * 4L);
            this.isEdited_ = false;
        }

        synchronized void add(int n) {
            int n2 = this.window_.limit();
            this.window_.limit(n2 + 1);
            this.window_.put(n2, n);
            this.isEdited_ = true;
        }

        synchronized int get(long l) {
            return this.window_.get((int)(l - this.startPosition_));
        }

        synchronized void set(long l, int n) {
            this.window_.put((int)(l - this.startPosition_), n);
            this.isEdited_ = true;
        }

        synchronized boolean contains(long l) {
            return this.startPosition_ <= l && l < this.startPosition_ + (long)this.windowLength_;
        }

        synchronized int size() {
            return this.window_.limit();
        }

        synchronized void heapSort(IntComparator intComparator) {
            this.isEdited_ = true;
            int n = this.window_.limit();
            this.buildheap(n, intComparator);
            while (n > 1) {
                this.exchange(0, --n);
                this.downheap(0, n, intComparator);
            }
            Ios.closeQuietly((Closeable)this);
        }

        private void buildheap(int n, IntComparator intComparator) {
            for (int i = n / 2 - 1; i >= 0; --i) {
                this.downheap(i, n, intComparator);
            }
        }

        private void downheap(int n, int n2, IntComparator intComparator) {
            int n3 = 2 * n + 1;
            while (n3 < n2) {
                int n4;
                if (n3 + 1 < n2 && (n4 = intComparator.compare(this.window_.get(n3), this.window_.get(n3 + 1))) < 0) {
                    ++n3;
                }
                if ((n4 = intComparator.compare(this.window_.get(n3), this.window_.get(n))) <= 0) {
                    return;
                }
                this.exchange(n, n3);
                n = n3;
                n3 = 2 * n + 1;
            }
        }

        private void exchange(int n, int n2) {
            int n3 = this.window_.get(n);
            this.window_.put(n, this.window_.get(n2));
            this.window_.put(n2, n3);
        }
    }
}

