/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.linecodec;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.linecodec.ArrayCodec;
import org.unitarou.util.Labeler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOrderFieldEditor<T>
extends FieldEditor {
    private final List<T> unselected_;
    private final List<T> selected_;
    private final ArrayCodec<T> codec_;
    private final Labeler<T> labeler_;
    private String value_;
    private Group frame_;
    private ListViewer lvUnselected_;
    private ListViewer lvSelected_;
    private Button btAdd_;
    private Button btRemove_;
    private Button btUp_;
    private Button btDown_;
    private final String unselectedText_;
    private final String selectedText_;

    public SelectOrderFieldEditor(String string, String string2, String string3, String string4, Composite composite, List<T> list, ArrayCodec<T> arrayCodec, Labeler<T> labeler) {
        ArgumentChecker.throwIfNull(string, string2, string3, string4, composite, list, arrayCodec, labeler);
        this.unselectedText_ = string3;
        this.selectedText_ = string4;
        this.unselected_ = new ArrayList<T>(list);
        this.selected_ = new ArrayList<T>(list.size());
        this.codec_ = arrayCodec;
        this.labeler_ = labeler;
        this.value_ = "";
        this.frame_ = null;
        this.lvUnselected_ = null;
        this.lvSelected_ = null;
        this.btAdd_ = null;
        this.btRemove_ = null;
        this.btUp_ = null;
        this.btDown_ = null;
        this.init(string, string2);
        this.createControl(composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        Label label = this.getLabelControl();
        if (label != null) {
            ((GridData)label.getLayoutData()).horizontalSpan = n;
        }
        ((GridData)this.frame_.getLayoutData()).horizontalSpan = n;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        if (this.frame_ != null) {
            return;
        }
        this.frame_ = new Group(composite, 16);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        this.frame_.setLayoutData((Object)gridData);
        this.frame_.setText(this.getLabelText());
        this.frame_.setLayout((Layout)new GridLayout(4, false));
        this.lvUnselected_ = this.createListViewer((Composite)this.frame_, this.unselectedText_);
        this.lvUnselected_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SelectOrderFieldEditor.this.btAdd_.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
        this.btAdd_ = new Button((Composite)this.frame_, 131076);
        this.btAdd_.setLayoutData((Object)new GridData(0x1000000, 1024, false, true));
        this.btAdd_.setEnabled(false);
        this.btAdd_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectOrderFieldEditor.this.addItemToSelected();
            }
        });
        this.lvSelected_ = this.createListViewer((Composite)this.frame_, this.selectedText_);
        this.lvSelected_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SelectOrderFieldEditor.this.updateEnableButton();
            }
        });
        this.btUp_ = new Button((Composite)this.frame_, 132);
        this.btUp_.setLayoutData((Object)new GridData(0x1000000, 1024, false, true));
        this.btUp_.setEnabled(false);
        this.btUp_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectOrderFieldEditor.this.changeSelectionItemOrder(true);
            }
        });
        this.btRemove_ = new Button((Composite)this.frame_, 16388);
        this.btRemove_.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        this.btRemove_.setEnabled(false);
        this.btRemove_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectOrderFieldEditor.this.removeItemFromSelected();
            }
        });
        this.btDown_ = new Button((Composite)this.frame_, 1028);
        this.btDown_.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        this.btDown_.setEnabled(false);
        this.btDown_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectOrderFieldEditor.this.changeSelectionItemOrder(false);
            }
        });
        this.lvUnselected_.setInput(this.unselected_);
        this.lvSelected_.setInput(this.selected_);
    }

    private ListViewer createListViewer(Composite composite, String string) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 2;
        gridData.heightHint = 200;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(composite2, 16384);
        label.setText(string);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        ListViewer listViewer = new ListViewer(composite2, 2818);
        ListViewerProvider listViewerProvider = new ListViewerProvider();
        listViewer.setContentProvider(listViewerProvider);
        listViewer.setLabelProvider(listViewerProvider);
        org.eclipse.swt.widgets.List list = listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        return listViewer;
    }

    private void updateEnableButton() {
        int[] nArray = this.lvSelected_.getList().getSelectionIndices();
        this.btRemove_.setEnabled(nArray.length != 0);
        boolean bl = nArray.length == 1;
        this.btUp_.setEnabled(bl && 0 < nArray[0]);
        this.btDown_.setEnabled(bl && nArray[0] < this.selected_.size() - 1);
    }

    private void addItemToSelected() {
        int[] nArray = this.lvUnselected_.getList().getSelectionIndices();
        ArrayList<T> arrayList = new ArrayList<T>(nArray.length);
        for (int n : nArray) {
            arrayList.add(this.unselected_.get(n));
        }
        this.selected_.addAll(arrayList);
        this.unselected_.removeAll(arrayList);
        this.lvUnselected_.refresh();
        this.updateSelected();
    }

    private void removeItemFromSelected() {
        int[] nArray = this.lvSelected_.getList().getSelectionIndices();
        ArrayList<T> arrayList = new ArrayList<T>(nArray.length);
        for (int n : nArray) {
            arrayList.add(this.selected_.get(n));
        }
        this.unselected_.addAll(arrayList);
        this.selected_.removeAll(arrayList);
        this.lvUnselected_.refresh();
        this.updateSelected();
    }

    private void changeSelectionItemOrder(boolean bl) {
        int[] nArray = this.lvSelected_.getList().getSelectionIndices();
        if (nArray.length != 1) {
            return;
        }
        int n = nArray[0];
        if (bl && 0 < n) {
            T t = this.selected_.remove(n);
            this.selected_.add(n - 1, t);
            this.updateSelected();
        } else if (!bl && n < this.selected_.size() - 1) {
            T t = this.selected_.remove(n);
            this.selected_.add(n + 1, t);
            this.updateSelected();
        }
    }

    private void updateSelected() {
        this.lvSelected_.refresh();
        this.value_ = this.codec_.encode(this.selected_);
        this.updateEnableButton();
    }

    @Override
    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    @Override
    protected void doStore() {
        if (this.value_ == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value_);
    }

    private void updateValue(String string) {
        this.value_ = string;
        if (this.value_ == null) {
            this.value_ = "";
        }
        this.unselected_.addAll(this.selected_);
        this.selected_.clear();
        for (T t : this.codec_.decode(this.value_)) {
            this.selected_.add(t);
            this.unselected_.remove(t);
        }
        this.lvUnselected_.refresh();
        this.lvSelected_.refresh();
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    private class ListViewerProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        private ListViewerProvider() {
        }

        public Object[] getElements(Object object) {
            return ((List)object).toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public String getText(Object object) {
            return SelectOrderFieldEditor.this.labeler_.label(object);
        }
    }
}

