/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.text.MessageFormat;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Strings;

public class Exceptions {
    private static final Log log_s_ = LogFactory.getLog(Exceptions.class);

    public static String getRootMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = Exceptions.getRootException(throwable);
        if (throwable2.getMessage() != null) {
            return throwable2.getMessage();
        }
        return null;
    }

    public static Throwable getRootException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static String format(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(string, objectArray);
        }
        catch (Throwable throwable) {
            log_s_.log(LogLevel.WARN, throwable, string, objectArray);
            return ((Object)Strings.nullToNullMark(string)).toString() + "; " + ((Object)Strings.concatWithComma(objectArray)).toString();
        }
    }

    protected Exceptions() {
    }
}

