/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.linecodec;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.linecodec.ArrayCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharsetArrayCodec
implements ArrayCodec<Charset> {
    private static final char SEPARATOR = ';';
    private static final Log log_s_ = LogFactory.getLog(CharsetArrayCodec.class);

    @Override
    public boolean isEncodable(Object object) {
        if (object instanceof Charset[]) {
            return true;
        }
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                if (e instanceof Charset) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (object instanceof Charset[]) {
            return this.encode((Collection<Charset>)Arrays.asList((Charset[])object));
        }
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        for (Object e : (Collection)object) {
            if (e instanceof Charset) continue;
            throw new IllegalArgumentException();
        }
        return this.encode((Collection)object);
    }

    @Override
    public String encode(Collection<Charset> collection) {
        ArgumentChecker.throwIfNull(collection);
        StringBuilder stringBuilder = new StringBuilder();
        for (Charset charset : collection) {
            stringBuilder.append(charset.name()).append(';');
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public Charset[] decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(';'));
        ArrayList<Charset> arrayList = new ArrayList<Charset>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(Charset.forName(stringTokenizer.nextToken()));
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                log_s_.log(LogLevel.WARN, "Illegal charset name: {0}", illegalCharsetNameException.getCharsetName());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                log_s_.log(LogLevel.WARN, "Unsupported charset: {0}", unsupportedCharsetException.getCharsetName());
            }
        }
        return arrayList.toArray(new Charset[arrayList.size()]);
    }
}

