/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.parser.CollectionEncodingException;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfFormatter {
    private static final Log log_s_ = LogFactory.getLog(SgfFormatter.class);
    private static final Messages messages_s_ = Messages.createByPackage(SgfFormatter.class);
    private final EnumSet<Option> options_ = EnumSet.noneOf(Option.class);
    private ComposeOption composeOption_ = ComposeOption.AS_IT_IS;

    public EnumSet<Option> getOptions() {
        return EnumSet.copyOf(this.options_);
    }

    public void setOptions(EnumSet<Option> enumSet) {
        ArgumentChecker.throwIfNull(enumSet);
        this.options_.clear();
        this.options_.addAll(enumSet);
    }

    public ComposeOption getComposeOption() {
        return this.composeOption_;
    }

    public void setComposeOption(ComposeOption composeOption) {
        ArgumentChecker.throwIfNull((Object)composeOption);
        this.composeOption_ = composeOption;
    }

    public ByteBuffer format(Collection collection) throws CollectionEncodingException {
        Object object;
        ArgumentChecker.throwIfNull((Object)collection);
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(collection.size());
        int n = 0;
        HashMap<Charset, CharsetEncoder> hashMap = new HashMap<Charset, CharsetEncoder>();
        for (int i = 0; i < collection.size(); ++i) {
            Charset charset;
            object = new StringWriter();
            RootGameTree rootGameTree = collection.get(i);
            if (0 == rootGameTree.getSequence().size()) continue;
            SgfCharset sgfCharset = rootGameTree.getSgfCharset();
            if (sgfCharset == null) {
                sgfCharset = new SgfCharset(rootGameTree.getActualCharset());
            }
            if (!(charset = sgfCharset.getCharset()).canEncode()) {
                sgfCharset = new SgfCharset(Charset.defaultCharset());
            }
            rootGameTree.setCharset(sgfCharset);
            this.formatRgt(rootGameTree, (StringWriter)object);
            ((StringWriter)object).flush();
            charset = sgfCharset.getCharset();
            CharsetEncoder charsetEncoder = (CharsetEncoder)hashMap.get(charset);
            if (charsetEncoder == null) {
                charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                hashMap.put(charset, charsetEncoder);
            }
            charsetEncoder.reset();
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(((StringWriter)object).toString()));
                arrayList.add(byteBuffer);
                n += byteBuffer.limit();
                continue;
            }
            catch (Exception exception) {
                log_s_.log(LogLevel.DEBUG, exception, "Encoding error:");
                throw new CollectionEncodingException(collection, i, null, exception);
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        object = arrayList.iterator();
        while (object.hasNext()) {
            byteBuffer.put((ByteBuffer)object.next());
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public String formatAsString(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < collection.size(); ++i) {
            RootGameTree rootGameTree = collection.get(i);
            if (0 == rootGameTree.getSequence().size()) continue;
            this.formatRgt(rootGameTree, stringWriter);
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    private void formatRgt(RootGameTree rootGameTree, StringWriter stringWriter) {
        if (!this.options_.contains((Object)Option.REMOVE_UTR_BETWEEN_SGF)) {
            stringWriter.write(rootGameTree.getOpenUtr());
        }
        if (this.options_.contains((Object)Option.ADD_NEW_LINE_BEFORE_RGT)) {
            stringWriter.write(Strings.LINE_SEPARATOR);
        }
        stringWriter.write(40);
        for (Node node : rootGameTree.getSequence().getNodes()) {
            this.formatNode(node, stringWriter, rootGameTree.getSize());
        }
        GameTree[] gameTreeArray = rootGameTree.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            this.formatGameTree(gameTreeArray[i], stringWriter, rootGameTree.getSize());
        }
        stringWriter.write(41);
        if (!this.options_.contains((Object)Option.REMOVE_UTR_BETWEEN_SGF)) {
            stringWriter.write(rootGameTree.getCloseUtr());
        }
    }

    private void formatGameTree(GameTree gameTree, StringWriter stringWriter, SgfSize sgfSize) {
        if (!this.options_.contains((Object)Option.REMOVE_UTR_IN_SGF)) {
            stringWriter.write(gameTree.getOpenUtr());
        }
        stringWriter.write(40);
        for (Node node : gameTree.getSequence().getNodes()) {
            this.formatNode(node, stringWriter, sgfSize);
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            this.formatGameTree(gameTreeArray[i], stringWriter, sgfSize);
        }
        stringWriter.write(41);
        if (!this.options_.contains((Object)Option.REMOVE_UTR_IN_SGF)) {
            stringWriter.write(gameTree.getCloseUtr());
        }
    }

    private void formatNode(Node node, StringWriter stringWriter, SgfSize sgfSize) {
        if (!this.options_.contains((Object)Option.REMOVE_UTR_IN_SGF)) {
            stringWriter.write(node.getOpenUtr());
        }
        if (this.options_.contains((Object)Option.ADD_NEW_LINE_BEFORE_NODE)) {
            stringWriter.write(Strings.LINE_SEPARATOR);
        }
        stringWriter.write(59);
        for (Property property : node.getProperties()) {
            if (!this.options_.contains((Object)Option.REMOVE_UTR_IN_SGF)) {
                stringWriter.write(property.getOpenUtr());
            }
            SgfId sgfId = property.sgfId();
            stringWriter.write(this.options_.contains((Object)Option.REGULARIZE_ID) ? sgfId.id() : property.getEntireId());
            property = this.compileExpandPointList(property, sgfSize);
            Value[] valueArray = property.getValues();
            StringFormatter stringFormatter = SgfId.INPUT_FILES.equals(sgfId) ? new IfFormatter() : (ValueType.MOVE.equals((Object)sgfId.valueType()) ? new MoveFormatter(sgfSize) : new StandardFormatter());
            this.formatProperty(stringFormatter, valueArray, stringWriter);
            if (this.options_.contains((Object)Option.REMOVE_UTR_IN_SGF)) continue;
            stringWriter.write(property.getCloseUtr());
        }
    }

    private Property compileExpandPointList(Property property, SgfSize sgfSize) {
        SgfId sgfId = property.sgfId();
        if (this.composeOption_.equals((Object)ComposeOption.AS_IT_IS) || !sgfId.valueType().equals((Object)ValueType.POINT) || !sgfId.cardinalityType().permitsMultiValues()) {
            return property;
        }
        switch (this.composeOption_) {
            case EXPAND: {
                Object[] objectArray = SgfPoint.parse(sgfSize, property.getStrings());
                Arrays.sort(objectArray);
                property.clearValue();
                Value[] valueArray = new Value[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    valueArray[i] = new Value(((SgfPoint)objectArray[i]).getString());
                }
                property.addValue(valueArray);
                break;
            }
            case COMPILE: {
                SgfRectangle[] sgfRectangleArray = SgfRectangle.createRegularRectangles(SgfPoint.parseAsSet(sgfSize, property.getStrings()));
                property.clearValue();
                Value[] valueArray = new Value[sgfRectangleArray.length];
                for (int i = 0; i < valueArray.length; ++i) {
                    valueArray[i] = new Value(sgfRectangleArray[i].getValue());
                }
                property.addValue(valueArray);
                break;
            }
        }
        return property;
    }

    private void formatProperty(StringFormatter stringFormatter, Value[] valueArray, StringWriter stringWriter) {
        boolean bl = !this.options_.contains((Object)Option.REMOVE_UTR_IN_SGF);
        for (Value value : valueArray) {
            if (bl) {
                stringWriter.write(value.getOpenUtr());
            }
            stringWriter.write(91);
            stringWriter.write(stringFormatter.format(value.getString()));
            stringWriter.write(93);
        }
    }

    private class MoveFormatter
    implements StringFormatter {
        private final SgfSize sgfSize_;

        private MoveFormatter(SgfSize sgfSize) {
            this.sgfSize_ = sgfSize;
        }

        public String format(String string) {
            if (this.isNewPass(string) && SgfFormatter.this.options_.contains((Object)Option.USE_TT_PASS) && this.isTargetSize()) {
                return "tt";
            }
            if (this.isOldPass(string) && !SgfFormatter.this.options_.contains((Object)Option.USE_TT_PASS) && this.isTargetSize()) {
                return "";
            }
            return string;
        }

        private boolean isTargetSize() {
            return this.sgfSize_.width() <= SgfSize.DEFAULT.width() && this.sgfSize_.height() <= SgfSize.DEFAULT.height();
        }

        private boolean isNewPass(String string) {
            return string.length() == 0;
        }

        private boolean isOldPass(String string) {
            return "tt".equals(string);
        }
    }

    private static class IfFormatter
    implements StringFormatter {
        private IfFormatter() {
        }

        public String format(String string) {
            return Sgfs.escapeIfForStore(string);
        }
    }

    private static class StandardFormatter
    implements StringFormatter {
        private StandardFormatter() {
        }

        public String format(String string) {
            return Sgfs.escapeForStore(string);
        }
    }

    private static interface StringFormatter {
        public String format(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComposeOption {
        EXPAND,
        COMPILE,
        AS_IT_IS;


        public String toString() {
            return messages_s_.get(Messages.createKey(ComposeOption.class, this.name()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        REGULARIZE_ID,
        USE_TT_PASS,
        REMOVE_UTR_IN_SGF,
        REMOVE_UTR_BETWEEN_SGF,
        ADD_NEW_LINE_BEFORE_RGT,
        ADD_NEW_LINE_BEFORE_NODE;

        private final String displayName_ = new Message(((Object)((Object)this)).getClass(), this.name()).get();

        public String toString() {
            return this.displayName_;
        }
    }
}

