/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.search;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;

public class SequenceCodec {
    public static final int UNUSED_RGT_ID = -1;
    private static final int RGT_FLAG = Integer.MIN_VALUE;
    private static final int WHITE_FLAG = 4096;
    private static final int ADD_FLAG = 8192;
    private static final int SIZE_MASK = 0xFFF0000;
    private static final int SIZE_OFFSET = 16;

    public int encodeRgtId(int n) {
        ArgumentChecker.throwIfNegative(n);
        return Integer.MIN_VALUE | n;
    }

    public int decodeRgtId(int n) {
        return n & Integer.MAX_VALUE;
    }

    public boolean isStoneEncoded(int n) {
        return (n & Integer.MIN_VALUE) == 0;
    }

    @Deprecated
    public int encode(Property property, SgfSize sgfSize) throws TypeParseException {
        SgfPoint sgfPoint = SgfPoint.parseMove(sgfSize, property.getString());
        return this.encode(property.sgfId(), sgfPoint, sgfSize);
    }

    public int encode(SgfId sgfId, SgfPoint sgfPoint, SgfSize sgfSize) {
        int n = sgfSize.primaryKey() << 16;
        int n2 = sgfPoint.index() + 1;
        if (SgfId.ADD_BLACK.equals(sgfId) || SgfId.ADD_WHITE.equals(sgfId)) {
            n2 |= 0x2000;
        }
        if (SgfId.WHITE.equals(sgfId)) {
            n2 |= 0x1000;
        }
        return n | n2;
    }

    public SgfPoint decode(int n) {
        if (!this.isStoneEncoded(n)) {
            return null;
        }
        int n2 = (n & 0xFFF0000) >> 16;
        SgfSize sgfSize = SgfSize.create(n2);
        int n3 = n & 0xFFF;
        SgfPoint sgfPoint = SgfPoint.create(sgfSize, n3 - 1);
        return sgfPoint;
    }

    public void decode(StringBuilder stringBuilder, int n) {
        if (!this.isStoneEncoded(n)) {
            int n2 = this.decodeRgtId(n);
            stringBuilder.append('$').append(Integer.toHexString(n2).toUpperCase());
            return;
        }
        int n3 = (n & 0xFFF0000) >> 16;
        SgfSize sgfSize = SgfSize.create(n3);
        if ((n & 0x1000) != 0) {
            stringBuilder.append('W');
        } else {
            stringBuilder.append('B');
        }
        if (sgfSize.width() != 19 || sgfSize.height() != 19) {
            stringBuilder.append('(').append(sgfSize.width()).append('x').append(sgfSize.height()).append(')');
        }
        int n4 = n & 0xFFF;
        SgfPoint sgfPoint = SgfPoint.create(sgfSize, n4 - 1);
        stringBuilder.append('[').append(sgfPoint.getString()).append(']');
    }
}

