/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.search;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.search.RgtIdTerminationViolation;
import org.unitarou.sgf.search.Searches;
import org.unitarou.sgf.search.SequenceDbEngine;
import org.unitarou.sgf.search.SequenceDbQuery;
import org.unitarou.sgf.search.SequenceDbResult;
import org.unitarou.sgf.search.Stone;
import org.unitarou.sgf.search.UniqueConstraintViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDb
implements Closeable {
    private static final Log log_s_ = LogFactory.getLog(SequenceDb.class);
    private final File dirPath_;
    private final String prefix_;
    private final int maxMemory_;
    private final List<SequenceDbEngine> engineList_;

    public SequenceDb(File file, String string) throws IOException {
        this(file, string, 0x400000);
    }

    public SequenceDb(File file, String string, int n) throws IOException {
        ArgumentChecker.throwIfNull((Object)file, (Object)string);
        ArgumentChecker.throwIfFalse(65536 < n, "maxMemory must be grater or equal to 0x10000, The argument is {0}", n);
        if (!file.exists()) {
            FileUtils.forceMkdir(file);
        }
        if (!Ios.isNormalDirectory(file)) {
            throw new IOException(MessageFormat.format("File can not create. {0} is not a normal directory.", file));
        }
        this.dirPath_ = file;
        this.prefix_ = string;
        this.maxMemory_ = n;
        this.engineList_ = new ArrayList<SequenceDbEngine>();
        int n2 = 0;
        for (String string2 : this.dirPath_.list()) {
            int n3;
            if (!string2.startsWith(this.prefix_) || (n3 = string2.indexOf(46, this.prefix_.length())) <= this.prefix_.length()) continue;
            String string3 = string2.substring(this.prefix_.length(), n3);
            try {
                int n4 = Integer.parseInt(string3);
                n2 = Math.max(n2, n4);
            }
            catch (NumberFormatException numberFormatException) {
                log_s_.log(LogLevel.WARN, "Can''t read strNumber: {0}, in file \"{1}\". Ignore it.", string3, string2);
            }
        }
        for (int i = 1; i <= n2; ++i) {
            this.engineList_.add(new SequenceDbEngine(this.dirPath_, this.prefix_ + Integer.toString(i), this.maxMemory_));
        }
    }

    @Override
    public void close() throws IOException {
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            Ios.closeQuietly((Closeable)sequenceDbEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Ios.closeQuietly((Closeable)this);
        }
        finally {
            super.finalize();
        }
    }

    public void init() {
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            sequenceDbEngine.init();
        }
    }

    private void flashFloodCache(SequenceDbEngine sequenceDbEngine) {
        if (sequenceDbEngine != null && this.isCacheFlood()) {
            sequenceDbEngine.flash();
            log_s_.log(LogLevel.TRACE, "Flash target cache.");
        }
        for (SequenceDbEngine sequenceDbEngine2 : this.engineList_) {
            if (!this.isCacheFlood()) {
                return;
            }
            sequenceDbEngine2.flash();
            log_s_.log(LogLevel.TRACE, "Flash non-target cache.");
        }
        if (this.isCacheFlood()) {
            log_s_.log(LogLevel.WARN, "Cache is flood.  {0}(limit) < {1}(cache size)", this.maxMemory_, this.onMemorySize());
        }
    }

    private boolean isCacheFlood() {
        return this.maxMemory_ < this.onMemorySize();
    }

    public List<SequenceDbResult> find(SequenceDbQuery sequenceDbQuery) throws RgtIdTerminationViolation {
        ArgumentChecker.throwIfNull((Object)sequenceDbQuery);
        this.ensureSort();
        ArrayList<SequenceDbResult> arrayList = new ArrayList<SequenceDbResult>();
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            arrayList.addAll(sequenceDbEngine.find(sequenceDbQuery));
            this.flashFloodCache(sequenceDbEngine);
        }
        return arrayList;
    }

    public void upsert(int n, RootGameTree rootGameTree) throws IOException, UniqueConstraintViolation {
        ArgumentChecker.throwIfOutOfBounds(n, 1L, Integer.MAX_VALUE);
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        ArrayList<Stone> arrayList = new ArrayList<Stone>();
        Searches.appendTargetProperties(n, rootGameTree.getSize(), rootGameTree, arrayList);
        SequenceDbEngine sequenceDbEngine = null;
        for (SequenceDbEngine sequenceDbEngine2 : this.engineList_) {
            if (!sequenceDbEngine2.contains(n)) continue;
            sequenceDbEngine = sequenceDbEngine2;
            break;
        }
        if (sequenceDbEngine != null) {
            if (sequenceDbEngine.upsert(n, rootGameTree.getSize(), arrayList)) {
                this.flashFloodCache(sequenceDbEngine);
                return;
            }
            sequenceDbEngine.delete(n);
        }
        for (SequenceDbEngine sequenceDbEngine2 : this.engineList_) {
            if (!sequenceDbEngine2.upsert(n, rootGameTree.getSize(), arrayList)) continue;
            this.flashFloodCache(sequenceDbEngine2);
            return;
        }
        String string = this.prefix_ + (this.engineList_.size() + 1);
        sequenceDbEngine = new SequenceDbEngine(this.dirPath_, string, this.maxMemory_);
        sequenceDbEngine.upsert(n, rootGameTree.getSize(), arrayList);
        this.engineList_.add(sequenceDbEngine);
        this.flashFloodCache(sequenceDbEngine);
    }

    public boolean delete(int n) throws UniqueConstraintViolation {
        ArgumentChecker.throwIfOutOfBounds(n, 1L, 0x7FFFFFFEL);
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            if (!sequenceDbEngine.delete(n)) continue;
            this.flashFloodCache(sequenceDbEngine);
            return true;
        }
        this.flashFloodCache(null);
        return false;
    }

    public int vacuum() {
        int n = 0;
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            n += sequenceDbEngine.vacuum();
            this.flashFloodCache(sequenceDbEngine);
        }
        this.flashFloodCache(null);
        return n;
    }

    public int size() {
        int n = 0;
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            n += sequenceDbEngine.size();
        }
        return n;
    }

    public int onMemorySize() {
        int n = 0;
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            n += sequenceDbEngine.onMemorySize();
        }
        return n;
    }

    public void flash() {
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            sequenceDbEngine.flash();
        }
    }

    public void deleteFiles() throws IOException {
        this.close();
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            sequenceDbEngine.deleteFiles();
        }
    }

    public void ensureSort() {
        for (SequenceDbEngine sequenceDbEngine : this.engineList_) {
            sequenceDbEngine.ensureSort();
        }
    }
}

