/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.search;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.unitarou.io.IntSuffixArray;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.search.RgtIdTerminationViolation;
import org.unitarou.sgf.search.SequenceCodec;
import org.unitarou.sgf.search.SequenceDbQuery;
import org.unitarou.sgf.search.SequenceDbResult;
import org.unitarou.sgf.search.Stone;
import org.unitarou.sgf.search.UniqueConstraintViolation;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ReversibleFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SequenceDbEngine
implements Closeable {
    private static final Log log_s_ = LogFactory.getLog(SequenceDbEngine.class);
    private final IntSuffixArray suffixArray_;
    private final Map<Integer, Integer> rgtIdMap_;

    SequenceDbEngine(File file, String string, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        ArgumentChecker.throwIfNull((Object)file, (Object)string);
        ArgumentChecker.throwIfFalse(Ios.isNormalDirectory(file), "File can not create. {0} is not a normal directory.", file);
        ArgumentChecker.throwIfZeroOrLess(n);
        n = (int)Math.min((long)n, Runtime.getRuntime().maxMemory() / 2L);
        int n5 = Math.max(n / 4, 1);
        int n6 = 256;
        if (65536 <= n) {
            n4 = n / 4 / 4 * 7;
            n3 = n / 4 / 4 * 1;
            n2 = n3 / 8;
            if (65536 < n4 / n6) {
                n6 = n4 / 65536;
            }
        } else {
            log_s_.log(LogLevel.INFO, "maxMemory is {0}, it is less than 0x10000, So the suffix array arguments are set to the default values.", n);
            n4 = 57344;
            n3 = 8192;
            n2 = 1024;
        }
        this.suffixArray_ = new IntSuffixArray(file, string, n5, n4, n6, n3, n2);
        this.rgtIdMap_ = new HashMap<Integer, Integer>(this.suffixArray_.size() / 210);
        this.setupRgtIdMap();
    }

    private void setupRgtIdMap() {
        int n;
        int n2;
        SequenceCodec sequenceCodec = new SequenceCodec();
        for (int i = 0; i < this.suffixArray_.size() && (n2 = this.suffixArray_.get(n = this.suffixArray_.getSuffixIndex(i))) != -1 && !sequenceCodec.isStoneEncoded(n2); ++i) {
            this.rgtIdMap_.put(sequenceCodec.decodeRgtId(n2), n);
        }
    }

    @Override
    public void close() throws IOException {
        this.suffixArray_.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Ios.closeQuietly((Closeable)this);
        }
        finally {
            super.finalize();
        }
    }

    void init() {
        this.suffixArray_.clear();
    }

    List<SequenceDbResult> find(SequenceDbQuery sequenceDbQuery) throws RgtIdTerminationViolation {
        ArgumentChecker.throwIfNull((Object)sequenceDbQuery);
        Map<ReversibleFilter<SgfPoint>, List<Stone>> map = sequenceDbQuery.getStones();
        ArrayList<SequenceDbResult> arrayList = new ArrayList<SequenceDbResult>();
        for (Map.Entry<ReversibleFilter<SgfPoint>, List<Stone>> entry : map.entrySet()) {
            arrayList.addAll(this.findImpl(entry.getValue(), sequenceDbQuery, entry.getKey()));
            ArrayList<Stone> arrayList2 = new ArrayList<Stone>();
            for (Stone stone : entry.getValue()) {
                SgfId sgfId = null;
                if (stone.sgfId_.equals(SgfId.BLACK)) {
                    sgfId = SgfId.WHITE;
                } else if (stone.sgfId_.equals(SgfId.WHITE)) {
                    sgfId = SgfId.BLACK;
                } else if (stone.sgfId_.equals(SgfId.ADD_BLACK)) {
                    sgfId = SgfId.ADD_WHITE;
                } else if (stone.sgfId_.equals(SgfId.ADD_WHITE)) {
                    sgfId = SgfId.ADD_BLACK;
                }
                Stone stone2 = new Stone(sgfId, stone.sgfPoint_);
                arrayList2.add(stone2);
            }
            arrayList.addAll(this.findImpl(arrayList2, sequenceDbQuery, entry.getKey()));
        }
        return arrayList;
    }

    List<SequenceDbResult> findImpl(List<Stone> list, SequenceDbQuery sequenceDbQuery, ReversibleFilter<SgfPoint> reversibleFilter) throws RgtIdTerminationViolation {
        Object object;
        SequenceCodec sequenceCodec = new SequenceCodec();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            nArray[i] = sequenceCodec.encode(((Stone)object).sgfId_, ((Stone)object).sgfPoint_, sequenceDbQuery.getSize());
        }
        int[] nArray2 = this.suffixArray_.search(nArray);
        object = new ArrayList();
        for (int n : nArray2) {
            SgfPoint sgfPoint = null;
            int n2 = n;
            int n3 = this.suffixArray_.get(n2);
            do {
                if (this.suffixArray_.size() <= ++n2) {
                    throw new RgtIdTerminationViolation();
                }
                n3 = this.suffixArray_.get(n2);
                if (!sequenceCodec.isStoneEncoded(n3) || n2 - n != nArray.length) continue;
                sgfPoint = reversibleFilter.reverse(sequenceCodec.decode(n3));
            } while (sequenceCodec.isStoneEncoded(n3));
            if (-1 == n3) continue;
            int n4 = sequenceCodec.decodeRgtId(n3);
            n2 = n;
            n3 = this.suffixArray_.get(n2);
            while (0 < n2) {
                if (!sequenceCodec.isStoneEncoded(n3)) {
                    ++n2;
                    break;
                }
                n3 = this.suffixArray_.get(--n2);
            }
            SequenceDbResult sequenceDbResult = new SequenceDbResult(n4, n - n2 + 1, sgfPoint);
            object.add(sequenceDbResult);
        }
        return object;
    }

    boolean contains(int n) {
        return this.rgtIdMap_.containsKey(n);
    }

    boolean upsert(int n, SgfSize sgfSize, List<Stone> list) throws UniqueConstraintViolation {
        ArgumentChecker.throwIfOutOfBounds(n, 1L, Integer.MAX_VALUE);
        ArgumentChecker.throwIfNull(list);
        Integer n2 = n;
        Integer n3 = this.rgtIdMap_.get(n2);
        SequenceCodec sequenceCodec = new SequenceCodec();
        if (n3 == null) {
            if (this.isCapacityOver(list)) {
                return false;
            }
        } else {
            int n4;
            int n5 = n3;
            for (n4 = n5 - 1; 0 <= n4 && sequenceCodec.isStoneEncoded(this.suffixArray_.get(n4)); --n4) {
            }
            int n6 = n5 - ++n4;
            if (list.size() == n6) {
                Iterator<Stone> iterator = list.iterator();
                while (n4 < n5) {
                    Stone stone = iterator.next();
                    this.suffixArray_.set(n4, sequenceCodec.encode(stone.sgfId_, stone.sgfPoint_, sgfSize));
                    ++n4;
                }
                return true;
            }
            if (this.isCapacityOver(list)) {
                return false;
            }
            this.suffixArray_.set(n5, -1);
            this.rgtIdMap_.remove(n2);
        }
        for (Stone stone : list) {
            this.suffixArray_.add(sequenceCodec.encode(stone.sgfId_, stone.sgfPoint_, sgfSize));
        }
        this.suffixArray_.add(sequenceCodec.encodeRgtId(n));
        this.rgtIdMap_.put(n2, this.suffixArray_.size() - 1);
        return true;
    }

    private boolean isCapacityOver(List<Stone> list) {
        return this.suffixArray_.getLimitLength() - this.suffixArray_.size() < list.size() + 1;
    }

    boolean delete(int n) throws UniqueConstraintViolation {
        ArgumentChecker.throwIfOutOfBounds(n, 1L, 0x7FFFFFFEL);
        SequenceCodec sequenceCodec = new SequenceCodec();
        int[] nArray = this.suffixArray_.search(sequenceCodec.encodeRgtId(n));
        if (1 < nArray.length) {
            throw new UniqueConstraintViolation();
        }
        if (nArray.length == 1) {
            int n2 = nArray[0];
            this.suffixArray_.set(n2, -1);
            this.rgtIdMap_.remove(n);
            return true;
        }
        return false;
    }

    int vacuum() {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        SequenceCodec sequenceCodec = new SequenceCodec();
        while (n3 < this.suffixArray_.size()) {
            int n5 = this.suffixArray_.get(n3);
            if (sequenceCodec.isStoneEncoded(n5)) {
                ++n3;
                continue;
            }
            if (n5 == -1) {
                n2 = ++n3;
                ++n4;
                continue;
            }
            if (n2 == -1) {
                n = ++n3;
                continue;
            }
            this.suffixArray_.remove(n, n2);
            n = n3 = n3 - (n2 - n) + 1;
            n2 = -1;
        }
        if (n2 != -1) {
            this.suffixArray_.remove(n, n2);
        }
        if (n4 != 0) {
            this.suffixArray_.ensureSort();
            this.setupRgtIdMap();
        }
        return n4;
    }

    int size() {
        return this.suffixArray_.size();
    }

    int onMemorySize() {
        return this.suffixArray_.onMemorySize();
    }

    void flash() {
        this.suffixArray_.flash();
    }

    int getFreeCapacity() {
        return this.suffixArray_.getLimitLength() - this.suffixArray_.size();
    }

    void deleteFiles() throws IOException {
        this.close();
        this.suffixArray_.delete();
    }

    boolean ensureSort() {
        return this.suffixArray_.ensureSort();
    }
}

