/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;
import org.unitarou.util.NestedRevesibleFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rotate180Filter
extends NestedRevesibleFilter<SgfPoint> {
    public Rotate180Filter() {
        this((NestedFilter<SgfPoint>)null);
    }

    public Rotate180Filter(NestedFilter<SgfPoint> nestedFilter) {
        super(nestedFilter);
    }

    @Override
    public SgfPoint filter(SgfPoint sgfPoint) throws FilterException {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        sgfPoint = super.filter(sgfPoint);
        return this.filterImpl(sgfPoint);
    }

    @Override
    public SgfPoint reverse(SgfPoint sgfPoint) throws FilterException {
        sgfPoint = this.filterImpl(sgfPoint);
        return super.reverse(sgfPoint);
    }

    private SgfPoint filterImpl(SgfPoint sgfPoint) throws FilterException {
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            return sgfPoint;
        }
        SgfSize sgfSize = sgfPoint.size();
        int n = sgfSize.width() - sgfPoint.x() + 1;
        int n2 = sgfSize.height() - sgfPoint.y() + 1;
        if (n <= sgfSize.width() && n2 <= sgfSize.height()) {
            return SgfPoint.create(sgfPoint.size(), n, n2);
        }
        throw new FilterException();
    }
}

