/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.swt.Swts;

public class ScrolledCompositeMouseWheelHandler {
    private static final Log log_s_ = LogFactory.getLog(ScrolledCompositeMouseWheelHandler.class);
    private ScrolledComposite scrollable_ = null;
    private MouseWheelListener mouseWheelListener_ = new MouseWheelListener();
    private int step_ = 10;

    public void setScrollable(ScrolledComposite scrolledComposite) {
        ArgumentChecker.throwIfNull((Object)scrolledComposite);
        this.scrollable_ = scrolledComposite;
        ScrollBar scrollBar = this.scrollable_.getVerticalBar();
        scrollBar.setIncrement(10);
        scrollBar.setPageIncrement(50);
        scrollBar.setThumb(100);
        this.scrollable_.getDisplay().addFilter(37, (Listener)this.mouseWheelListener_);
        this.scrollable_.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ScrolledCompositeMouseWheelHandler.this.scrollable_.getDisplay().removeFilter(37, (Listener)ScrolledCompositeMouseWheelHandler.this.mouseWheelListener_);
            }
        });
    }

    public int getStep() {
        return this.step_;
    }

    public void setStep(int n) {
        this.step_ = n;
    }

    private class MouseWheelListener
    implements Listener {
        private int lastTime = 0;

        private MouseWheelListener() {
        }

        public void handleEvent(Event event) {
            if (this.lastTime == event.time || !(event.widget instanceof Control)) {
                return;
            }
            this.lastTime = event.time;
            if (!this.isMouseOn()) {
                return;
            }
            this.scroll(event);
        }

        private boolean isMouseOn() {
            if (Swts.isMouseOn((Control)ScrolledCompositeMouseWheelHandler.this.scrollable_)) {
                return true;
            }
            Control control = ScrolledCompositeMouseWheelHandler.this.scrollable_.getContent();
            if (Swts.isMouseOn(control)) {
                return true;
            }
            if (control instanceof Composite) {
                List<Control> list = Swts.getDescendant((Composite)control);
                for (Control control2 : list) {
                    if (!Swts.isMouseOn(control2)) continue;
                    return true;
                }
            }
            return false;
        }

        private void scroll(Event event) {
            ScrollBar scrollBar = ScrolledCompositeMouseWheelHandler.this.scrollable_.getVerticalBar();
            if (scrollBar == null) {
                log_s_.log(LogLevel.WARN, "ScrollBar is not found in {0}", ScrolledCompositeMouseWheelHandler.this.scrollable_);
                return;
            }
            int n = scrollBar.getSelection();
            if (0 < event.count) {
                if ((n -= event.count * ScrolledCompositeMouseWheelHandler.this.step_) < scrollBar.getMinimum()) {
                    n = scrollBar.getMinimum();
                }
            } else if (event.count < 0 && scrollBar.getMaximum() < (n -= event.count * ScrolledCompositeMouseWheelHandler.this.step_)) {
                n = scrollBar.getMaximum();
            }
            if (scrollBar.getSelection() != n) {
                Point point = ScrolledCompositeMouseWheelHandler.this.scrollable_.getOrigin();
                point.y = n;
                ScrolledCompositeMouseWheelHandler.this.scrollable_.setOrigin(point);
            }
        }
    }
}

