/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Runtimes;
import org.unitarou.lang.Strings;
import org.unitarou.swt.Swts;
import org.unitarou.swt.UTableProvider;
import org.unitarou.swt.WidgetContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTable<T>
implements WidgetContainer {
    private static final Log log_s_ = LogFactory.getLog(UTable.class);
    private Table table_;
    private final int tableStyle_;
    private final UTableProvider<T> provider_;
    private final List<T> records_;
    private final List<T> orgRecords_;

    public UTable(UTableProvider<T> uTableProvider, Collection<T> collection, int n) {
        ArgumentChecker.throwIfNull(uTableProvider, collection);
        this.table_ = null;
        this.tableStyle_ = n;
        this.provider_ = uTableProvider;
        this.records_ = new ArrayList<T>(collection);
        this.orgRecords_ = new ArrayList<T>(collection);
    }

    public UTable(UTableProvider<T> uTableProvider, Collection<T> collection) {
        this(uTableProvider, collection, 0);
    }

    public UTable(UTableProvider<T> uTableProvider, T[] TArray) {
        this(uTableProvider, Arrays.asList(TArray));
    }

    public UTable(UTableProvider<T> uTableProvider, int n) {
        this(uTableProvider, Collections.emptyList(), n);
    }

    public UTable(UTableProvider<T> uTableProvider) {
        this(uTableProvider, Collections.emptyList());
    }

    @Override
    public void close() {
    }

    public Table createContents(Composite composite) {
        this.table_ = new Table(composite, 0x10000800 | this.tableStyle_);
        this.table_.setHeaderVisible(true);
        TableColumn[] tableColumnArray = new TableColumn[this.provider_.getColumnSize()];
        for (int i = 0; i < tableColumnArray.length; ++i) {
            tableColumnArray[i] = new TableColumn(this.table_, 16384);
        }
        this.provider_.setup(tableColumnArray);
        this.table_.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                UTable.this.setTableItem((TableItem)event.item);
            }
        });
        boolean[] blArray = this.provider_.getSotableColums();
        SortListener sortListener = new SortListener();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            tableColumnArray[i].addListener(13, (Listener)sortListener);
        }
        this.table_.setItemCount(this.records_.size());
        return this.table_;
    }

    private void setTableItem(TableItem tableItem) {
        int n = this.table_.indexOf(tableItem);
        try {
            this.provider_.set(tableItem, this.records_.get(n));
        }
        catch (RuntimeException runtimeException) {
            log_s_.log(LogLevel.ERROR, "Set error: index={0}", n);
            throw runtimeException;
        }
    }

    public Table getControl() {
        return this.table_;
    }

    /*
     * WARNING - void declaration
     */
    public int[] packColumns() {
        int n;
        boolean[] blArray = new boolean[this.table_.getColumnCount()];
        if (Runtimes.IS_WINDOWS_VISTA_OR_LATER && this.table_.getItemCount() != 0) {
            void objectArray;
            boolean i = false;
            while (objectArray < blArray.length) {
                blArray[objectArray] = true;
                ++objectArray;
            }
            TableItem[] tableItemArray = this.table_.getItems();
            n = tableItemArray.length;
            for (int j = 0; j < n; ++j) {
                TableItem tableItem = tableItemArray[j];
                for (int k = 0; k < blArray.length; ++k) {
                    int n2 = k;
                    blArray[n2] = blArray[n2] & (Strings.isEmpty(tableItem.getText(k)) && tableItem.getImage(k) == null);
                }
            }
        }
        int[] nArray = new int[this.table_.getColumnCount()];
        for (n = 0; n < this.table_.getColumnCount(); ++n) {
            TableColumn tableColumn = this.table_.getColumn(n);
            if (blArray[n]) {
                tableColumn.setWidth(0);
            } else {
                tableColumn.pack();
            }
            nArray[n] = tableColumn.getWidth();
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] extendColumns() {
        int n = this.table_.getTopIndex();
        int n2 = (int)Math.ceil((double)this.table_.getClientArea().height / (double)this.table_.getItemHeight());
        int n3 = Math.min(this.table_.getItemCount(), n + n2);
        int[] nArray = new int[this.table_.getColumnCount()];
        TableColumn[] tableColumnArray = this.table_.getColumns();
        for (int i = 0; i < tableColumnArray.length; ++i) {
            nArray[i] = tableColumnArray[i].getWidth();
        }
        GC gC = new GC((Drawable)this.table_);
        try {
            int n4;
            for (n4 = n; n4 < n3; ++n4) {
                TableItem tableItem = this.table_.getItem(n4);
                for (int i = 0; i < tableColumnArray.length; ++i) {
                    nArray[i] = Math.max(this.calcWidth(gC, tableItem, i), nArray[i]);
                }
            }
            for (n4 = 0; n4 < tableColumnArray.length; ++n4) {
                if (tableColumnArray[n4].getWidth() == nArray[n4]) continue;
                tableColumnArray[n4].setWidth(nArray[n4]);
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            Swts.disposeQuietly((Resource)gC);
        }
    }

    private int calcWidth(GC gC, TableItem tableItem, int n) {
        Image image;
        int n2 = 12;
        String string = tableItem.getText(n);
        if (string != null) {
            n2 += gC.textExtent((String)string).x;
        }
        if ((image = tableItem.getImage(n)) != null) {
            n2 += image.getBounds().width;
        }
        if (n2 == 12) {
            n2 = 0;
        }
        return n2;
    }

    public List<T> getRecords() {
        return Collections.unmodifiableList(this.records_);
    }

    public int size() {
        return this.records_.size();
    }

    public void add(T t) {
        ArgumentChecker.throwIfNull(t);
        this.records_.add(t);
        this.orgRecords_.add(t);
        if (this.sort()) {
            this.table_.clearAll();
        }
        this.table_.setItemCount(this.records_.size());
    }

    public void addAll(Collection<T> collection) {
        ArgumentChecker.throwIfNull(collection);
        this.records_.addAll(collection);
        this.orgRecords_.addAll(collection);
        if (this.sort()) {
            this.table_.clearAll();
        }
        this.table_.setItemCount(this.records_.size());
    }

    public void removeLast() {
        int n = this.records_.size() - 1;
        T t = this.records_.remove(n);
        this.orgRecords_.remove(t);
        this.table_.remove(n);
    }

    public void removeSelected() {
        int[] nArray = this.table_.getSelectionIndices();
        ArrayList<T> arrayList = new ArrayList<T>(nArray.length);
        for (int n : nArray) {
            arrayList.add(this.records_.get(n));
        }
        this.records_.removeAll(arrayList);
        this.orgRecords_.removeAll(arrayList);
        this.table_.remove(nArray);
    }

    public void replace(int n, T t) {
        ArgumentChecker.throwIfNegative(n);
        ArgumentChecker.throwIfNull(t);
        int n2 = this.orgRecords_.indexOf(this.records_.get(n));
        this.records_.set(n, t);
        this.orgRecords_.set(n2, t);
        this.table_.clear(n);
    }

    public void replace(int n, List<T> list) {
        ArgumentChecker.throwIfNegative(n);
        ArgumentChecker.throwIfNull(list);
        int n2 = 0;
        for (T t : list) {
            int n3 = this.orgRecords_.indexOf(this.records_.get(n + n2));
            this.records_.set(n + n2, t);
            this.orgRecords_.set(n3, t);
            ++n2;
        }
        this.table_.clear(n, n + list.size() - 1);
    }

    public void clear() {
        this.table_.clearAll();
        this.table_.setItemCount(0);
        this.records_.clear();
        this.orgRecords_.clear();
    }

    public void update() {
        this.table_.clearAll();
    }

    public void update(int n) {
        if (n < 0 || this.table_.getItemCount() <= n) {
            return;
        }
        this.table_.clear(n);
    }

    public void update(int[] nArray) {
        this.table_.clear(nArray);
    }

    private boolean sort() {
        int n = this.table_.getSortDirection();
        TableColumn tableColumn = this.table_.getSortColumn();
        if (n == 0 || tableColumn == null) {
            return false;
        }
        final int n2 = this.table_.indexOf(tableColumn);
        final int n3 = n == 128 ? 1 : -1;
        Collections.sort(this.records_, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return n3 * UTable.this.provider_.compareTo(t, t2, n2);
            }
        });
        return true;
    }

    private class SortListener
    implements Listener {
        private SortListener() {
        }

        public void handleEvent(Event event) {
            TableColumn tableColumn = (TableColumn)event.widget;
            int n = UTable.this.table_.indexOf(tableColumn);
            if (!UTable.this.provider_.getSotableColums()[n]) {
                UTable.this.table_.setSortColumn(null);
                UTable.this.records_.clear();
                UTable.this.records_.addAll(UTable.this.orgRecords_);
                UTable.this.table_.clearAll();
                return;
            }
            int n2 = this.changeSortCondition(tableColumn);
            UTable.this.table_.setSortDirection(n2);
            if (n2 == 0) {
                UTable.this.records_.clear();
                UTable.this.records_.addAll(UTable.this.orgRecords_);
            } else {
                UTable.this.sort();
            }
            UTable.this.table_.clearAll();
        }

        private int changeSortCondition(TableColumn tableColumn) {
            TableColumn tableColumn2 = UTable.this.table_.getSortColumn();
            if (tableColumn2 != tableColumn) {
                UTable.this.table_.setSortColumn(tableColumn);
                return 128;
            }
            int n = UTable.this.table_.getSortDirection();
            return this.getNextMode(n);
        }

        private int getNextMode(int n) {
            switch (n) {
                case 128: {
                    return 1024;
                }
                case 1024: {
                    return 0;
                }
                case 0: {
                    return 128;
                }
            }
            assert (false) : "Unknown direction: " + n;
            return 0;
        }
    }
}

