/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sql.CheckerResult;
import org.unitarou.sql.CheckerResultType;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.GameRecord;
import org.unitarou.yukinoshita.model.db.GameTerm;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermFrequency;
import org.unitarou.yukinoshita.model.db.hsql.HsqlDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseManager
implements Closeable {
    private static final Log log_s_ = LogFactory.getLog(DatabaseManager.class);
    public static final ContextValue<Boolean> ENABLE_DB = new ContextValue<Boolean>(DatabaseManager.class, "enableDb", Boolean.TRUE);
    private static final DatabaseManager instance_s_ = new DatabaseManager();
    private Database database_ = Database.NULL_OBJECT;
    private Database realDatabase_ = null;
    private Listener listener_ = new Listener();

    public static DatabaseManager instance() {
        return instance_s_;
    }

    private DatabaseManager() {
        Yukinoshita.context().addListener(this.listener_);
    }

    public void startup() {
        if (this.realDatabase_ != null) {
            return;
        }
        this.database_ = Yukinoshita.context(null).getAttribute(ENABLE_DB) != false ? (this.realDatabase_ = this.startupDatabase()) : Database.NULL_OBJECT;
    }

    private Database startupDatabase() {
        HsqlDatabase hsqlDatabase = new HsqlDatabase();
        hsqlDatabase.setup();
        Exception exception = hsqlDatabase.getExceptionAtSetup();
        if (exception != null) {
            this.handleDbInitializeFailure(exception);
            return Database.NULL_OBJECT;
        }
        if (!hsqlDatabase.updateDatabase()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.buildNoMatchMessages(hsqlDatabase.selfCheck(), stringBuilder);
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, Database.NT_CANT_START_DB.get(), Database.MSG_DB_CANNOT_BE_USED_BY_INIT_ERROR.get((Object)stringBuilder));
            Ios.closeQuietly((Closeable)hsqlDatabase);
            return Database.NULL_OBJECT;
        }
        CheckerResult checkerResult = hsqlDatabase.selfCheck();
        if (checkerResult.getTreeType() == CheckerResultType.MATCH) {
            return hsqlDatabase;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.buildNoMatchMessages(checkerResult, stringBuilder);
        return this.recreateDb(hsqlDatabase, stringBuilder.toString());
    }

    private void buildNoMatchMessages(CheckerResult checkerResult, StringBuilder stringBuilder) {
        if (CheckerResultType.MATCH != checkerResult.getType()) {
            stringBuilder.append(checkerResult.getMessage()).append('\n');
        }
        for (CheckerResult checkerResult2 : checkerResult.getChildren()) {
            this.buildNoMatchMessages(checkerResult2, stringBuilder);
        }
    }

    private Database recreateDb(Database database, String string) {
        Application application = Yukinoshita.application();
        boolean bl = application.openMessageDialog(Application.MessageLevel.CONFIRM, Database.NT_CANT_START_DB.get(), Database.MSG_RECREATE_DB.get((Object)string));
        try {
            if (bl) {
                database.create();
            } else {
                database.close();
                application.openMessageDialog(Application.MessageLevel.INFORMATION, Database.NT_CANT_START_DB.get(), Database.MSG_DB_CANNOT_BE_USED.get());
            }
            return database;
        }
        catch (DatabaseException databaseException) {
            this.handleDbInitializeFailure(databaseException);
            return Database.NULL_OBJECT;
        }
    }

    private void handleDbInitializeFailure(Exception exception) {
        log_s_.log(LogLevel.WARN, exception, "Can't initialize DB");
        Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, Database.NT_CANT_START_DB.get(), Database.MSG_DB_CANNOT_BE_USED_BY_INIT_ERROR.get((Object)exception.getLocalizedMessage()));
    }

    @Override
    public void close() {
        Yukinoshita.context().removeListener(this.listener_);
        Ios.closeQuietly((Closeable)this.realDatabase_);
    }

    public void refreshFileIndex(List<Collection> list) {
        try {
            this.database_.refreshFileIndex(list);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Cannot refresh DB");
        }
    }

    public void registerProblemResult(RootGameTree rootGameTree, ProblemStatus problemStatus, int n) {
        if (!Yukinoshita.context(null).getAttribute(Context.SAVE_PROBLEM_RESULT).booleanValue()) {
            return;
        }
        ProblemProperties problemProperties = new ProblemProperties(Yukinoshita.context(rootGameTree).getInteger(Context.PROBLEM_PROPERTIES));
        try {
            this.database_.insertScore(rootGameTree, problemStatus, problemProperties, n);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to save score");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Score[] selectScore(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        Application application = Yukinoshita.application();
        try {
            application.setCursorType(Application.CursorType.WAIT);
            Score[] scoreArray = this.database_.selectScores(rootGameTree);
            return scoreArray;
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select score");
            Score[] scoreArray = new Score[]{};
            return scoreArray;
        }
        finally {
            application.setCursorType(Application.CursorType.NONE);
        }
    }

    public List<SearchedFile> search(SearchFileCondition searchFileCondition) {
        try {
            return this.database_.search(searchFileCondition);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select");
            return Collections.emptyList();
        }
    }

    public List<GameTerm> selectGameTerm(GameType gameType, SgfId sgfId) {
        try {
            return this.database_.selectGameTerm(gameType, sgfId);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select");
            return Collections.emptyList();
        }
    }

    public List<Term> select(GameIndex gameIndex) {
        try {
            return this.database_.search(gameIndex);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select");
            return Collections.emptyList();
        }
    }

    public List<TermFrequency> searchTermFrequency(SgfId sgfId, GameType gameType) {
        try {
            return this.database_.searchTermFrequency(sgfId, gameType);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select");
            return Collections.emptyList();
        }
    }

    public Master selectMaster(int n) {
        try {
            return this.database_.selectMaster(n);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select");
            return null;
        }
    }

    public boolean deleteFileIndex(int n) {
        try {
            return this.database_.deleteFileIndex(n);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to delete.");
            return false;
        }
    }

    public void deleteAllFileIndices() {
        try {
            this.database_.deleteAllFileIndices();
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to delete.");
        }
    }

    public int deleteNotFoundFileIndex() {
        try {
            return this.database_.deleteNotFoundFileIndex();
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to delete.");
            return 0;
        }
    }

    public DatabaseStatistics getDatabaseStatistics() {
        try {
            return this.database_.selectStatistics();
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select.");
            return new DatabaseStatistics();
        }
    }

    public List<GameRecord> selectGameScore(String string, String string2) {
        try {
            return this.database_.selectGameScore(string, string2);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select.");
            return Collections.emptyList();
        }
    }

    public FileIndex selectFile(int n) {
        try {
            return this.database_.selectFileIndex(n);
        }
        catch (DatabaseException databaseException) {
            log_s_.log(LogLevel.WARN, databaseException, "Failure to select.");
            return null;
        }
    }

    public Map<SgfPoint, Integer> findNextMove(NodeList nodeList) {
        return Collections.emptyMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements ContextListener {
        private Listener() {
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            if (!set.contains(ENABLE_DB.id())) {
                return;
            }
            DatabaseManager.this.startup();
        }
    }
}

