/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.io.File;
import java.util.EnumSet;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.NullCommand;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFileName
extends NodeListCommand {
    private static final Message LB_NAME = new Message(ChangeFileName.class, "lbName");
    private final Collection collection_;
    private final File lastFile_;
    private final File newFile_;
    private Command command_;

    public ChangeFileName(Collection collection, File file) {
        ArgumentChecker.throwIfNull((Object)collection, (Object)file);
        this.collection_ = collection;
        this.lastFile_ = collection.getFile();
        this.newFile_ = file;
        this.command_ = null;
        this.setDisplayName(LB_NAME.get());
    }

    @Override
    protected boolean setup() {
        if (this.command_ != null) {
            return true;
        }
        if (this.getNodeListEditor() == null) {
            return false;
        }
        this.command_ = this.composeCommand();
        return true;
    }

    private Command composeCommand() {
        String string;
        if (!this.collection_.get(0).getGameType().equals(GameType.DRILL)) {
            return NullCommand.INSTANCE;
        }
        String string2 = FilenameUtils.getFullPath(this.collection_.getFile().getAbsolutePath());
        if (string2.equals(string = FilenameUtils.getFullPath(this.newFile_.getAbsolutePath()))) {
            return NullCommand.INSTANCE;
        }
        NodeListEditor nodeListEditor = this.getNodeListEditor();
        if (nodeListEditor.size() < 2) {
            return NullCommand.INSTANCE;
        }
        for (int i = 0; i < nodeListEditor.size(); ++i) {
            Property property = nodeListEditor.get(i).getNode().getProperty(SgfId.INPUT_FILES);
            if (property == null) continue;
            this.setExecutedNodeIndex(nodeListEditor.getPositionIndex());
            this.setUndoneNodeIndex(nodeListEditor.getPositionIndex());
            nodeListEditor.setPositionIndex(i);
            Property property2 = new Property();
            property2.setEntireId(SgfId.INPUT_FILES.id());
            for (Value value : property.getValues()) {
                String string3 = FilenameUtils.concat(string2, value.getString());
                Value value2 = new Value(Ios.calcRelativePath(string, string3), value.getOpenUtr());
                property2.addValue(value2);
            }
            return new UpdateCommand(property, property2, nodeListEditor);
        }
        return NullCommand.INSTANCE;
    }

    @Override
    protected void executeNodeListCommand() {
        this.command_.execute();
        this.collection_.setFile(this.newFile_);
    }

    @Override
    protected void undoNodeListCommand() {
        this.collection_.setFile(this.lastFile_);
        this.command_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.COLLECTION);
    }

    private static class UpdateCommand
    implements Command {
        private final UpdateProperty removeLast_;
        private final UpdateProperty addRepleaced_;

        private UpdateCommand(Property property, Property property2, NodeListEditor nodeListEditor) {
            this.removeLast_ = new UpdateProperty(null, null, property);
            this.addRepleaced_ = new UpdateProperty(null, property2, new Property[0]);
            this.removeLast_.setNodeListEditor(nodeListEditor);
            this.addRepleaced_.setNodeListEditor(nodeListEditor);
        }

        public void execute() {
            this.removeLast_.execute();
            this.addRepleaced_.execute();
        }

        public void undo() {
            this.addRepleaced_.undo();
            this.removeLast_.undo();
        }
    }
}

