/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanHandler;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GameIndexTable
extends AbstractTable {
    private static final Log log_s_ = LogFactory.getLog(GameIndexTable.class);
    private static final HsqldbColumn[] columns_V1_s_ = new HsqldbColumn[]{new HsqldbColumn("FILE_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("FILE_ORDER", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("MASTER_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("GAME_INFO", "VARCHAR", 0, "NULL"), new HsqldbColumn("KEYWORD", "VARCHAR", 0, "NULL")};
    private static final HsqldbColumn[] columns_V2_s_ = new HsqldbColumn[]{new HsqldbColumn("FILE_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("FILE_ORDER", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("MASTER_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("GAME_TYPE", "INTEGER", 0, "NOT NULL", "DEFAULT 1"), new HsqldbColumn("MOVE", "INTEGER", 0, "NOT NULL", "DEFAULT 0"), new HsqldbColumn("PROCEDURE", "VARCHAR", 0, "NULL"), new HsqldbColumn("DATE", "VARCHAR", 0, "NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("FILE_ID", 1), new PrimaryKey("FILE_ORDER", 2)};
    private static final ForeignKey[] foreignKeys_s_ = new ForeignKey[]{new ForeignKey("FILE_INDEX", "FILE_ID", "GAME_INDEX", "FILE_ID", 1), new ForeignKey("MASTER", "MASTER_ID", "GAME_INDEX", "MASTER_ID", 1)};
    private static final GameIndexTable instance_s_ = new GameIndexTable();

    static GameIndexTable instance() {
        return instance_s_;
    }

    private GameIndexTable() {
    }

    @Override
    public boolean exists(DatabaseVersion databaseVersion) {
        return true;
    }

    @Override
    public String getTable() {
        return "GAME_INDEX";
    }

    @Override
    public HsqldbColumn[] getColumns(DatabaseVersion databaseVersion) {
        switch (databaseVersion) {
            case V_1: {
                return columns_V1_s_;
            }
            case V_2: {
                return columns_V2_s_;
            }
        }
        assert (false) : "Unknown version: " + (Object)((Object)databaseVersion);
        return new HsqldbColumn[0];
    }

    @Override
    public PrimaryKey[] getPrimaryKeys(DatabaseVersion databaseVersion) {
        return primaryKey_s_;
    }

    @Override
    protected ForeignKey[] getForeignKeys(DatabaseVersion databaseVersion) {
        return foreignKeys_s_;
    }

    @Override
    protected String getInTableConstraints() {
        return "";
    }

    @Override
    protected String[] getInterTableConstraintQueries() {
        return new String[]{"DELETE FROM game_index g WHERE g.file_id <> ALL ( SELECT f.file_id FROM file_index f );", "ALTER TABLE game_index ADD CONSTRAINT fk1_game_index FOREIGN KEY (file_id) REFERENCES file_index(file_id) ON DELETE CASCADE;", "ALTER TABLE game_index ADD CONSTRAINT fk2_game_index FOREIGN KEY (master_id) REFERENCES master(master_id) ON DELETE CASCADE;"};
    }

    void refresh(Connection connection, GameIndex gameIndex) throws SQLException {
        GameIndex gameIndex2 = this.selectFromFileIdAndIndex(connection, gameIndex.getFileId(), gameIndex.getFileOrder());
        if (gameIndex2 == null) {
            this.insert(connection, gameIndex);
        } else if (!gameIndex.equals(gameIndex2)) {
            this.update(connection, gameIndex);
        }
    }

    void refresh(Connection connection, List<GameIndex> list) throws SQLException {
        List<GameIndex> list2 = this.selectFromFileIdAndIndex(connection, list);
        ArrayList<GameIndex> arrayList = new ArrayList<GameIndex>(list2.size());
        ArrayList<GameIndex> arrayList2 = new ArrayList<GameIndex>(list2.size());
        for (int i = 0; i < list.size(); ++i) {
            GameIndex gameIndex = list.get(i);
            GameIndex gameIndex2 = list2.get(i);
            if (gameIndex2 == null) {
                arrayList.add(gameIndex);
                continue;
            }
            if (gameIndex.equals(gameIndex2)) continue;
            arrayList2.add(gameIndex);
        }
        this.update(connection, arrayList2);
        this.insert(connection, arrayList);
    }

    private List<GameIndex> selectFromFileIdAndIndex(Connection connection, List<GameIndex> list) throws SQLException {
        Object object;
        Object[][] objectArray = new Object[list.size()][2];
        for (int i = 0; i < objectArray.length; ++i) {
            object = list.get(i);
            objectArray[i][0] = ((GameIndex)object).getFileId();
            objectArray[i][1] = ((GameIndex)object).getFileOrder();
        }
        UQueryRunner uQueryRunner = new UQueryRunner();
        object = uQueryRunner.queryOneRecord(connection, "SELECT file_id, file_order, master_id, game_type, move, procedure, date FROM game_index WHERE file_id=? AND file_order=?", objectArray, GameIndex.class);
        return object;
    }

    private GameIndex selectFromFileIdAndIndex(Connection connection, int n, int n2) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        GameIndex gameIndex = (GameIndex)queryRunner.query(connection, "SELECT file_id, file_order, master_id, game_type, move, procedure, date FROM game_index WHERE file_id=? AND file_order=?", new Object[]{n, n2}, new UBeanHandler(GameIndex.class));
        return gameIndex;
    }

    private void insert(Connection connection, GameIndex gameIndex) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "INSERT INTO game_index (file_id, file_order, master_id, game_type, move, procedure, date) VALUES(?, ?, ?, ?, ?, ?, ?)", gameIndex.getFileId(), gameIndex.getFileOrder(), gameIndex.getMasterId(), gameIndex.getGameType(), gameIndex.getMove(), gameIndex.getProcedure(), gameIndex.getDate());
        if (n != 1) {
            throw new SQLException("DB is broken: insert error record:" + n);
        }
        log_s_.log(LogLevel.TRACE, "INSERT: {0}", gameIndex);
    }

    private void insert(Connection connection, List<GameIndex> list) throws SQLException {
        Object object;
        if (list.isEmpty()) {
            return;
        }
        Object[][] objectArray = new Object[list.size()][7];
        for (int i = 0; i < objectArray.length; ++i) {
            object = list.get(i);
            objectArray[i][0] = ((GameIndex)object).getFileId();
            objectArray[i][1] = ((GameIndex)object).getFileOrder();
            objectArray[i][2] = ((GameIndex)object).getMasterId();
            objectArray[i][3] = ((GameIndex)object).getGameType();
            objectArray[i][4] = ((GameIndex)object).getMove();
            objectArray[i][5] = ((GameIndex)object).getProcedure();
            objectArray[i][6] = ((GameIndex)object).getDate();
        }
        UQueryRunner uQueryRunner = new UQueryRunner();
        for (Object object2 : object = (Object)uQueryRunner.batch(connection, "INSERT INTO game_index (file_id, file_order, master_id, game_type, move, procedure, date) VALUES(?, ?, ?, ?, ?, ?, ?)", objectArray)) {
            if (object2 == true) continue;
            throw new SQLException("DB is broken: insert error record:" + (int)object2);
        }
    }

    private void update(Connection connection, GameIndex gameIndex) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "UPDATE game_index SET master_id=?, game_type=?, move=?, procedure=?, date=?WHERE file_id=? AND file_order=?", gameIndex.getMasterId(), gameIndex.getGameType(), gameIndex.getMove(), gameIndex.getProcedure(), gameIndex.getDate(), gameIndex.getFileId(), gameIndex.getFileOrder());
        if (n != 1) {
            throw new SQLException("DB is broken: update error record:" + n);
        }
        log_s_.log(LogLevel.TRACE, "UPDATE: {0}", gameIndex);
    }

    private void update(Connection connection, List<GameIndex> list) throws SQLException {
        Object object;
        if (list.isEmpty()) {
            return;
        }
        Object[][] objectArray = new Object[list.size()][7];
        for (int i = 0; i < objectArray.length; ++i) {
            object = list.get(i);
            objectArray[i][0] = ((GameIndex)object).getMasterId();
            objectArray[i][1] = ((GameIndex)object).getGameType();
            objectArray[i][2] = ((GameIndex)object).getMove();
            objectArray[i][3] = ((GameIndex)object).getProcedure();
            objectArray[i][4] = ((GameIndex)object).getDate();
            objectArray[i][5] = ((GameIndex)object).getFileId();
            objectArray[i][6] = ((GameIndex)object).getFileOrder();
        }
        UQueryRunner uQueryRunner = new UQueryRunner();
        for (Object object2 : object = (Object)uQueryRunner.batch(connection, "UPDATE game_index SET master_id=?, game_type=?, move=?, procedure=?, date=?WHERE file_id=? AND file_order=?", objectArray)) {
            if (object2 == true) continue;
            throw new SQLException("DB is broken: update error record:" + (int)object2);
        }
    }
}

