/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.HashSet;
import java.util.Set;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.ForStackTraceException;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.StartSolvingProblem;
import org.unitarou.yukinoshita.view.cmd.AbstractViewCommand;

public class WrapperCommand
extends AbstractViewCommand {
    private static final Log log_s_ = LogFactory.getLog(WrapperCommand.class);
    private static Set<Class<? extends NodeListCommand>> permittedCommandInView_s_ = new HashSet<Class<? extends NodeListCommand>>(2);
    private final NodeListCommand wrappedCommand_;

    public WrapperCommand(NodeListCommand nodeListCommand) {
        ArgumentChecker.throwIfNull((Object)nodeListCommand);
        this.wrappedCommand_ = nodeListCommand;
    }

    public void execute() {
        this.throwIfNotSetup();
        if (!this.isEditMode().booleanValue() && !permittedCommandInView_s_.contains(this.wrappedCommand_.getClass())) {
            log_s_.log(LogLevel.WARN, new ForStackTraceException(), "Execute command in non-edit mode (BUG ?). {0}", this.wrappedCommand_);
        }
        RgtProxy rgtProxy = this.getCollectionProxy().getActive();
        CommandDriver.Status status = rgtProxy.executeCommand(this.wrappedCommand_);
        this.fireCommandDriverExecuted(status);
        block8: for (ModelInfluence modelInfluence : this.wrappedCommand_.getInfluence()) {
            switch (modelInfluence) {
                case COLLECTION: {
                    this.fireCollectionMonitorUpdate();
                    continue block8;
                }
                case ROOT_GAME_TREE: {
                    rgtProxy.getRootGameTree().clearPropertyCache();
                    this.fireGameViewerUpdate();
                    continue block8;
                }
                case NODE_GAMEINFO: {
                    this.fireGameInfoNodeUpdate();
                    continue block8;
                }
                case NODE_CURRENT: {
                    this.fireNodeViewerUpdate();
                    continue block8;
                }
                case NODE_DOWNWARD: {
                    this.fireNodeListUpdate();
                    continue block8;
                }
                case NODE_PEVIOUS: {
                    this.fireNodeViewerUpdate(-1);
                    continue block8;
                }
            }
            log_s_.log(LogLevel.WARN, "Unsupported influence type, ignore it:{0}", new Object[]{modelInfluence});
        }
        SgfArgumentChecker.throwIfInvalid(this.getCollectionProxy().getActive().getRootGameTree());
    }

    static {
        permittedCommandInView_s_.add(SelectVariation.class);
        permittedCommandInView_s_.add(StartSolvingProblem.class);
    }
}

