/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.ColorResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.board.BlockedBoardDesigner;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.CoordinatesPainter;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.MarkPainter;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleCoordinatesPainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.mp.SimpleMarkerPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgoGraphicalBoardPanel
implements IgoBoardPanel {
    private static final Log log_s_ = LogFactory.getLog(IgoGraphicalBoardPanel.class);
    private static final int MINIMUM_BLOCK_SIZE = 2;
    private static final ColorResource FOREGROUND_CANT_PAINT = new ColorResource(255, 0, 0);
    private static final SgfId[] IDS_STONE = new SgfId[]{SgfId.WHITE, SgfId.BLACK, SgfId.ADD_WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY};
    private Canvas canvas_ = null;
    private SgfRectangle vwOuterBoundary_ = new SgfRectangle();
    private BoardPainter boardPainter_ = BoardPainter.CONTEXT.defaultValue();
    private RuledLinePainter ruledLinePainter_ = new SimpleRuledLinePainter();
    private CoordinatesPainter coordinatesPainter_ = new SimpleCoordinatesPainter();
    private StonePainter stonePainter_ = StonePainter.CONTEXT.defaultValue();
    private MarkPainter markPainter_ = new SimpleMarkerPainter();
    private int blockSize_;
    private Point labelSize_ = new Point(1, 1);
    private Point offsetSize_ = new Point(0, 0);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private NodeView nodeView_;
    private final BlockedBoardDesigner blockedBoardDesigner_ = new BlockedBoardDesigner();
    private CurrentContext context_;
    private final HashMap<SgfPoint, BlockStatus> blockStatusMap_ = new HashMap();
    private Property transientProperty_ = null;
    private Adapter adapter_ = new Adapter();
    private BlockLabelProvider blockLabelProvider_;
    private VariationLabelProvider variationLabelProvider_;
    private boolean showLastMoveMark_;
    private Image imageBuffer_;

    public IgoGraphicalBoardPanel() {
        Yukinoshita.context().addListener(this.adapter_);
        this.blockLabelProvider_ = BlockLabelProvider.CONTEXT.defaultValue();
        this.variationLabelProvider_ = VariationLabelProvider.CONTEXT.defaultValue();
        this.showLastMoveMark_ = true;
        this.context_ = CurrentContext.nullContext;
        this.blockedBoardDesigner_.addBlockPainter(this.boardPainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.ruledLinePainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.stonePainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.markPainter_);
        this.blockedBoardDesigner_.addBlockPainter(this.blockLabelProvider_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.canvas_ = new Canvas(composite, 262144);
        this.canvas_.setBackground(composite.getDisplay().getSystemColor(22));
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle rectangle = new Rectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
                IgoGraphicalBoardPanel.this.paintByDoubleBuffer(paintEvent.gc, rectangle);
            }
        });
        this.canvas_.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                IgoGraphicalBoardPanel.this.blockStatusMap_.clear();
                Swts.disposeQuietly((Resource)IgoGraphicalBoardPanel.this.imageBuffer_);
                IgoGraphicalBoardPanel.this.imageBuffer_ = new Image((Device)IgoGraphicalBoardPanel.this.canvas_.getDisplay(), IgoGraphicalBoardPanel.this.canvas_.getBounds());
                IgoGraphicalBoardPanel.this.refresh();
            }
        });
        return this.canvas_;
    }

    @Override
    public Control getControl() {
        return this.canvas_;
    }

    @Override
    public void close() {
        Yukinoshita.context().removeListener(this.adapter_);
        Swts.disposeQuietly((Resource)this.imageBuffer_);
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.nodeView_ = null;
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintByDoubleBuffer(GC gC, Rectangle rectangle) {
        GC gC2 = null;
        try {
            gC2 = new GC((Drawable)this.imageBuffer_);
            gC.drawImage(this.imageBuffer_, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC2);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (this.nodeView_ == null) {
            return;
        }
        if (this.canvas_.isDisposed()) {
            log_s_.log(LogLevel.WARN, "Call refresh after calling close method.");
            return;
        }
        if (this.canvas_.getBounds().isEmpty()) {
            assert (this.imageBuffer_ == null);
            return;
        }
        this.vwOuterBoundary_ = this.blockedBoardDesigner_.calcVwOuterBoundary();
        SgfSize sgfSize = this.nodeView_.getSize();
        GC gC = null;
        GC gC2 = null;
        try {
            gC = new GC((Drawable)this.canvas_);
            gC2 = new GC((Drawable)this.imageBuffer_);
            this.paintImpl(gC2, this.canvas_.getBounds(), new SgfRectangle(sgfSize));
            gC.drawImage(this.imageBuffer_, 0, 0);
            log_s_.log(LogLevel.TRACE, "Refreshed.");
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC2);
            Swts.disposeQuietly((Resource)gC);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC2);
        Swts.disposeQuietly((Resource)gC);
    }

    private void redraw() {
        assert (this.nodeView_ != null);
        SgfRectangle sgfRectangle = this.vwOuterBoundary_;
        this.vwOuterBoundary_ = this.blockedBoardDesigner_.calcVwOuterBoundary();
        if (sgfRectangle.equals(this.vwOuterBoundary_)) {
            this.redrawImpl(this.blockedBoardDesigner_.getRedrawBlocks());
        } else {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawImpl(Collection<SgfPoint> collection) {
        Rectangle rectangle;
        SgfRectangle sgfRectangle;
        GC gC;
        GC gC2;
        SgfRectangle[] sgfRectangleArray;
        block10: {
            sgfRectangleArray = SgfRectangle.createRegularRectangles(collection);
            if (sgfRectangleArray.length == 0) {
                return;
            }
            if (this.canvas_.getBounds().isEmpty()) {
                assert (this.imageBuffer_ == null);
                return;
            }
            this.calcDrawParameters();
            gC2 = null;
            gC = null;
            gC2 = new GC((Drawable)this.canvas_);
            gC = new GC((Drawable)this.imageBuffer_);
            sgfRectangle = SgfRectangle.create(collection);
            sgfRectangle.union(this.vwOuterBoundary_);
            rectangle = this.calcDrawArea(sgfRectangle);
            if (rectangle.x >= 0 && rectangle.y >= 0 && rectangle.width >= 0 && rectangle.height >= 0) break block10;
            log_s_.log(LogLevel.DEBUG, "[BUG] {0}", rectangle);
            Swts.disposeQuietly((Resource)gC);
            Swts.disposeQuietly((Resource)gC2);
            return;
        }
        try {
            if (this.transientProperty_ != null || 15 <= sgfRectangleArray.length) {
                this.paintImpl(gC, rectangle, sgfRectangle);
            } else {
                Rectangle[] rectangleArray = new Rectangle[sgfRectangleArray.length];
                for (int i = 0; i < rectangleArray.length; ++i) {
                    SgfRectangle sgfRectangle2 = sgfRectangleArray[i];
                    sgfRectangle2.union(this.vwOuterBoundary_);
                    rectangleArray[i] = this.calcDrawArea(sgfRectangle2);
                }
                this.paintImpl(gC, rectangleArray, sgfRectangleArray);
            }
            gC2.drawImage(this.imageBuffer_, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (log_s_.isEnabled(LogLevel.TRACE)) {
                this.logRedraw(rectangle, sgfRectangle, sgfRectangleArray);
            }
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            Swts.disposeQuietly((Resource)gC2);
            throw throwable;
        }
        Swts.disposeQuietly((Resource)gC);
        Swts.disposeQuietly((Resource)gC2);
    }

    private void logRedraw(Rectangle rectangle, SgfRectangle sgfRectangle, SgfRectangle[] sgfRectangleArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[REDRAW] #area=").append(sgfRectangleArray.length).append(", ").append(rectangle).append(" all area=[").append(sgfRectangle.getStart().x() - this.vwOuterBoundary_.getStart().x() + 1).append(",").append(sgfRectangle.getStart().y() - this.vwOuterBoundary_.getStart().y() + 1).append("]-[").append(sgfRectangle.getStart().x() - this.vwOuterBoundary_.getStart().x() + sgfRectangle.width()).append(",").append(sgfRectangle.getStart().y() - this.vwOuterBoundary_.getStart().y() + sgfRectangle.height()).append("]");
        log_s_.log(LogLevel.TRACE, stringBuilder.toString());
    }

    private void paintImpl(GC gC, Rectangle rectangle, SgfRectangle sgfRectangle) {
        this.paintImpl(gC, new Rectangle[]{rectangle}, new SgfRectangle[]{sgfRectangle});
    }

    private void paintImpl(GC gC, Rectangle[] rectangleArray, SgfRectangle[] sgfRectangleArray) {
        if (this.nodeView_ == null) {
            log_s_.log(LogLevel.INFO, "Call paintImpl(GC gc, Rectangle paintArea, SgfRectangle redrawArea) before init model.");
            return;
        }
        SgfSize sgfSize = this.nodeView_.getSize();
        this.vwOuterBoundary_ = this.blockedBoardDesigner_.calcVwOuterBoundary();
        this.calcDrawParameters();
        if (this.blockSize_ < 2) {
            this.paintCantDraw(gC);
            return;
        }
        Rectangle rectangle = this.calcDrawArea(this.vwOuterBoundary_);
        this.paintBackground(gC, rectangle);
        this.coordinatesPainter_.paint(gC, rectangle, this.vwOuterBoundary_, new boolean[]{true, true, false, false});
        for (int i = 0; i < rectangleArray.length; ++i) {
            this.paintBlockArea(gC, sgfSize, rectangleArray[i], sgfRectangleArray[i]);
        }
        this.paintLabel(gC);
        this.paintLine(gC);
        this.paintVariation(gC);
        this.paintTransientStone(gC, rectangle);
        this.paintTransientMarkers(gC);
    }

    private void paintBlockArea(GC gC, SgfSize sgfSize, Rectangle rectangle, SgfRectangle sgfRectangle) {
        for (int i = this.vwOuterBoundary_.getStart().y(); i <= this.vwOuterBoundary_.getEnd().y(); ++i) {
            for (int j = this.vwOuterBoundary_.getStart().x(); j <= this.vwOuterBoundary_.getEnd().x(); ++j) {
                SgfPoint sgfPoint = SgfPoint.create(sgfSize, j, i);
                if (!sgfRectangle.contains(sgfPoint)) continue;
                if (this.blockedBoardDesigner_.isDrawArea(sgfPoint)) {
                    this.paintBlockImpl(gC, rectangle, sgfPoint);
                    continue;
                }
                this.paintBackground(gC, sgfPoint);
            }
        }
    }

    private void paintCantDraw(GC gC) {
        Point point = this.canvas_.getSize();
        int n = Math.min(point.x, point.y);
        gC.setForeground(FOREGROUND_CANT_PAINT.get());
        gC.setBackground(Display.getCurrent().getSystemColor(22));
        gC.fillRectangle(0, 0, point.x, point.y);
        gC.drawRectangle(0, 0, n - 1, n - 1);
        gC.drawLine(0, 0, n, n);
        gC.drawLine(0, n, n, 0);
    }

    private void paintBackground(GC gC, Rectangle rectangle) {
        gC.setBackground(this.canvas_.getBackground());
        Rectangle rectangle2 = this.canvas_.getBounds();
        gC.fillRectangle(0, 0, rectangle.x, rectangle2.height);
        gC.fillRectangle(rectangle.x, 0, rectangle2.width, rectangle.y);
        SgfSize sgfSize = this.nodeView_.getSize();
        int n = this.vwOuterBoundary_.getEnd().x() == sgfSize.width() ? 1 : 0;
        gC.fillRectangle(rectangle.x + rectangle.width + n, rectangle.y, rectangle2.width, rectangle2.height);
        int n2 = this.vwOuterBoundary_.getEnd().y() == sgfSize.height() ? 1 : 0;
        gC.fillRectangle(rectangle.x, rectangle.y + rectangle.height + n2, rectangle2.width, rectangle2.height);
    }

    private void paintBackground(GC gC, SgfPoint sgfPoint) {
        gC.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        Rectangle rectangle = this.calcBlockArea(sgfPoint);
        ++rectangle.width;
        ++rectangle.height;
        gC.fillRectangle(rectangle);
    }

    private void paintBlockImpl(GC gC, Rectangle rectangle, SgfPoint sgfPoint) {
        Rectangle rectangle2 = this.calcBlockArea(sgfPoint);
        if (rectangle2.x + rectangle2.width < rectangle.x || rectangle.x + rectangle.width < rectangle2.x || rectangle2.y + rectangle2.height < rectangle.y || rectangle.y + rectangle.height < rectangle2.y) {
            return;
        }
        this.boardPainter_.paint(gC, sgfPoint, rectangle2);
        this.ruledLinePainter_.paint(gC, sgfPoint, rectangle2);
        this.paintStone(gC, sgfPoint, rectangle2);
        this.paintMarks(gC, sgfPoint, rectangle2);
        this.paintStatus(gC, this.blockStatusMap_.get(sgfPoint));
    }

    private void calcDrawParameters() {
        Rectangle rectangle = this.canvas_.getBounds();
        this.labelSize_ = this.coordinatesPainter_.calcLabelSize(this.vwOuterBoundary_);
        this.blockSize_ = Math.min((rectangle.width - this.labelSize_.x) / this.vwOuterBoundary_.width(), (rectangle.height - this.labelSize_.y) / this.vwOuterBoundary_.height());
        this.blockSize_ = Math.min(this.blockSize_, this.context_.getInteger(Context.MAX_STONE_SIZE));
        this.offsetSize_.x = (rectangle.width - (this.blockSize_ * this.vwOuterBoundary_.width() + this.labelSize_.x)) / 2;
        this.offsetSize_.y = (rectangle.height - (this.blockSize_ * this.vwOuterBoundary_.height() + this.labelSize_.y)) / 2;
    }

    private Rectangle calcBlockArea(SgfPoint sgfPoint) {
        return new Rectangle(this.labelSize_.x + (sgfPoint.x() - this.vwOuterBoundary_.getStart().x()) * this.blockSize_ + this.offsetSize_.x, this.labelSize_.y + (sgfPoint.y() - this.vwOuterBoundary_.getStart().y()) * this.blockSize_ + this.offsetSize_.y, this.blockSize_, this.blockSize_);
    }

    private Rectangle calcDrawArea(SgfRectangle sgfRectangle) {
        return new Rectangle(this.labelSize_.x + (sgfRectangle.getStart().x() - this.vwOuterBoundary_.getStart().x()) * this.blockSize_ + this.offsetSize_.x, this.labelSize_.y + (sgfRectangle.getStart().y() - this.vwOuterBoundary_.getStart().y()) * this.blockSize_ + this.offsetSize_.y, sgfRectangle.width() * this.blockSize_, sgfRectangle.height() * this.blockSize_);
    }

    private void paintStone(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        StonePainterParameter stonePainterParameter;
        EnumSet<SgfPointType> enumSet = this.getBlockStatusImpl(sgfPoint).getPointTypes();
        if (enumSet.contains((Object)SgfPointType.WHITE)) {
            stonePainterParameter = new StonePainterParameter();
            stonePainterParameter.setSgfColor(SgfColor.WHITE);
        } else if (enumSet.contains((Object)SgfPointType.BLACK)) {
            stonePainterParameter = new StonePainterParameter();
            stonePainterParameter.setSgfColor(SgfColor.BLACK);
        } else {
            return;
        }
        if (this.transientProperty_ != null) {
            for (SgfId sgfId : IDS_STONE) {
                if (!this.transientProperty_.contains(sgfId, sgfPoint.getString())) continue;
                stonePainterParameter.setTransient(true);
                break;
            }
        }
        Stone stone = this.nodeView_.getMove();
        String string = this.blockLabelProvider_.getLabel(this.nodeView_, sgfPoint);
        stonePainterParameter.setLastMove(this.showLastMoveMark_ && sgfPoint.equals(stone.getPoint()));
        stonePainterParameter.setLabel(string);
        this.stonePainter_.paintStone(gC, rectangle, stonePainterParameter);
    }

    private void paintMarks(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        for (SgfId sgfId : this.blockedBoardDesigner_.getMarkers(sgfPoint)) {
            if (this.transientProperty_ != null && this.transientProperty_.contains(sgfId, sgfPoint.getString())) break;
            this.markPainter_.paintMark(gC, rectangle, sgfId, false);
        }
    }

    private void paintStatus(GC gC, BlockStatus blockStatus) {
        this.markPainter_.paintStatus(gC, blockStatus);
    }

    private void paintTransientStone(GC gC, Rectangle rectangle) {
        if (this.transientProperty_ == null) {
            return;
        }
        SgfColor sgfColor = SgfColor.getStoneColor(this.transientProperty_.sgfId());
        if (sgfColor == null) {
            return;
        }
        StonePainterParameter stonePainterParameter = new StonePainterParameter();
        stonePainterParameter.setLabel(null);
        stonePainterParameter.setLastMove(false);
        stonePainterParameter.setTransient(true);
        stonePainterParameter.setSgfColor(sgfColor);
        for (String string : this.transientProperty_.getStrings()) {
            Rectangle rectangle2;
            SgfPoint sgfPoint = SgfPoint.parseMoveQuietly(this.nodeView_.getSize(), string);
            if (sgfPoint == null || 0 != Geometry.getRelativePosition(rectangle, Geometry.centerPoint(rectangle2 = this.calcBlockArea(sgfPoint)))) continue;
            this.stonePainter_.paintStone(gC, rectangle2, stonePainterParameter);
        }
    }

    private void paintTransientMarkers(GC gC) {
        if (this.transientProperty_ == null) {
            return;
        }
        SgfId[] sgfIdArray = this.markPainter_.markerScope();
        for (int i = 0; i < sgfIdArray.length; ++i) {
            if (!sgfIdArray[i].equals(this.transientProperty_.sgfId())) continue;
            for (String string : this.transientProperty_.getStrings()) {
                SgfPoint sgfPoint = SgfPoint.parseMoveQuietly(this.nodeView_.getSize(), string);
                if (sgfPoint == null) continue;
                Rectangle rectangle = this.calcBlockArea(sgfPoint);
                this.markPainter_.paintMark(gC, rectangle, sgfIdArray[i], true);
            }
        }
    }

    private void paintLabel(GC gC) {
        Rectangle rectangle;
        Label[] labelArray = this.blockedBoardDesigner_.getLabels();
        for (int i = 0; i < labelArray.length; ++i) {
            rectangle = this.calcBlockArea(labelArray[i].getPoint());
            this.markPainter_.paintLabel(gC, rectangle, labelArray[i], false);
        }
        if (this.transientProperty_ == null || !this.transientProperty_.sgfId().equals(SgfId.LABEL)) {
            return;
        }
        Label label = Label.parseQuietly(this.nodeView_.getSize(), this.transientProperty_.getStrings()[0]);
        rectangle = this.calcBlockArea(label.getPoint());
        this.markPainter_.paintLabel(gC, rectangle, label, true);
    }

    private void paintLine(GC gC) {
        for (SgfId sgfId : new SgfId[]{SgfId.LINE, SgfId.ARROW}) {
            String string = "";
            if (this.transientProperty_ != null && sgfId.equals(this.transientProperty_.sgfId())) {
                string = this.transientProperty_.getStrings()[0];
            }
            this.paintLineImpl(gC, sgfId, string);
        }
    }

    private void paintLineImpl(GC gC, SgfId sgfId, String string) {
        Rectangle rectangle;
        for (SgfLine sgfLine : this.blockedBoardDesigner_.getLine(sgfId)) {
            rectangle = this.calcBlockArea(sgfLine.getStart());
            Rectangle rectangle2 = this.calcBlockArea(sgfLine.getEnd());
            this.markPainter_.paintLine(gC, rectangle, rectangle2, sgfId, sgfLine.getString().equals(string));
        }
        if (this.transientProperty_ == null || !sgfId.equals(this.transientProperty_.sgfId())) {
            return;
        }
        Object[] objectArray = this.transientProperty_.getStrings();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                SgfLine sgfLine;
                SgfLine sgfLine2 = SgfLine.parse(this.nodeView_.getSize(), (String)objectArray[i]);
                sgfLine = this.calcBlockArea(sgfLine2.getStart());
                rectangle = this.calcBlockArea(sgfLine2.getEnd());
                this.markPainter_.paintLine(gC, (Rectangle)sgfLine, rectangle, sgfId, true);
                continue;
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
    }

    private void paintVariation(GC gC) {
        Object object;
        NodeView[] nodeViewArray = this.nodeView_.getVariations();
        if (nodeViewArray.length == 0) {
            return;
        }
        HashMap<SgfPoint, Rectangle> hashMap = new HashMap<SgfPoint, Rectangle>(nodeViewArray.length);
        for (int i = 0; i < nodeViewArray.length; ++i) {
            SgfPoint object2;
            if (!this.nodeView_.isChildrenStyle() && i == this.nodeView_.getSelectedVariationIndex() || (object2 = nodeViewArray[i].getMove().getPoint()) == null || SgfPointType.PASS.equals((Object)object2.condition())) continue;
            object = (List)hashMap.get(object2);
            if (object == null) {
                object = new ArrayList(nodeViewArray.length);
                hashMap.put(object2, (Rectangle)object);
            }
            object.add(this.variationLabelProvider_.getVariationLabel(i));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = this.calcBlockArea((SgfPoint)entry.getKey());
            List list = (List)entry.getValue();
            String[] stringArray = list.toArray(new String[list.size()]);
            this.markPainter_.paintVariation(gC, (Rectangle)object, stringArray);
        }
    }

    @Override
    public void paintInTransient(Property property) {
        boolean bl = Objects.equalsIncludeNull(this.transientProperty_, property);
        if (bl) {
            this.transientProperty_ = property;
        } else {
            ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>();
            this.addRedrawPoint(property, arrayList);
            this.addRedrawPoint(this.transientProperty_, arrayList);
            this.transientProperty_ = property;
            this.redrawImpl(arrayList);
        }
    }

    private void addRedrawPoint(Property property, List<SgfPoint> list) {
        if (property == null || this.addDdRedrawPoint(property, list)) {
            return;
        }
        switch (property.sgfId().valueType()) {
            case CPOINT: 
            case POINT: 
            case MOVE: {
                SgfPoint[] sgfPointArray;
                for (SgfPoint sgfPoint : sgfPointArray = SgfPoint.parse(this.nodeView_.getSize(), property.getStrings())) {
                    this.blockedBoardDesigner_.addRedrawPoint(sgfPoint);
                    list.add(sgfPoint);
                }
                return;
            }
        }
    }

    private boolean addDdRedrawPoint(Property property, List<SgfPoint> list) {
        if (!SgfId.DIM_POINTS.equals(property.sgfId())) {
            return false;
        }
        SgfPoint[] sgfPointArray = SgfPoint.parse(this.nodeView_.getSize(), property.getStrings());
        if (sgfPointArray.length != 1 || !sgfPointArray[0].condition().equals((Object)SgfPointType.PASS)) {
            for (SgfPoint sgfPoint : sgfPointArray) {
                this.blockedBoardDesigner_.addRedrawPoint(sgfPoint);
                list.add(sgfPoint);
            }
            return true;
        }
        for (int i = this.vwOuterBoundary_.getStart().x(); i < this.vwOuterBoundary_.getEnd().x(); ++i) {
            for (int j = this.vwOuterBoundary_.getStart().y(); j < this.vwOuterBoundary_.getEnd().y(); ++j) {
                SgfPoint sgfPoint = SgfPoint.create(sgfPointArray[0].size(), i, j);
                list.add(sgfPoint);
                this.blockedBoardDesigner_.addRedrawPoint(sgfPoint);
            }
        }
        return true;
    }

    @Override
    public NodeView getNodeView() {
        return this.nodeView_;
    }

    @Override
    public BlockStatus getBlockStatus(Point point) {
        ArgumentChecker.throwIfNull((Object)point);
        int n = (int)Math.floor((double)(point.x - this.labelSize_.x - this.offsetSize_.x) / (double)this.blockSize_) + this.vwOuterBoundary_.getStart().x();
        int n2 = (int)Math.floor((double)(point.y - this.labelSize_.y - this.offsetSize_.y) / (double)this.blockSize_) + this.vwOuterBoundary_.getStart().y();
        SgfSize sgfSize = this.nodeView_.getSize();
        if (!sgfSize.check(n, n2).equals((Object)SgfPointType.IN)) {
            return this.getBlockStatusImpl(null);
        }
        SgfPoint sgfPoint = SgfPoint.create(sgfSize, n, n2);
        if (!this.blockedBoardDesigner_.isDrawArea(sgfPoint)) {
            return this.getBlockStatusImpl(null);
        }
        return this.getBlockStatusImpl(sgfPoint);
    }

    private BlockStatus getBlockStatusImpl(SgfPoint sgfPoint) {
        BlockStatus blockStatus = this.blockStatusMap_.get(sgfPoint);
        if (blockStatus != null) {
            return blockStatus;
        }
        blockStatus = this.createBlockStatus(sgfPoint);
        this.blockStatusMap_.put(sgfPoint, blockStatus);
        return blockStatus;
    }

    private BlockStatus createBlockStatus(SgfPoint sgfPoint) {
        BlockStatus blockStatus = new BlockStatus();
        if (sgfPoint == null) {
            return blockStatus;
        }
        blockStatus.setPoint(sgfPoint);
        blockStatus.setPointTypes(this.nodeView_.getPointTypes(sgfPoint));
        blockStatus.setRectangle(this.calcBlockArea(sgfPoint));
        return blockStatus;
    }

    @Override
    public void setContext(CurrentContext currentContext) {
        ArgumentChecker.throwIfNull((Object)currentContext);
        this.context_ = currentContext;
        boolean bl = false;
        bl |= this.updateBoardPainter(new HashSet<String>());
        bl |= this.updateStonePainter();
        bl |= this.updateBlockLabelProvider();
        bl |= this.updateCoordinatesLabelProvider();
        bl |= this.updateVariationLabelProvider();
        if (this.showLastMoveMark_ != this.context_.getAttribute(Context.SHOW_LAST_MOVE_MARK)) {
            this.showLastMoveMark_ = !this.showLastMoveMark_;
            bl = true;
        }
        if (bl) {
            this.refresh();
        }
    }

    @Override
    public void update(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        NodeList nodeList = this.nodeView_ != null ? this.nodeView_.getNodeList() : null;
        this.nodeView_ = nodeView;
        this.blockedBoardDesigner_.update(nodeView);
        this.blockStatusMap_.clear();
        for (SgfPoint sgfPoint : nodeView.getIgoBoard().validate()) {
            BlockStatus blockStatus = this.createBlockStatus(sgfPoint);
            EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
            enumSet.add(SgfPointType.OVERLAP);
            blockStatus.setPointTypes(enumSet);
            this.blockStatusMap_.put(sgfPoint, blockStatus);
            this.blockedBoardDesigner_.addRedrawPoint(sgfPoint);
        }
        if (this.nodeView_.getNodeList() != nodeList) {
            this.refresh();
        } else {
            this.redraw();
        }
    }

    private boolean updateBoardPainter(Set<String> set) {
        BoardPainter boardPainter = this.context_.getProvider(BoardPainter.class);
        if (!this.boardPainter_.equals(boardPainter)) {
            this.blockedBoardDesigner_.removeBlockPainter(this.boardPainter_);
            this.boardPainter_ = boardPainter;
            this.blockedBoardDesigner_.addBlockPainter(this.boardPainter_);
            return true;
        }
        return this.boardPainter_.containsContextKey(set);
    }

    private boolean updateStonePainter() {
        StonePainter stonePainter = this.context_.getProvider(StonePainter.class);
        if (!this.stonePainter_.equals(stonePainter)) {
            this.blockedBoardDesigner_.removeBlockPainter(this.stonePainter_);
            this.stonePainter_ = stonePainter;
            this.blockedBoardDesigner_.addBlockPainter(this.stonePainter_);
            return true;
        }
        return false;
    }

    private boolean updateBlockLabelProvider() {
        BlockLabelProvider blockLabelProvider = this.context_.getProvider(BlockLabelProvider.class);
        if (!this.blockLabelProvider_.equals(blockLabelProvider)) {
            this.blockedBoardDesigner_.removeBlockPainter(this.blockLabelProvider_);
            this.blockLabelProvider_ = blockLabelProvider;
            this.blockedBoardDesigner_.addBlockPainter(this.blockLabelProvider_);
            return true;
        }
        return false;
    }

    private boolean updateCoordinatesLabelProvider() {
        CoordinatesLabelProvider coordinatesLabelProvider = this.context_.getProvider(CoordinatesLabelProvider.class);
        this.coordinatesPainter_.setLabelProvider(coordinatesLabelProvider);
        return true;
    }

    private boolean updateVariationLabelProvider() {
        VariationLabelProvider variationLabelProvider = this.context_.getProvider(VariationLabelProvider.class);
        if (!this.variationLabelProvider_.equals(variationLabelProvider)) {
            this.variationLabelProvider_ = variationLabelProvider;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    EventBrokerMonitor,
    ContextListener {
        private Adapter() {
        }

        @Override
        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            IgoGraphicalBoardPanel.this.context_ = rgtProxy.getContext();
            IgoGraphicalBoardPanel.this.updateBoardPainter(new HashSet());
            IgoGraphicalBoardPanel.this.updateStonePainter();
            IgoGraphicalBoardPanel.this.updateBlockLabelProvider();
            IgoGraphicalBoardPanel.this.updateCoordinatesLabelProvider();
            IgoGraphicalBoardPanel.this.updateVariationLabelProvider();
            IgoGraphicalBoardPanel.this.showLastMoveMark_ = IgoGraphicalBoardPanel.this.context_.getAttribute(Context.SHOW_LAST_MOVE_MARK);
            IgoGraphicalBoardPanel.this.update(rgtProxy.getCurrentNodeView());
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            IgoGraphicalBoardPanel.this.update(nodeView);
            Map<SgfPoint, Integer> map = DatabaseManager.instance().findNextMove(nodeView.getNodeList());
            if (map.isEmpty()) {
                return;
            }
            ArrayList<Map.Entry<SgfPoint, Integer>> arrayList = new ArrayList<Map.Entry<SgfPoint, Integer>>(map.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<SgfPoint, Integer>>(){

                @Override
                public int compare(Map.Entry<SgfPoint, Integer> entry, Map.Entry<SgfPoint, Integer> entry2) {
                    return entry.getValue() - entry2.getValue();
                }
            });
            SgfColor sgfColor = nodeView.getNextMoveColor();
            ArrayList<SgfPoint> arrayList2 = new ArrayList<SgfPoint>();
            for (Map.Entry entry : arrayList) {
                System.out.println(entry.getKey() + ":" + entry.getValue());
                arrayList2.add((SgfPoint)entry.getKey());
            }
            Property property = new Property(sgfColor.setupType(), arrayList2);
            IgoGraphicalBoardPanel.this.paintInTransient(property);
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            IgoGraphicalBoardPanel.this.eventBroker_.removeView(IgoGraphicalBoardPanel.this);
            IgoGraphicalBoardPanel.this.eventBroker_.disconnect();
            IgoGraphicalBoardPanel.this.eventBroker_ = eventBroker;
            IgoGraphicalBoardPanel.this.eventBroker_.addView(IgoGraphicalBoardPanel.this);
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            boolean bl = false;
            bl |= IgoGraphicalBoardPanel.this.updateBoardPainter(set);
            if (set.contains(StonePainter.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateStonePainter();
            }
            if (set.contains(BlockLabelProvider.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateBlockLabelProvider();
            }
            if (set.contains(CoordinatesLabelProvider.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateCoordinatesLabelProvider();
            }
            if (set.contains(VariationLabelProvider.class.getName())) {
                bl |= IgoGraphicalBoardPanel.this.updateVariationLabelProvider();
            }
            if (set.contains(Context.SHOW_LAST_MOVE_MARK.id())) {
                IgoGraphicalBoardPanel.this.showLastMoveMark_ = IgoGraphicalBoardPanel.this.context_.getAttribute(Context.SHOW_LAST_MOVE_MARK);
                bl = true;
            }
            if (set.contains(Context.MAX_STONE_SIZE.id())) {
                bl = true;
            }
            if (bl) {
                IgoGraphicalBoardPanel.this.refresh();
            }
        }
    }
}

