/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.EnumSet;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.AddMove;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.model.cmd.RemoveLastNode;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

class MoveEventDelegator
implements EventDelegator {
    private SgfColor selectedColor_ = SgfColor.BLACK;

    public void resetStatus() {
        this.selectedColor_ = SgfColor.BLACK;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, EventBroker eventBroker, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)eventBroker);
        BlockSituation blockSituation = new BlockSituation();
        EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
        if (enumSet.contains((Object)SgfPointType.FORBIDDEN) || !enumSet.contains((Object)SgfPointType.EMPTY) || !nodeView.isLast()) {
            return blockSituation;
        }
        SgfColor sgfColor = nodeView.getNextMoveColor();
        if (blockStatus.getPoint() == null) {
            blockSituation.setCursor(CanvasCursor.PASS.get(sgfColor));
        } else {
            blockSituation.setCursor(CanvasCursor.MOVE.get(sgfColor));
            if (sgfColor == null) {
                sgfColor = this.selectedColor_;
            }
            blockSituation.setTransientProperty(sgfColor.moveType().makeProperty(blockStatus.getPoint()));
        }
        return blockSituation;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (mouseEvent.button == 3 && nodeView.isLast() && !nodeView.isFirst()) {
            RemoveLastNode removeLastNode = new RemoveLastNode();
            eventBroker.executeCommand(removeLastNode);
            return true;
        }
        EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
        if (enumSet.contains((Object)SgfPointType.FORBIDDEN) || !enumSet.contains((Object)SgfPointType.EMPTY)) {
            return false;
        }
        SgfColor sgfColor = nodeView.getNextMoveColor();
        if (mouseEvent.button == 1 && nodeView.isLast()) {
            Object object;
            SgfPoint sgfPoint = blockStatus.getPoint();
            if (sgfPoint == null) {
                sgfPoint = SgfPoint.createPass(nodeView.getSize());
            }
            if (sgfColor == null) {
                sgfColor = this.selectedColor_;
                object = new Property();
                ((Property)object).setId(SgfId.PLAYER_TO_PLAY.id());
                ((Property)object).setValue(new Value(sgfColor.getString()));
                eventBroker.executeCommand(new UpdateProperty(null, (Property)object, new Property[0]));
            }
            object = new AddMove(sgfColor, sgfPoint);
            eventBroker.executeCommand((NodeListCommand)object);
            return true;
        }
        return false;
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        switch (n) {
            case 131072: {
                this.selectedColor_ = this.selectedColor_.opposite();
                break;
            }
            case 262144: {
                this.selectedColor_ = this.selectedColor_.opposite();
            }
        }
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }
}

