/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprint;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.view.jface.board.FingerprintPainter;
import org.unitarou.yukinoshita.view.jface.db.HitMissPainter;

public class FingerprintMatchingPainter
extends FingerprintPainter {
    private final HitMissPainter hitPainter_ = new HitMissPainter(new RGB(0, 0, 255));
    private final HitMissPainter missPainter_ = new HitMissPainter(new RGB(255, 0, 0));
    private byte[] hits_;
    private byte[] miss_;

    public void paint(GC gC, Rectangle rectangle, SearchedFile searchedFile, SearchFileCondition searchFileCondition) {
        Object object;
        GameType gameType = GameType.valueOf(searchedFile.getGameType());
        SgfSize sgfSize = SgfSize.create(searchedFile.getWidth(), searchedFile.getHeight());
        byte[] byArray = searchedFile.getFingerprint();
        if (sgfSize.equals(searchFileCondition.getSgfSize())) {
            object = this.getMatchFingerprint(byArray, searchFileCondition, gameType);
            this.hits_ = this.calcHitPoints(byArray, (byte[][])object);
            this.miss_ = this.calcMissPoints(byArray, (byte[][])object);
        } else {
            this.hits_ = new byte[byArray.length];
            this.miss_ = this.hits_;
        }
        object = new Fingerprint(sgfSize, gameType);
        ((Fingerprint)object).setBytes(byArray);
        this.paint(gC, rectangle, (Fingerprint)object);
    }

    private byte[][] getMatchFingerprint(byte[] byArray, SearchFileCondition searchFileCondition, GameType gameType) {
        if (searchFileCondition.isFingerprintQueryMode()) {
            return this.getFingerprintMatch(byArray, searchFileCondition);
        }
        if (searchFileCondition.isMoveQueryMode()) {
            return this.getMoveMatch(byArray, searchFileCondition, gameType);
        }
        return new byte[2][byArray.length];
    }

    private byte[][] getFingerprintMatch(byte[] byArray, SearchFileCondition searchFileCondition) {
        return this.getMatch(byArray, searchFileCondition.getFingerprint(), searchFileCondition.getNonTargetAreas());
    }

    private byte[][] getMoveMatch(byte[] byArray, SearchFileCondition searchFileCondition, GameType gameType) {
        String[] stringArray = searchFileCondition.getMoveAllQuery();
        byte[][] byArrayArray = new byte[stringArray.length * 2][];
        byte[][] byArrayArray2 = new byte[byArrayArray.length][];
        int n = 0;
        SgfSize sgfSize = searchFileCondition.getSgfSize();
        for (String string : stringArray) {
            Fingerprint fingerprint = new Fingerprint(sgfSize, gameType);
            Fingerprint fingerprint2 = new Fingerprint(sgfSize, gameType);
            Fingerprint fingerprint3 = new Fingerprint(sgfSize, gameType);
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            HashSet<SgfPoint> hashSet2 = new HashSet<SgfPoint>();
            HashSet<SgfPoint> hashSet3 = new HashSet<SgfPoint>();
            HashSet<SgfPoint> hashSet4 = new HashSet<SgfPoint>();
            HashSet<SgfPoint> hashSet5 = new HashSet<SgfPoint>();
            for (int i = 0; i < string.length(); i += 2) {
                SgfPoint sgfPoint = SgfPoint.parseMoveQuietly(sgfSize, string.substring(i, i + 2));
                if (sgfPoint == null) continue;
                if (i % 4 == 0) {
                    hashSet.add(sgfPoint);
                    hashSet4.add(sgfPoint);
                } else {
                    hashSet2.add(sgfPoint);
                    hashSet3.add(sgfPoint);
                }
                hashSet5.add(sgfPoint);
            }
            fingerprint.setStone(hashSet, (byte)1);
            fingerprint.setStone(hashSet2, (byte)2);
            fingerprint2.setStone(hashSet3, (byte)1);
            fingerprint2.setStone(hashSet4, (byte)2);
            fingerprint3.setStone(hashSet5, (byte)3);
            byArrayArray[n] = fingerprint.getBytes();
            byArrayArray[n + 1] = fingerprint2.getBytes();
            byArrayArray2[n] = fingerprint3.getBytes();
            byArrayArray2[n + 1] = fingerprint3.getBytes();
            n += 2;
        }
        return this.getMatch(byArray, byArrayArray, byArrayArray2);
    }

    private byte[][] getMatch(byte[] byArray, byte[][] byArray2, byte[][] byArray3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < byArray2.length; ++i) {
            int n2 = Fingerprints.similarity(byArray3[i], byArray2[i], byArray);
            if (n2 < n) {
                n = n2;
                arrayList.clear();
                arrayList.add(i);
                continue;
            }
            if (n2 != n) continue;
            arrayList.add(i);
        }
        byte[][] byArray4 = new byte[2][byArray.length];
        for (Integer n3 : arrayList) {
            int n4 = n3;
            for (int i = 0; i < byArray.length; ++i) {
                byte[] byArray5 = byArray4[0];
                int n5 = i;
                byArray5[n5] = (byte)(byArray5[n5] | byArray2[n4][i]);
                byte[] byArray6 = byArray4[1];
                int n6 = i;
                byArray6[n6] = (byte)(byArray6[n6] | byArray3[n4][i]);
            }
        }
        return byArray4;
    }

    private byte[] calcHitPoints(byte[] byArray, byte[][] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray2[1][i] & ~(byArray[i] ^ byArray2[0][i]));
        }
        return byArray3;
    }

    private byte[] calcMissPoints(byte[] byArray, byte[][] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray2[1][i] & (byArray[i] ^ byArray2[0][i]));
        }
        return byArray3;
    }

    protected void drawBackGround(GC gC, Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle);
        gC.setBackground(gC.getDevice().getSystemColor(25));
        gC.fillRectangle(rectangle);
    }

    protected void drawBlock(GC gC, Rectangle rectangle, Fingerprint fingerprint, SgfPoint sgfPoint) {
        super.drawBlock(gC, rectangle, fingerprint, sgfPoint);
        if (3 == Fingerprints.getValue(this.hits_, sgfPoint)) {
            this.hitPainter_.paint(gC, rectangle, false);
        }
        if (0 != Fingerprints.getValue(this.miss_, sgfPoint)) {
            this.missPainter_.paint(gC, rectangle, false);
        }
    }
}

