/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.io.Ios;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.ml.Messages;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.jface.db.UpdateMode;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

public class UpdateDatabaseDialog
extends TitleAreaDialog {
    private static final int BUTTON_START_ID = 1024;
    private static final Messages messages_s_ = Messages.createByPackage(UpdateDatabaseDialog.class);
    private static final Message NT_UPDATE_DATABASE = new Message(UpdateDatabaseDialog.class, "ntUpdateDatabase");
    private static final Message NT_REGISTER_SGF_TO_DATABASE = new Message(UpdateDatabaseDialog.class, "ntRegisterSgfToDatabase");
    private static final Message LB_COLUMN_PATH = new Message(UpdateDatabaseDialog.class, "lbColumnPath");
    private static final Message CLB_ADD_PATH = new Message(UpdateDatabaseDialog.class, "clbAddPath");
    private static final Message CLB_REMOVE_PATH = new Message(UpdateDatabaseDialog.class, "clbRemovePath");
    private static final Message LB_UPDATE_MODE = new Message(UpdateDatabaseDialog.class, "lbUpdatMode");
    private static final Message CLB_START = new Message(UpdateDatabaseDialog.class, "clbStart");
    private static final Message NT_SET_ROOT_FOLDER = new Message(UpdateDatabaseDialog.class, "ntSetRootFolder");
    private static final Message MSG_SET_ROOT_FOLDER = new Message(UpdateDatabaseDialog.class, "msgSetRootFolder");
    private static final Message MSG_ERR_NO_FOLDER = new Message(UpdateDatabaseDialog.class, "msgErrNoFolder");
    private static final Message MSG_INFO_UPDATE_BY_START_BUTTON = new Message(UpdateDatabaseDialog.class, "msgInfoUpdateByStartButton");
    private static final ContextValue<UpdateMode> UPDATE_MODE = new ContextValue<UpdateMode>(UpdateMode.class, "updateMode", UpdateMode.ALL_FILES);
    private static final ContextValue<File> LAST_PATH = new ContextValue<File>(UpdateDatabaseDialog.class, "lastPath", Ios.getCurrentDirectory());
    private static final ContextValue<File[]> TARGET_PATHS = new ContextValue<File[]>(UpdateDatabaseDialog.class, "targetPaths", new File[0]);
    private Composite frame_ = null;
    private Table tblPath_ = null;
    private Button btRemovePath_ = null;
    private List<Button> modeButtons_ = new ArrayList<Button>(UpdateMode.values().length);
    private File[] validPaths_ = new File[0];
    private UpdateMode mode_ = UPDATE_MODE.defaultValue();

    public UpdateDatabaseDialog(Shell shell) {
        super(shell);
        this.setShellStyle(48);
    }

    protected Point getInitialSize() {
        return new Point(480, 320);
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(NT_UPDATE_DATABASE.get());
        this.frame_ = (Composite)super.createDialogArea(composite);
        Control control = this.createPathPanel(this.frame_);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control = this.createModePanel(this.frame_);
        control.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.setTitle(NT_REGISTER_SGF_TO_DATABASE.get());
        return this.frame_;
    }

    private Control createPathPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.createPathTable(composite2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(16384, 16384, false, false));
        composite3.setLayout((Layout)new GridLayout(1, true));
        Button button = new Button(composite3, 8);
        button.setText(CLB_ADD_PATH.get());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UpdateDatabaseDialog.this.addPath();
            }
        });
        this.btRemovePath_ = new Button(composite3, 8);
        this.btRemovePath_.setText(CLB_REMOVE_PATH.get());
        this.btRemovePath_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UpdateDatabaseDialog.this.removePath();
            }
        });
        return composite2;
    }

    private void createPathTable(Composite composite) {
        this.tblPath_ = new Table(composite, 2080);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 200;
        this.tblPath_.setLayoutData((Object)gridData);
        this.tblPath_.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UpdateDatabaseDialog.this.updateWidgetStatus();
            }
        });
        this.tblPath_.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.tblPath_, 16384);
        tableColumn.setText(LB_COLUMN_PATH.get());
        CurrentContext currentContext = Yukinoshita.context(null);
        for (File file : currentContext.getAttribute(TARGET_PATHS)) {
            TableItem tableItem = new TableItem(this.tblPath_, 0);
            tableItem.setText(file.getAbsolutePath());
            boolean bl = Ios.isNormalDirectory(file);
            tableItem.setGrayed(!bl);
            tableItem.setChecked(bl);
        }
        this.tblPath_.getColumn(0).pack();
    }

    private Control createModePanel(Composite composite) {
        Group group = SwtFactory.createGroup(composite, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setText(LB_UPDATE_MODE.get());
        CurrentContext currentContext = Yukinoshita.context(null);
        UpdateMode updateMode = currentContext.getAttribute(UPDATE_MODE);
        for (UpdateMode updateMode2 : UpdateMode.values()) {
            Button button = SwtFactory.createRadioButton((Composite)group, 0);
            String string = Messages.createKey(UpdateDatabaseDialog.class, updateMode2.name());
            button.setText(messages_s_.get(string));
            button.setData((Object)updateMode2);
            button.setSelection(updateMode == updateMode2);
            button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.modeButtons_.add(button);
        }
        return group;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1024, CLB_START.get(), false);
        this.createButton(composite, 1, BasicMessages.LB_CANCEL.get(), false);
        this.updateWidgetStatus();
    }

    protected void buttonPressed(int n) {
        this.updateValidPaths();
        this.updateContextValues();
        switch (n) {
            case 1024: {
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
                break;
            }
            default: {
                assert (false) : "Unknown ID; " + n;
                break;
            }
        }
    }

    private void updateValidPaths() {
        ArrayList<File> arrayList = new ArrayList<File>(this.tblPath_.getItemCount());
        for (TableItem tableItem : this.tblPath_.getItems()) {
            if (!tableItem.getChecked() || tableItem.getGrayed()) continue;
            arrayList.add(new File(tableItem.getText()));
        }
        this.validPaths_ = arrayList.toArray(new File[arrayList.size()]);
    }

    private void updateContextValues() {
        CurrentContext currentContext = Yukinoshita.context(null);
        File[] fileArray = new File[this.tblPath_.getItemCount()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(this.tblPath_.getItem(i).getText());
        }
        currentContext.setAttribute(TARGET_PATHS.id(), fileArray);
        for (Button button : this.modeButtons_) {
            if (!button.getSelection()) continue;
            this.mode_ = (UpdateMode)((Object)button.getData());
            currentContext.setAttribute(UPDATE_MODE.id(), (Object)this.mode_);
            break;
        }
    }

    private void updateWidgetStatus() {
        boolean bl = false;
        Button button = this.getButton(1024);
        for (TableItem tableItem : this.tblPath_.getItems()) {
            if (!tableItem.getChecked()) continue;
            bl = true;
            break;
        }
        button.setEnabled(bl);
        this.btRemovePath_.setEnabled(this.tblPath_.getSelectionCount() != 0);
        if (!button.getEnabled()) {
            this.setMessage(MSG_ERR_NO_FOLDER.get(), 3);
        } else {
            this.setMessage(MSG_INFO_UPDATE_BY_START_BUTTON.get(), 1);
        }
    }

    private void addPath() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.frame_.getShell());
        directoryDialog.setText(NT_SET_ROOT_FOLDER.get());
        directoryDialog.setMessage(MSG_SET_ROOT_FOLDER.get());
        CurrentContext currentContext = Yukinoshita.context(null);
        directoryDialog.setFilterPath(currentContext.getAttribute(LAST_PATH).getAbsolutePath());
        String string = directoryDialog.open();
        if (string == null) {
            return;
        }
        for (TableItem tableItem : this.tblPath_.getItems()) {
            if (!string.equals(tableItem.getText())) continue;
            tableItem.setChecked(true);
            this.updateWidgetStatus();
            return;
        }
        TableItem tableItem = new TableItem(this.tblPath_, 0);
        tableItem.setText(string);
        tableItem.setChecked(true);
        this.updateWidgetStatus();
        this.tblPath_.getColumn(0).pack();
        currentContext.setAttribute(LAST_PATH, new File(string));
    }

    private void removePath() {
        this.tblPath_.remove(this.tblPath_.getSelectionIndices());
        this.updateWidgetStatus();
    }

    public File[] getPaths() {
        File[] fileArray = new File[this.validPaths_.length];
        System.arraycopy(this.validPaths_, 0, fileArray, 0, fileArray.length);
        return fileArray;
    }

    public UpdateMode getUpdateMode() {
        return this.mode_;
    }
}

