/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg.fe;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.AddMove;
import org.unitarou.yukinoshita.model.cmd.RemoveLastNode;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class FeGameMoveEventDelegator
implements EventDelegator {
    private SgfColor currentColor_ = SgfColor.BLACK;

    public void resetStatus() {
        this.currentColor_ = SgfColor.BLACK;
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, EventBroker eventBroker, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)eventBroker);
        BlockSituation blockSituation = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            return blockSituation;
        }
        if (blockStatus.getPointTypes().contains((Object)SgfPointType.EMPTY)) {
            if (SgfColor.BLACK.equals(this.currentColor_)) {
                blockSituation.setCursor(CanvasCursor.MOVE_BLACK.getCursor());
                blockSituation.setTransientProperty(SgfId.BLACK.makeProperty(blockStatus.getPoint()));
            } else {
                blockSituation.setCursor(CanvasCursor.MOVE_WHITE.getCursor());
                blockSituation.setTransientProperty(SgfId.WHITE.makeProperty(blockStatus.getPoint()));
            }
        }
        return blockSituation;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (blockStatus.getPoint() == null) {
            return false;
        }
        if (mouseEvent.button == 3 && nodeView.getMove().getColor() != null) {
            RemoveLastNode removeLastNode = new RemoveLastNode();
            eventBroker.executeCommand(removeLastNode);
            this.currentColor_ = nodeView.getOppositeColor();
            if (this.currentColor_ == null) {
                this.currentColor_ = SgfColor.BLACK;
            }
            return true;
        }
        if (mouseEvent.button != 1 || !blockStatus.getPointTypes().contains((Object)SgfPointType.EMPTY)) {
            return false;
        }
        SgfColor sgfColor = this.currentColor_;
        this.currentColor_ = this.currentColor_.opposite();
        AddMove addMove = new AddMove(sgfColor, blockStatus.getPoint());
        eventBroker.executeCommand(addMove);
        return true;
    }
}

