/*
 * Copyright (C) 2013  WhiteCat è (www.thinkandroid.cn)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ta.util.db;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

import com.ta.util.TALogger;
import com.ta.util.db.TASQLiteDatabase.TADBParams;
import com.ta.util.db.TASQLiteDatabase.TADBUpdateListener;

import android.content.Context;

/**
 * @Title TASQLiteDatabasePool
 * @Package com.ta.util.db
 * @Description ݿ
 * @author è
 * @date 2013-1-31
 * @version V1.0
 */
public class TASQLiteDatabasePool
{
	private String testTable = "Sqlite_master"; // ǷõĲԱĬSqlite_masterΪԱ
	private int initialSQLiteDatabase = 2; // ӳصĳʼС
	private int incrementalSQLiteDatabase = 2;// ӳԶӵĴС
	private int maxSQLiteDatabase = 10; // ӳĴС
	private Vector<PooledSQLiteDatabase> pSQLiteDatabases = null; // ӳݿӵ
	private Context context;
	private TADBParams params;
	private TADBUpdateListener mDBUpdateListener; // ʱ
	private Boolean isWrite = false;
	private static HashMap<String, TASQLiteDatabasePool> poolMap = new HashMap<String, TASQLiteDatabasePool>();

	/**
	 * ģʽ
	 * 
	 * @param context
	 *            
	 * @param context
	 *            
	 * @param params
	 *            ݿò
	 * @param isWrite
	 *            ݿ isWriteΪtrue,ʱ׳
	 */
	public synchronized static TASQLiteDatabasePool getInstance(
			Context context, TADBParams params, Boolean isWrite)
	{
		String dbName = params.getDbName().trim();
		TASQLiteDatabasePool pool = poolMap.get(dbName);
		if (pool == null)
		{
			pool = new TASQLiteDatabasePool(context, params, isWrite);
			poolMap.put(dbName.trim(), pool);
		}
		return pool;
	}

	/**
	 * ģʽ
	 * 
	 * @param context
	 *            
	 */
	public static TASQLiteDatabasePool getInstance(Context context)
	{
		TADBParams params = new TADBParams();
		return getInstance(context, params, false);
	}

	/**
	 * ģʽ
	 * 
	 * @param context
	 *            
	 * @param dbName
	 *            ݿ
	 * @param dbVersion
	 *            汾
	 * @param isWrite
	 *            ݿ isWriteΪtrue,ʱ׳
	 */
	public static TASQLiteDatabasePool getInstance(Context context,
			String dbName, int dbVersion, Boolean isWrite)
	{
		TADBParams params = new TADBParams(dbName, dbVersion);
		return getInstance(context, params, isWrite);
	}

	/**
	 * 캯
	 * 
	 * @param context
	 *            
	 * @param params
	 *            ݿò
	 * @param isWrite
	 *            ݿ isWriteΪtrue,ʱ׳
	 */
	public TASQLiteDatabasePool(Context context, TADBParams params,
			Boolean isWrite)
	{
		// TODO Auto-generated constructor stub
		this.context = context;
		this.params = params;
		this.isWrite = isWrite;
	}

	/**
	 * ĵļ
	 * 
	 * @param dbUpdateListener
	 */
	public void setOnDbUpdateListener(TADBUpdateListener dbUpdateListener)
	{
		this.mDBUpdateListener = dbUpdateListener;
	}

	/**
	 * 
	 * ӳصĳʼС
	 * 
	 * @return ʼӳпɻõ
	 */
	public int getInitialSQLiteDatabase()
	{
		return initialSQLiteDatabase;
	}

	/**
	 * ӳصĳʼС
	 * 
	 * @param óʼӳӵ
	 */
	public void setInitialSQLiteDatabase(int initialSQLiteDatabase)
	{
		this.initialSQLiteDatabase = initialSQLiteDatabase;
	}

	/**
	 * ӳԶӵĴС 
	 * 
	 * @return ӳԶӵĴС
	 */
	public int getIncrementalSQLiteDatabase()
	{
		return incrementalSQLiteDatabase;
	}

	/**
	 * ӳԶӵĴС
	 * 
	 * @param ӳԶӵĴС
	 */
	public void setIncrementalSQLiteDatabase(int incrementalSQLiteDatabase)
	{
		this.incrementalSQLiteDatabase = incrementalSQLiteDatabase;
	}

	/**
	 * 
	 * ӳĿ
	 * 
	 * @return ӳĿ
	 */
	public int getMaxSQLiteDatabase()
	{
		return maxSQLiteDatabase;
	}

	/**
	 * ӳõ
	 * 
	 * @param ӳõֵ
	 */
	public void setMaxSQLiteDatabase(int maxSQLiteDatabase)
	{
		this.maxSQLiteDatabase = maxSQLiteDatabase;
	}

	/**
	 * òԱ
	 * 
	 * @param testTable
	 *            String Ա
	 */

	public void setTestTable(String testTable)
	{
		this.testTable = testTable;
	}

	/**
	 * ȡݿ
	 * 
	 * @return ݿ
	 */

	public String getTestTable()
	{
		return this.testTable;
	}

	/**
	 * 
	 * һݿӳأӳеĿӵԱ initialSQLiteDatabase õֵ
	 */
	public synchronized void createPool()
	{
		// ȷӳûд
		// ӳؼˣӵ sqLiteDatabases Ϊ
		if (pSQLiteDatabases != null)
		{
			return; // 򷵻
		}
		// ӵ , ʼʱ 0 Ԫ
		pSQLiteDatabases = new Vector<PooledSQLiteDatabase>();
		//  initialConnections õֵӡ
		createSQLiteDatabase(this.initialSQLiteDatabase);
		TALogger.i(TASQLiteDatabasePool.this, " ݿӳشɹ ");
	}

	/**
	 *  numSQLiteDatabase ָĿݿ , Щ  numSQLiteDatabase 
	 * 
	 * @param numSQLiteDatabase
	 *            ҪݿӵĿ
	 */

	private void createSQLiteDatabase(int numSQLiteDatabase)
	{

		// ѭָĿݿ
		for (int x = 0; x < numSQLiteDatabase; x++)
		{
			// ǷӳеݿӵﵽֵԱ maxSQLiteDatabase
			// ָ maxSQLiteDatabase Ϊ 0 ʾûơ
			// ﵽ󣬼˳
			if (this.maxSQLiteDatabase > 0
					&& this.pSQLiteDatabases.size() >= this.maxSQLiteDatabase)
			{
				break;
			}
			try
			{
				// һTASQLiteDatabaseӳ
				pSQLiteDatabases.addElement(new PooledSQLiteDatabase(
						newSQLiteDatabase()));
			} catch (Exception e)
			{
				TALogger.i(TASQLiteDatabasePool.this,
						" ݿʧܣ " + e.getMessage());
			}
			TALogger.i(TASQLiteDatabasePool.this, "ݿӼ ......");
		}
	}

	/**
	 * һµݿӲ
	 * 
	 * @return һ´ݿ
	 */

	private TASQLiteDatabase newSQLiteDatabase()
	{

		// һݿ
		TASQLiteDatabase sqliteDatabase = new TASQLiteDatabase(context, params);
		sqliteDatabase.openDatabase(mDBUpdateListener, isWrite);
		return sqliteDatabase; // شµݿ
	}

	/**
	 * ͨ getFreeSQLiteDatabase() һõݿ ,
	 * ǰûпõݿӣҸݿӲܴ ӳشСƣ˺ȴһٳԻȡ
	 * 
	 * @return һõݿӶ
	 */

	public synchronized TASQLiteDatabase getSQLiteDatabase()
	{
		// ȷӳؼ
		if (pSQLiteDatabases == null)
		{
			return null; // ӳػû򷵻 null
		}

		TASQLiteDatabase sqliteDatabase = getFreeSQLiteDatabase(); // һõݿ

		// ĿǰûпʹõӣеӶʹ
		while (sqliteDatabase == null)
		{
			// һ
			wait(250);
			sqliteDatabase = getFreeSQLiteDatabase(); // ԣֱÿõӣ
			// getFreeConnection() صΪ null
			// һӺҲɻÿ
		}
		return sqliteDatabase;// ػõĿõ
	}

	/**
	 * ӳ pSQLiteDatabases зһõĵݿӣ ǰûпõݿӣ
	 * incrementalSQLiteDatabase  ֵݿӣӳС еԶʹУ򷵻
	 * null
	 * 
	 * @return һõݿ
	 */

	private TASQLiteDatabase getFreeSQLiteDatabase()
	{
		// ӳлһõݿ
		TASQLiteDatabase sqLiteDatabase = findFreeSQLiteDatabase();
		if (sqLiteDatabase == null)
		{
			// Ŀǰӳûпõ
			// һЩ
			createSQLiteDatabase(incrementalSQLiteDatabase);
			// ´ӳвǷп
			sqLiteDatabase = findFreeSQLiteDatabase();
			if (sqLiteDatabase == null)
			{
				// ӺԻòõӣ򷵻 null
				return null;
			}
		}
		return sqLiteDatabase;
	}

	/**
	 * ӳеӣһõݿӣ ûпõӣ null
	 * 
	 * @return һõݿ
	 */

	private TASQLiteDatabase findFreeSQLiteDatabase()
	{
		TASQLiteDatabase sqliteDatabase = null;
		PooledSQLiteDatabase pSQLiteDatabase = null;

		// ӳеĶ
		Enumeration<PooledSQLiteDatabase> enumerate = pSQLiteDatabases
				.elements();

		// еĶ󣬿Ƿпõ
		while (enumerate.hasMoreElements())
		{
			pSQLiteDatabase = (PooledSQLiteDatabase) enumerate.nextElement();
			if (!pSQLiteDatabase.isBusy())
			{

				// ˶æݿӲΪæ
				sqliteDatabase = pSQLiteDatabase.getSqliteDatabase();
				pSQLiteDatabase.setBusy(true);
				// ԴǷ
				if (!testSQLiteDatabase(sqliteDatabase))
				{
					// Ӳˣ򴴽һµӣ // 滻˲õӶʧܣ null
					sqliteDatabase = newSQLiteDatabase();
					pSQLiteDatabase.setSqliteDatabase(sqliteDatabase);
				}
				break;
				// ҵһõӣ˳
			}
		}
		return sqliteDatabase;// ҵĿ
	}

	/**
	 * һǷããص false ÷ true
	 * 
	 * @param sqliteDatabase
	 *            ҪԵݿ
	 * @return  true ʾӿã false ʾ
	 */
	private boolean testSQLiteDatabase(TASQLiteDatabase sqliteDatabase)
	{

		if (sqliteDatabase != null)
		{
			return sqliteDatabase.testSQLiteDatabase();
		}
		// ӿã true
		return false;
	}

	/**
	 * ˺һݿӵӳУѴΪС ʹӳػõݿӾӦڲʹôʱ
	 * 
	 * @param 践صӳеӶ
	 */

	public void releaseSQLiteDatabase(TASQLiteDatabase sqLiteDatabase)
	{
		// ȷӳشڣûдڣֱӷ
		if (pSQLiteDatabases == null)
		{
			TALogger.d(TASQLiteDatabasePool.this, " ӳزڣ޷شӵӳ !");
			return;
		}
		PooledSQLiteDatabase pSqLiteDatabase = null;

		Enumeration<PooledSQLiteDatabase> enumerate = pSQLiteDatabases
				.elements();

		// ӳеӣҵҪصӶ
		while (enumerate.hasMoreElements())
		{
			pSqLiteDatabase = (PooledSQLiteDatabase) enumerate.nextElement();

			// ҵӳеҪصӶ
			if (sqLiteDatabase == pSqLiteDatabase.getSqliteDatabase())
			{

				// ҵ , ôΪ״̬
				pSqLiteDatabase.setBusy(false);
				break;
			}
		}
	}

	/**
	 * ˢӳеӶ
	 * 
	 */

	public synchronized void refreshSQLiteDatabase()
	{

		// ȷӳؼ´
		if (pSQLiteDatabases == null)
		{
			TALogger.d(TASQLiteDatabasePool.this, " ӳزڣ޷ˢ !");
			return;
		}

		PooledSQLiteDatabase pSqLiteDatabase = null;
		Enumeration<PooledSQLiteDatabase> enumerate = pSQLiteDatabases
				.elements();
		while (enumerate.hasMoreElements())
		{

			// һӶ
			pSqLiteDatabase = (PooledSQLiteDatabase) enumerate.nextElement();

			// æ 5  ,5 ֱˢ
			if (pSqLiteDatabase.isBusy())
			{
				wait(5000); //  5 
			}

			// رմӣһµӴ
			closeSQLiteDatabase(pSqLiteDatabase.getSqliteDatabase());
			pSqLiteDatabase.setSqliteDatabase(newSQLiteDatabase());
			pSqLiteDatabase.setBusy(false);
		}
	}

	/**
	 * رӳеӣӳء
	 */

	public synchronized void closeSQLiteDatabase()
	{

		// ȷӳشڣڣ
		if (pSQLiteDatabases == null)
		{
			TALogger.d(TASQLiteDatabasePool.this, "ӳزڣ޷ر !");
			return;
		}
		PooledSQLiteDatabase pSqLiteDatabase = null;
		Enumeration<PooledSQLiteDatabase> enumerate = pSQLiteDatabases
				.elements();
		while (enumerate.hasMoreElements())
		{
			// һӶ
			pSqLiteDatabase = (PooledSQLiteDatabase) enumerate.nextElement();

			// æ 5 
			if (pSqLiteDatabase.isBusy())
			{
				wait(5000); //  5 
			}
			// 5 ֱӹر
			closeSQLiteDatabase(pSqLiteDatabase.getSqliteDatabase());
			// ӳɾ
			pSQLiteDatabases.removeElement(pSqLiteDatabase);
		}
		// ӳΪ
		pSQLiteDatabases = null;
	}

	/**
	 * رһݿ
	 * 
	 * @param Ҫرյݿ
	 */

	private void closeSQLiteDatabase(TASQLiteDatabase sqlLiteDatabase)
	{
		sqlLiteDatabase.close();
	}

	/**
	 * ʹȴĺ
	 * 
	 * @param ĺ
	 */

	private void wait(int mSeconds)
	{
		try
		{
			Thread.sleep(mSeconds);
		} catch (InterruptedException e)
		{
		}
	}

	/**
	 * ڲʹõڱӳӶ ԱһݿӣһָʾǷ ʹõı־
	 */

	class PooledSQLiteDatabase
	{
		TASQLiteDatabase sqliteDatabase = null;// ݿ
		boolean busy = false; // Ƿʹõı־Ĭûʹ

		// 캯һ TASQLiteDatabase һ PooledSQLiteDatabase 
		public PooledSQLiteDatabase(TASQLiteDatabase sqliteDatabase)
		{
			this.sqliteDatabase = sqliteDatabase;
		}

		// ش˶е
		public TASQLiteDatabase getSqliteDatabase()
		{
			return sqliteDatabase;
		}

		// ô˶ģ
		public void setSqliteDatabase(TASQLiteDatabase sqliteDatabase)
		{
			this.sqliteDatabase = sqliteDatabase;
		}

		// öǷæ
		public boolean isBusy()
		{
			return busy;
		}

		// öæ
		public void setBusy(boolean busy)
		{
			this.busy = busy;
		}
	}
}
