// IMKit-UIM: A Qtopia InputMethod interface for UIM
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5_PRE3 $
// $Id: ui_uim.cpp,v 1.5 2002/11/01 15:53:37 yamaken Exp $

#include "ui_uim.h"


CascadeKeyFilter *
UIMGUI::create_keyfilter(void) {
  forwarder = new RawMapper<>((*command_map())["receive_keyevent"]);
  injector = new CharInjector;

  //Ϣ
  *forwarder
    << *injector
    ;
  
  return forwarder;
}

void
UIMGUI::update_preedit_state(PreeditState new_state) {
}

UIMGUI::UIMGUI(UIMEngine *engine_init,
               StdIMWidgetFactory *imwidget_factory_init)
  : StdIMUserInterface(engine_init, imwidget_factory_init),
    im_selector(NULL), forwarder(NULL)
{
}

void
UIMGUI::set_activity(bool activity) {
  //TODO: activate()engine̵äassemble
  forwarder->activate(activity);
}

void
UIMGUI::connect_uim_signals(void) {
  connect(im_selector, SIGNAL(selected(InputMap)),
          ((UIMEngine *)_engine), SLOT(select_im(InputMap)));
  connect(((UIMEngine *)_engine), SIGNAL(im_added(InputMap, const QString &)),
          im_selector, SLOT(add_state(InputMap, const QString &)));
  connect(((UIMEngine *)_engine), SIGNAL(im_selector_cleared(void)),
          im_selector, SLOT(clear(void)));
}

bool
UIMGUI::is_active(void) const {
  return forwarder->is_active();
}

QWidget *
UIMGUI::imwidget(QWidget *parent, Qt::WFlags flags) {
  QWidget *widget;

  widget = StdIMUserInterface::imwidget(parent, flags);
#ifndef IMKIT_PASSIVE_INPUTMAP_CONFIGURATION
  ((UIMEngine *)_engine)->update_inputmap();
#endif
  im_selector = imwidget_factory->create_inputmap_indicator(_imwidget, flags);
  connect_uim_signals();
  ((UIMEngine *)_engine)->update_im_selector();
  ((UIMEngine *)_engine)->select_im(IMKIT_INPUT_MAP_RUNTIME_VAL_BASE);
  
  return widget;
}
