// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5 $
// $Id: imkit_anthy_qpe.cpp,v 1.5 2002/10/05 06:07:24 yamaken Exp $

#include <qwidget.h>
#include <qhbox.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qpe/inputmethodinterface.h>
#include "keyfilter.h"
#include "engine_anthy.h"
#include "ui_anthy.h"
#include "imkit_qlineedit.h"
#include "imwidget.h"
#include "imwidget_std.h"
#include "platform_qpe.h"


static IMUserInterface *create_custom_anthy_ui(void);
static QPixmap *create_icon(void);
static InputMethodInterface *create_instance(void);

static const char *anthy_icon_xpm[];


//TODO: Anthy򤵤Ƥǧ䤹Τѹ
static const char *anthy_icon_xpm[] = {
"28 14 2 1",
"# c #000000",
". c None",
".........##..##.##..........",
"..........##.##.##..........",
"..........###########.......",
".......##....##.##..........",
"........##..########........",
"........##..##.##.##........",
"............########........",
".........##....##...........",
".........##.########........",
".........##....##...........",
"........##.##########.......",
"........##....##.#..........",
".......##....##..##.........",
".......##..###....###......."
};


static IMUserInterface *
create_custom_anthy_ui(void) {
  AnthyEngine *engine;
  IMUserInterface *anthy_ui;
  StdIMWidgetFactory *imwidget_factory;

  engine = new AnthyEngine;
  imwidget_factory = new StdIMWidgetFactory;
  anthy_ui = new AnthyGUI(engine, imwidget_factory);

  return anthy_ui;
}

static QPixmap *
create_icon(void) {
  QPixmap *icon;

  icon = new QPixmap((const char **)anthy_icon_xpm);

  return icon;
}

static InputMethodInterface *
create_instance(void) {
  IMUserInterface *ui;
  InputMethodInterface *instance;

  ui = create_custom_anthy_ui();
  //Q_CREATE_INSTANCE(IMKitImpl(ui, icon))
  instance = new IMKitImpl(ui, create_icon());

  return instance;
}

IMKIT_EXPORT_INTERFACE(create_instance);
