// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_5 $
// $Id: imwidget.h,v 1.5 2002/11/26 17:47:38 yamaken Exp $

#ifndef IMKIT_IMWIDGET_H
#define IMKIT_IMWIDGET_H

#include <vector>
#include <qobject.h>
#include <qwidget.h>
#include <qnamespace.h>
#include "util.h"
#include "engine.h"


QSize imkit_screen_size(void);
void imkit_set_font(QWidget *widget);


class ActivatableQWidgetAdapter : public virtual Activatable {
protected:
  virtual void set_activity(bool activity);

public:
  ActivatableQWidgetAdapter(void);
  virtual ~ActivatableQWidgetAdapter(void);
  virtual QWidget *widget(void) = 0;
  virtual bool is_active(void) const;
};


#ifdef IMKIT_USE_TEMPLATE_QOBJECT

// Error: Sorry, Qt does not support templates that contain
// signals, slots or Q_OBJECT. This will be supported soon.

// mocץץå򤵤顼ˤʤΤǥȥ
//template <class Widget>
//class QWidgetWithActivationSignal : public Widget {
//  Q_OBJECT
//
//protected:
//  virtual void showEvent(QShowEvent *e);
//  virtual void hideEvent(QHideEvent *e);
//
//public:
//  QWidgetWithActivationSignal(QWidget *parent = 0,
//                              const char *name = 0,
//                              Qt::WFlags fl = 0)
//    : Widget(parent, name, fl) {}
//  ~QWidgetWithActivationSignal(void);
//
//signals:
//  void activated(bool activity);
//};
//
//template <class Widget>
//void
//QWidgetWithActivationSignal<Widget>::showEvent(QShowEvent *e) {
//  if (!e->spontaneous()) {
//    emit activated(true);
//  }
//}
//
//template <class Widget>
//void
//QWidgetWithActivationSignal<Widget>::hideEvent(QHideEvent *e) {
//  if (!e->spontaneous()) {
//    emit activated(false);
//  }
//}

#else //IMKIT_USE_TEMPLATE_QOBJECT

#define IMKIT_DECLARE_ACTIVATED_SIGNALS_FOR_QWIDGET \
  protected: \
    virtual void showEvent(QShowEvent *e); \
    virtual void hideEvent(QHideEvent *e); \
  signals: \
    void activated(bool activity);

#endif  //IMKIT_USE_TEMPLATE_QOBJECT

#define IMKIT_DEFINE_ACTIVATED_SIGNALS_FOR_QWIDGET(_class) \
  void _class::showEvent(QShowEvent *e) { \
    if (!e->spontaneous()) { \
      emit activated(true); \
    } \
  } \
  \
  void _class::hideEvent(QHideEvent *e) { \
    if (!e->spontaneous()) { \
      emit activated(false); \
    } \
  }


class PreeditWidget {
public:
  virtual QWidget *widget(void) = 0;
  virtual void setCursorPosition(int new_position) = 0;
  virtual void setSelection(int focus_begin, int focus_length) = 0;
};


class Preedit : public QObject {
  Q_OBJECT

protected:
  Preedit(void);

public:
  virtual ~Preedit(void);
  virtual QWidget *widget(void) = 0;
  virtual void set_widget(PreeditWidget *new_adaptee) = 0;

public slots:
  virtual void update_state(PreeditState new_state) = 0;
  virtual void update(Segments &segments) = 0;
};


class InputMapIndicatorWidget {
public:
  virtual QWidget *widget(void) = 0;
  virtual void setCurrentItem(int index) = 0;
  virtual void insertItem(const QString &label, int index) = 0;
  virtual void clear(void) = 0;
};


class InputMapIndicator : public QObject {
  Q_OBJECT

protected:
  InputMapIndicator(void);

public:
  virtual ~InputMapIndicator(void);
  virtual QWidget *widget(void) = 0;
  virtual void set_widget(InputMapIndicatorWidget *new_adaptee) = 0;
  virtual InputMap state(void) const = 0;

signals:
  void selected(InputMap new_map);

public slots:
  virtual void add_state(InputMap map_code, const QString &label) = 0;
  virtual void select(InputMap new_map) = 0;
  virtual void clear(void) = 0;
};


class CandidateWindowWidget;

class CandidateWindow : public QObject, virtual public Activatable {
  Q_OBJECT

protected:
  CandidateWindow(void);

public:
  virtual ~CandidateWindow(void);
  virtual QWidget *widget(void) = 0;
  virtual void set_widget(CandidateWindowWidget *new_adaptee) = 0;

signals:
  void selected(Candidates::size_type which);

public slots:
  virtual void update(Candidates &new_candidates) = 0;
  virtual void hilight(int new_index, bool reversely) = 0;
};


class InputMaskFilter : public QObject {
public:
  virtual bool eventFilter(QObject *event_receiver, QEvent *e);
};

#endif  // IMKIT_IMWIDGET_H
