=begin
/****************************************************************************
** $Id: qt/examples/buttongroups/buttongroups.cpp   2.2.2   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include "buttongroups.h"

#include <qbuttongroup.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
=begin
/*
 * Constructor
 *
 * Creates all child widgets of the ButtonGroups window
 */
=end
require "qt2"
include Qt2

class ButtonGroups < QWidget
def initialize ( parent=nil , name="" )
    super ( parent, name )

    #// Create Widgets which allow easy layouting
    vbox = QVBoxLayout.new( self )
    box1 = QHBoxLayout.new( vbox )
    box2 = QHBoxLayout.new( vbox )

    #// ------- first group

    #// Create an exclusive button group
    grp1 = QButtonGroup.new( 1, QGroupBox::Horizontal, "Button Group 1 (exclusive)", self)
    box1.addWidget( grp1 )
    grp1.setExclusive( TRUE )

    #// insert 3 radiobuttons
    rb11 = QRadioButton.new( "&Radiobutton 1", grp1 )
    rb11.setChecked( TRUE )
    QRadioButton.new( "R&adiobutton 2", grp1 )
    QRadioButton.new( "Ra&diobutton 3", grp1 )

    #// ------- second group

    #// Create a non-exclusive buttongroup
    grp2 = QButtonGroup.new( 1, QGroupBox::Horizontal, "Button Group 2 (non-exclusive)", self )
    box1.addWidget( grp2 )
    grp2.setExclusive( FALSE )

    #// insert 3 checkboxes
    QCheckBox.new( "&Checkbox 1", grp2 )
    cb12 = QCheckBox.new( "C&heckbox 2", grp2 )
    cb12.setChecked( TRUE )
    cb13 = QCheckBox.new( "Triple &State Button", grp2 )
    cb13.setTristate( TRUE )
    cb13.setChecked( TRUE )

    #// ------------ third group

    #// create a buttongroup which is exclusive for radiobuttons and non-exclusive for all other buttons
    grp3 = QButtonGroup.new( 1, QGroupBox::Horizontal, "Button Group 3 (Radiobutton-exclusive)", self )
    box2.addWidget( grp3 )
    grp3.setRadioButtonExclusive( TRUE )

    #// insert three radiobuttons
    @rb21 = QRadioButton.new( "Rad&iobutton 1", grp3 )
    @rb22 = QRadioButton.new( "Radi&obutton 2", grp3 )
    @rb23 = QRadioButton.new( "Radio&button 3", grp3 )
    @rb23.setChecked( TRUE )

    #// insert a checkbox...
    @state = QCheckBox.new( "E&nable Radiobuttons", grp3 )
    @state.setChecked( TRUE )
    #// ...and connect its SIGNAL clicked() with the SLOT slotChangeGrp3State()
    connect( @state, QSIGNAL( "clicked()" ), self, "slotChangeGrp3State()")

    #// ------------ fourth group

    #// create a groupbox which layouts its childs in a columns
    grp4 = QButtonGroup.new( 1, QGroupBox::Horizontal, "Groupbox with normal buttons", self )
    box2.addWidget( grp4 )

    #// insert two pushbuttons...
    QPushButton.new( "&Push Button", grp4 )
    tb = QPushButton.new( "&Toggle Button", grp4 )

    #// ... and make the second one a toggle button
    tb.setToggleButton( TRUE )
    tb.setOn( TRUE )
end
=begin
/*
 * SLOT slotChangeGrp3State()
 *
 * enables/disables the radiobuttons of the third buttongroup
 */
=end
def slotChangeGrp3State()

    @rb21.setEnabled( @state.isChecked() )
    @rb22.setEnabled( @state.isChecked() )
    @rb23.setEnabled( @state.isChecked() )
end
end

