#!/usr/bin/env ruby
require 'classtree.rb'
require 'qt2'
include Qt2
#GC.disable
class RClassMain < QMainWindow
def initialize
   @w0 = QWidget.new(self)
   @splitter = QSplitter.new(Qt::Vertical,@w0,"split1")
   @popup = QPopupMenu.new
   @popup.insertItem("&Qt2",1)
   @popup.insertItem("&Gtk",2)
   @popup.insertItem("&Fltk",3)
   @popup.insertItem("&Tk",4)
   @popup.insertItem("&All",5)
   @popup.insertItem( "&Quit", QApplication::qApp, "quit()", CTRL+Key_Q )
   menuBar.insertItem("&File",@popup)
   @classWindow = RClassView.new(@splitter)
   Qt2::connect(menuBar,QSIGNAL("activated(int)"), self, "menuActivated")
   @edit = QMultiLineEdit.new(@splitter)
   setCentralWidget(@w0)
   Qt2::connect(@classWindow.signal_mlist,self,"methodSelected")
   Qt2::connect(@classWindow.signal_vlist,self,"constSelected")

   catchEvent
   setCaption("Ruby Class Browser")
   statusBar.message( "Ready", 5000 )
end
def menuActivated i
   case i
   when 1
      @classWindow.initialize_classview_qt
   when 2
      @classWindow.initialize_classview_gtk
   when 3
      @classWindow.initialize_classview_fltk
   when 4
      @classWindow.initialize_classview_tk
   when 5
      @classWindow.initialize_classview_Object
   end
end
def methodSelected str
   if str[0].chr == "-"
      @edit.clear
      @edit.setText("No method selected")
      return
   end
   str1 = "Selected Method is "
   str1 += str + " "
   str1 += " in " + "#{@classWindow.currentClass}"
   @edit.clear
   @edit.setText(str1)
end
def constSelected str
   str1 = str + " in " +  "#{@classWindow.currentClass} = "
   temp1 = eval("#{@classWindow.currentClass}::#{str}")
   str1 += "#{temp1}"
   @edit.clear
   @edit.setText(str1)
end
def resizeEvent ev
      @splitter.resize(width,height)
end
end

class RClassView < QWidget
def initialize w
   @split = QSplitter.new(Qt::Horizontal,self,"split2")
   @classview = QListView.new(@split,"classview")
   @classview.addColumn("Ruby Class")
   @classview.setColumnWidthMode(0,QListView::Maximum)
   @classview.setRootIsDecorated( true )

   @w1 = QWidget.new(@split)
   @hblayout = QHBoxLayout.new(@w1)
   @vblayout1 = QVBoxLayout.new(@hblayout)

   @mlisthead = QLabel.new("Methods",@w1,"mlisthead")
   @mlisthead.setFrameStyle(QFrame::Panel | QFrame::Raised)
   @vblayout1.addWidget(@mlisthead)
   @methodlist = QListBox.new(@w1,"methodlist")
   @vblayout1.addWidget(@methodlist)
   @signal_mlist = RSignal.new("const QString &")
   Qt2::connect(@methodlist,QSIGNAL("selected(const QString&)"),
             @signal_mlist)

   @vblayout2 = QVBoxLayout.new(@hblayout)
   @varlisthead = QLabel.new("Constants",@w1,"varlisthead")
   @varlisthead.setFrameStyle(QFrame::Panel | QFrame::Raised)
   @vblayout2.addWidget(@varlisthead)
   @varlist = QListBox.new(@w1,"varlist")
   @vblayout2.addWidget(@varlist)
   @signal_vlist = RSignal.new("const QString &")
   Qt2::connect(@varlist,QSIGNAL("selected(const QString&)"),
            @signal_vlist)


   newheight = @classview.header.height - 10
   @mlisthead.setFixedHeight(newheight)
   @varlisthead.setFixedHeight(newheight)


   @hblayout.activate

   initialize_classview_qt
   Qt2::connect(@classview,QSIGNAL("selectionChanged()"),self,"cb_select")

   catchEvent


end
def resizeEvent ev
   @split.resize(width,height)
end

def signal_mlist
   @signal_mlist
end
def signal_vlist
   @signal_vlist
end
def currentClass
   @classview.currentItem.text(0).to_str
end
def currentMethod
   @methodlist.text(@methodlist.currentItem)
end
def currentConst
   @varlist.text(@varlist.currentItem)
end
def resizeEvent ev
   @split.resize(width,height)
end

def initialize_classview_qt
   @classview.clear
   @classtree = ClassTree.new(["Qt2"])
   @classtree.createTree(@classview)

end

def initialize_classview_gtk
   require "gtk"
   @classview.clear
   @classtree = ClassTree.new(["Gdk","Gtk"])
   @classtree.createTree(@classview)
end
def initialize_classview_fltk
   require "fltk"
   @classview.clear
   @classtree = ClassTree.new(["Fltk"])
   @classtree.createTree(@classview)

end
def initialize_classview_tk
    require "tk"
   @classview.clear
   @classtree = ClassTree.new(["Tk","TkKernel"])
   @classtree.createTree(@classview)

end
def initialize_classview_Object
   @classview.clear
   @classtree = ClassTree.new(["Object"])
   @classtree.createTree(@classview)

end
def cb_select
   cname = @classview.currentItem.text(0).to_str
      @classtree.changeConstants(@varlist,cname)
#      @varlisthead.setText("Constants:" + cname)
      @classtree.changeMethods(@methodlist,cname)
#      @mlisthead.setText("Methods:" + cname)

end
end


a = QApplication.new( [$0] + ARGV)
style = Qt2::QMotifStyle.new
QApplication::setStyle(style)
w = RClassMain.new
a.setMainWidget(w)
w.resize(400,300)
w.show
GC.start
a.exec
