=begin
/****************************************************************************
** $Id: cursor.rb,v 1.1.1.2 2000/11/14 17:04:55 horie Exp $
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end

require "qt2"
include Qt2

#// cb_bits and cm_bits were generated by X bitmap program.

Cb_width  = 32
Cb_height = 32
#// cursor bitmap
Cb_bits = [		
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00,
   0x00, 0x06, 0x30, 0x00, 0x80, 0x01, 0xc0, 0x00, 0x40, 0x00, 0x00, 0x01,
   0x20, 0x00, 0x00, 0x02, 0x10, 0x00, 0x00, 0x04, 0x08, 0x3e, 0x3e, 0x08,
   0x08, 0x03, 0xe0, 0x08, 0xc4, 0x00, 0x00, 0x11, 0x04, 0x1e, 0x78, 0x10,
   0x02, 0x0c, 0x30, 0x20, 0x02, 0x40, 0x00, 0x20, 0x02, 0x40, 0x00, 0x20,
   0x02, 0x40, 0x00, 0x20, 0x02, 0x20, 0x04, 0x20, 0x02, 0x20, 0x04, 0x20,
   0x02, 0x10, 0x08, 0x20, 0x02, 0x08, 0x08, 0x20, 0x02, 0xf0, 0x07, 0x20,
   0x04, 0x00, 0x00, 0x10, 0x04, 0x00, 0x00, 0x10, 0x08, 0x00, 0xc0, 0x08,
   0x08, 0x3c, 0x30, 0x08, 0x10, 0xe6, 0x19, 0x04, 0x20, 0x00, 0x0f, 0x02,
   0x40, 0x00, 0x00, 0x01, 0x80, 0x01, 0xc0, 0x00, 0x00, 0x06, 0x30, 0x00,
   0x00, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00 ]

Cm_width =  32
Cm_height = 32
#// cursor bitmap mask
Cm_bits = [	
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xfe, 0x3f, 0x00,
   0x80, 0x07, 0xf0, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0x60, 0x00, 0x00, 0x03,
   0x30, 0x00, 0x00, 0x06, 0x18, 0x00, 0x00, 0x0c, 0x0c, 0x3e, 0x3e, 0x18,
   0x0e, 0x03, 0xe0, 0x18, 0xc6, 0x00, 0x00, 0x31, 0x07, 0x1e, 0x78, 0x30,
   0x03, 0x0c, 0x30, 0x60, 0x03, 0x40, 0x00, 0x60, 0x03, 0x40, 0x00, 0x60,
   0x03, 0x40, 0x00, 0x60, 0x03, 0x20, 0x04, 0x60, 0x03, 0x20, 0x04, 0x60,
   0x03, 0x10, 0x08, 0x60, 0x03, 0x08, 0x08, 0x60, 0x03, 0xf0, 0x07, 0x60,
   0x06, 0x00, 0x00, 0x30, 0x06, 0x00, 0x00, 0x30, 0x0c, 0x00, 0xc0, 0x18,
   0x0c, 0x3c, 0x30, 0x18, 0x18, 0xe6, 0x19, 0x0c, 0x30, 0x00, 0x0f, 0x06,
   0x60, 0x00, 0x00, 0x03, 0xc0, 0x01, 0xc0, 0x01, 0x80, 0x07, 0xf0, 0x00,
   0x00, 0xfe, 0x3f, 0x00, 0x00, 0xf8, 0x0f, 0x00]


#//
#// The CursorView contains many labels with different cursors.
#//


class Cursor
attr_reader:shape
attr_reader:name
def initialize(shape , name)
   @shape=shape
   @name=name
end
end

class CursorView < QWidget		#// cursor view


#//
#// Constructs a cursor view.
#//

def initialize()			#// construct view
  super
#    static struct
#    shape					
 #   name			#// cursor name
     list = [
	 Cursor.new(ArrowCursor, "arrowCursor") ,
	 Cursor.new(UpArrowCursor,	"upArrowCursor" ),
	 Cursor.new(CrossCursor,		"crossCursor" ),
	 Cursor.new(WaitCursor,		"waitCursor" ),
	 Cursor.new(IbeamCursor,		"ibeamCursor" ),
	 Cursor.new(SizeVerCursor,	"sizeVerCursor" ),
	 Cursor.new(SizeHorCursor,	"sizeHorCursor" ),
	 Cursor.new(SizeBDiagCursor,	"sizeBDiagCursor" ),
	 Cursor.new(SizeFDiagCursor,	"sizeFDiagCursor" ),
	 Cursor.new(SizeAllCursor,	"sizeAllCursor" ),
	 Cursor.new(BlankCursor,		"blankCursor" ),
	 Cursor.new(SplitVCursor,		"splitVCursor" ),
	 Cursor.new(SplitHCursor,		"splitHCursor" ),
	 Cursor.new(PointingHandCursor,"pointingHandCursor" ),
	 Cursor.new(ForbiddenCursor,"forbiddenCursor" )
    ]
print "list size = #{list.size}\n"
    setCaption( "CursorView" )			#// set window caption

    grid = QGridLayout.new( self, 5, 4, 20 )
#    label = QLabel.new

    i=0
    for y in 0..3 #( int y=0 y<4 y++ ) 			// create the small labels
	for x in 0..3 #( int x=0 x<4 x++ )
	     if (i < list.size)
                  if ( list[i].shape <= LastCursor)
		label = QLabel.new( "",self )
		label.setCursor( QCursor.new( list[i].shape ) )
		label.setText( list[i].name )
		label.setAlignment( AlignCenter )
		label.setFrameStyle( QFrame::Box | QFrame::Raised )
		grid.addWidget( label, x, y )
		i += 1
	    end
                 end
	end
    end

    cb = QBitmap.new( Cb_width, Cb_height, Cb_bits, true )
    cm = QBitmap.new( Cm_width, Cm_height, Cm_bits, true )
    custom = QCursor.new( cb, cm )			#// create bitmap cursor

    label = QLabel.new( "",self )			#// create the big label
    label.setCursor( custom )
    label.setText( "Custom bitmap cursor" )
    label.setAlignment( AlignCenter )
    label.setFrameStyle( QFrame::Box | QFrame::Sunken )
    grid.addMultiCellWidget( label, 4, 4, 0, 3 )

end

end

#//
#// Create and display a CursorView.
#//

    a =QApplication.new( [$0]+ARGV )	#// application object
    v = CursorView.new				#// cursor view
    a.setMainWidget( v )
    v.show()
    a.exec()

