require "qt2"
include Qt2

Folder_closed_xpm = [
    "16 16 9 1",
    "g c #808080",
    "b c #c0c000",
    "e c #c0c0c0",
    "# c #000000",
    "c c #ffff00",
    ". c None",
    "a c #585858",
    "f c #a0a0a4",
    "d c #ffffff",
    "..###...........",
    ".#abc##.........",
    ".#daabc#####....",
    ".#ddeaabbccc#...",
    ".#dedeeabbbba...",
    ".#edeeeeaaaab#..",
    ".#deeeeeeefe#ba.",
    ".#eeeeeeefef#ba.",
    ".#eeeeeefeff#ba.",
    ".#eeeeefefff#ba.",
    ".##geefeffff#ba.",
    "...##gefffff#ba.",
    ".....##fffff#ba.",
    ".......##fff#b##",
    ".........##f#b##",
    "...........####."]

Folder_open_xpm = [
    "16 16 11 1",
    "# c #000000",
    "g c #c0c0c0",
    "e c #303030",
    "a c #ffa858",
    "b c #808080",
    "d c #a0a0a4",
    "f c #585858",
    "c c #ffdca8",
    "h c #dcdcdc",
    "i c #ffffff",
    ". c None",
    "....###.........",
    "....#ab##.......",
    "....#acab####...",
    "###.#acccccca#..",
    "#ddefaaaccccca#.",
    "#bdddbaaaacccab#",
    ".eddddbbaaaacab#",
    ".#bddggdbbaaaab#",
    "..edgdggggbbaab#",
    "..#bgggghghdaab#",
    "...ebhggghicfab#",
    "....#edhhiiidab#",
    "......#egiiicfb#",
    "........#egiibb#",
    "..........#egib#",
    "............#ee#"]

Folder_locked = [
    "16 16 10 1",
    "h c #808080",
    "b c #ffa858",
    "f c #c0c0c0",
    "e c #c05800",
    "# c #000000",
    "c c #ffdca8",
    ". c None",
    "a c #585858",
    "g c #a0a0a4",
    "d c #ffffff",
    "..#a#...........",
    ".#abc####.......",
    ".#daa#eee#......",
    ".#ddf#e##b#.....",
    ".#dfd#e#bcb##...",
    ".#fdccc#daaab#..",
    ".#dfbbbccgfg#ba.",
    ".#ffb#ebbfgg#ba.",
    ".#ffbbe#bggg#ba.",
    ".#fffbbebggg#ba.",
    ".##hf#ebbggg#ba.",
    "...###e#gggg#ba.",
    ".....#e#gggg#ba.",
    "......###ggg#b##",
    ".........##g#b##",
    "...........####."]

Pix_file = [
    "16 16 7 1",
    "# c #000000",
    "b c #ffffff",
    "e c #000000",
    "d c #404000",
    "c c #c0c000",
    "a c #ffffc0",
    ". c None",
    "................",
    ".........#......",
    "......#.#a##....",
    ".....#b#bbba##..",
    "....#b#bbbabbb#.",
    "...#b#bba##bb#..",
    "..#b#abb#bb##...",
    ".#a#aab#bbbab##.",
    "#a#aaa#bcbbbbbb#",
    "#ccdc#bcbbcbbb#.",
    ".##c#bcbbcabb#..",
    "...#acbacbbbe...",
    "..#aaaacaba#....",
    "...##aaaaa#.....",
    ".....##aa#......",
    ".......##......."]


    
AutoopenTime = 750

class RListViewItem < QListViewItem
  @@itemDict = Hash.new(nil)
  def RListViewItem.at(s)
    @@itemDict[s]
  end
  def initialize(parent,filename,col2)
    super
    @@itemDict[fullPath] = self
  end
  def fullPath
    fullpath =  text(0).to_str()
	item = parent
    while ( item.is_a?(QListViewItem) )
	    if(item.parent)
	      fullpath = item.text(0).to_str() + "/" + fullpath
		else
		  fullpath = item.text(0).to_str() + fullpath
		end
	  item = item.parent()
    end
    return fullpath 
  end
    
end

class Directory < RListViewItem

  attr_reader:showDirsOnly

  def initialize ( parent, filename, col2="Default" )
    @f = filename
    super
    @pix = nil
    setPixmap($fileNormal)
    if(col2 != "Default")
      # do nothing
    elsif(parent.is_a?(Directory))
      @f = filename
      @showDirsOnly = parent.showDirsOnly
      @p = parent
      @readable = FileTest.readable?(fullName())
      if ( !@readable )
        setPixmap( $folderLocked )
      else
        setPixmap( $folderClosed )
      end
    elsif(parent.is_a?(QListView))
      @f = filename
      @showDirsOnly = parent.showDirsOnly
      @readable = FileTest.readable?(fullName)
	  if ( !@readable )
        setPixmap( $folderLocked )
      else
        setPixmap( $folderClosed )
      end
    end
    setText(1,text(1))
    
    
  end

  def text( column ) #cannot override! call apparently!
    if ( column == 0 ) # if(column)
      return @f
    elsif ( @readable )    
     return "Directory"
    else
     return "Unreadable Directory"
    end
  end

  def fullName()
    if ( @p )
      s = @p.fullName()
      s += "/" unless (/\/$/ =~ s)
      s += @f #.name()
      #s += "/"
    else
      s = @f #.name()
    end
    return s
  end

  def setOpen( o )
    if(!@readable)
	  return
	end
    if ( o )
      setPixmap( $folderOpen )
    else
      setPixmap( $folderClosed )
    end
    if ( o and childCount() == 0 )
      s =  fullName()
      if ( !FileTest.readable?(s) )
        @readable = false
        setExpandable( false )
        return
      end

      listView().setUpdatesEnabled( false )

      Dir[s + '/*'].each { | fi |
	    felement = fi.gsub(/.:/,"")
        felement = felement.gsub(/\/.*\//,"")
	    felement = felement.gsub(/\//,"")

        if (FileTest.symlink?(fi) and !@showDirsOnly)
          item = FileItem.new(self,felement,"Symbolic Link")
	      item.setPixmap( $fileNormal)
        elsif (FileTest.directory?(fi))
	      Directory.new(self,felement)
        elsif (!@showDirsOnly)
	      item = FileItem.new(self,felement, (FileTest.file?(fi) ? "File":"Special"))
          item.setPixmap( $fileNormal)
        end
      }
      listView().setUpdatesEnabled( true)
    end
    super
  end

  def setup()
    setExpandable( true )
    super
  end

  def setPixmap( px )
    @pix = px
    super(0,@pix)
    setup()
    widthChanged( 0 )
    invalidateHeight()
    repaint()
  end

  def pixmap(  i )
    if ( i.nil? )
      return 0
    end
    return @pix
  end

end


class FileItem < RListViewItem
  def initialize ( parent, s1, s2 )

    super
	#: QListViewItem( parent, s1, s2 ),
    @pix = nil
  end

  def setPixmap( p )
    @pix = p
    super(0,@pix)
    setup()
    widthChanged( 0 )
    invalidateHeight()
    repaint()
  end

  def pixmap( i )
    if ( i == 0 )
	return 0
    end
    return @pix
  end
end

class DirectoryView < QListView
  attr_reader:showDirsOnly,:folderSelected
  $folderLocked = nil
  def initialize( parent = nil, name = "", sdo = false );
    #: QListView( parent, name ),
    super(parent,name)
    @folderSelected = RSignal.new("Object")
    @showDirsOnly = sdo
    @oldCurrent = nil
    @dropItem = nil 
    @mousePressed = false
    if($folderLocked.nil?)
      $folderLocked = QPixmap.new( Folder_locked )
      $folderClosed = QPixmap.new( Folder_closed_xpm )
      $folderOpen = QPixmap.new( Folder_open_xpm )
      $fileNormal = QPixmap.new( Pix_file )
    end
    @autoopen_timer = QTimer.new( self )

    connect( self, QSIGNAL( "doubleClicked( QListViewItem * )" ),
	     self, "slotFolderSelected( QListViewItem * )" )
    connect( self, QSIGNAL( "returnPressed( QListViewItem * )" ),
	     self, "slotFolderSelected( QListViewItem * )" )

    setAcceptDrops( true )
    viewport().setAcceptDrops( true )

    connect( @autoopen_timer, QSIGNAL( "timeout()" ),
	     self, "openFolder()" )

    #necessary to call "virtual" method in C++
    #catchEvent  <- if you want to trap event for MyListView, install eventfilter to QApplication!
      @eventfilter = QR2EventFilter.new(self)
      QApplication::qApp.installEventFilter(@eventfilter) 
    connect( self, QSIGNAL( "clicked( QListViewItem *)"),
    		self, "itemClicked( QListViewItem *)")
    
  end

  def setDir( s)
    it = QListViewItemIterator.new( self )
    item = it.next()
    while(item  != nil)
      item.setOpen(false)
      item = it.next()
    end

    lst = s.split('/')
    item = firstChild()
    lst.each{| it2 |
      if(item.text(0) != it2)
        item.setOpen(true)
	break
      end
      item = item.itemBelow()
    }

    if(item)
      setCurrentItem(item)
    end
  end

  def slotFolderSelected( i )
    if ( i.nil? or  !showDirsOnly() ) #!i || !showDirsOnly()
      return
    end
    dir = i
    @folderSelected.sendWith( dir.fullName() )
  end

  def openFolder()
    @autoopen_timer.stop()
    if ( @dropItem and !@dropItem.isOpen() )
	@dropItem.setOpen( TRUE )
	@dropItem.repaint()
    end
  end

  def contentsDragEnterEvent( e )
  if ( !QUriDrag::canDecode(e) )
    e.ignore()
    return
  end
    @oldCurrent = currentItem()

    i = itemAt( e.pos()) #contentsToViewport(e.pos()) )
    if ( i )
      dropItem = i
      @autoopen_timer.start( AutoopenTime )
    end
  end

  def contentsDragMoveEvent( e )

    if ( !QUriDrag::canDecode(e) )
	e.ignore()
	return
    end

    vp = e.pos() #contentsToViewport( e.pos() )
    i = itemAt( vp )
    if ( i )
	setSelected( i, true )
	e.accept()
	if ( i != @dropItem )
	    @autoopen_timer.stop()
	    @dropItem = i
	    @autoopen_timer.start( AutoopenTime )
	end
	case e.action()
	when QDropEvent::Copy
	when QDropEvent::Move
	    e.acceptAction()
	when QDropEvent::Link
	    e.acceptAction()
	else
	# do nothing
	end
    else
	e.ignore()
	autoopen_timer.stop()
	@dropItem = nil
    end
    
  end

  def contentsDragLeaveEvent( e )

    @autoopen_timer.stop()
    @dropItem = nil

    setCurrentItem( @oldCurrent )
    setSelected( @oldCurrent, true )
  end

  def contentsDropEvent( e )

    @autoopen_timer.stop()

    if ( !QUriDrag::canDecode(e) )
	e.ignore()
	return
    end

    item = itemAt( e.pos()) #contentsToViewport(e.pos()) )
    if ( item )

	lst = QStrList.new
	dummy,lst = QUriDrag::decode( e) #, lst )	
	case ( e.action() )
	    when QDropEvent::Copy
	    str = "Copy"

	    when QDropEvent::Move
	    str = "Move"
	    e.acceptAction()

	    when QDropEvent::Link
	    str = "Link"
	    e.acceptAction()

	    else
	    str = "Unknown"
	end

	str += "\n\n"

	e.accept()

	for i in 0..(lst.count() - 1) #( uint i = 0 i < lst.count() ++i )
	    filename = lst.at( i ).to_str()
	    str += filename + "\n"
	end
	str += (QString.new( "\nTo\n\n   %1" ).arg( fullPath(item) ).to_str())

	QMessageBox::information( self, "Drop target", str, "Not implemented" )
    else
	e.ignore()
    end
  
  end
  
  def fullPath( item)

    fullpath = item.text(0).to_str()
    while ( (item=item.parent()) )
	if ( item.parent() )
	    fullpath = item.text(0).to_str() + "/" + fullpath
	else
	    fullpath = item.text(0).to_str() + fullpath
	end
    end
    return fullpath
  end

  def contentsMousePressEvent(  e )

    #super (e)
    #p = QPoint.new( contentsToViewport( e.pos() ) )
    p = e.pos() #contentsToViewport( e.pos())
    i = itemAt( p )
    
    if ( i )
	#// if the user clicked into the root decoration of the item, don't try to start a drag!
	if ( p.x() > header().cellPos( header().mapToActual( 0 ) ) +
	     treeStepSize() * ( i.depth() + ( rootIsDecorated() ? 1 : 0) ) + itemMargin() ||
	     p.x() < header().cellPos( header().mapToActual( 0 ) ) )
	    @presspos = QPoint.new(e.pos().x(),e.pos().y())
	    @mousePressed = true
	end
    end
  end

  def contentsMouseMoveEvent( e )

    if ( @mousePressed && ( QPoint.new(@presspos.x() - e.pos().x(), @presspos.y() - e.pos.y())).manhattanLength() > QApplication::startDragDistance() )
	@mousePressed = false
	item = itemAt( @presspos) #contentsToViewport(@presspos) )
	if ( item )
	    source = fullPath(item)

	    if (File::exist?(source)) #( QFile::exists(source) )
    
	    	qslist = QStringList.new()
	    	qslist.append(source)
		ud = QUriDrag.new(viewport())
		ud.setUnicodeUris( qslist )
		if ( ud.drag() )
		    QMessageBox::information( self, "Drag source",
					      "Delete " + source, "Not implemented" )
		end
		ud = nil
		#GC.start
	    end
	end
    end
    
  end

  def contentsMouseReleaseEvent( e )
    @mousePressed = @FALSE
  end

  def itemClicked( i )
    #special code for call setOpen
    if(i)
      item = RListViewItem.at(fullPath(i)) #i.text(0).to_str())
      if(item.is_a?(Directory))
        if(item.isOpen)
          item.setOpen(false)
        else
          item.setOpen(true)
        end
      end    
    end  
  end
  
end
