=begin
/****************************************************************************
** $Id: qt/examples/forever/forever.cpp   2.3.0   edited 2001-01-26 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include <qtimer.h>
#include <qpainter.h>
#include <qapplication.h>
#include <stdlib.h>				#// defines rand() function

#include "forever.h"


#//
#// Forever - a widget that draws rectangles forever.
#//

#//
#// Constructs a Forever widget.
#//
NumColors = 120

require "qt2"
include Qt2

class Forever < QWidget
def initialize ( parent=nil, name="" )
    super( parent, name )
    @colors = []
    for a in 0..(NumColors - 1) #(int a=0 a<numColors a++)
	@colors[a] = QColor.new( (rand()*255).to_i,
			    (rand()*255).to_i,
			    (rand()*255).to_i )
    end
    @rectangles = 0
    startTimer( 0 )				#// run continuous timer
    @counter = QTimer.new( self )
    connect( @counter, QSIGNAL("timeout()"),
	     self, "updateCaption()" )
    @counter.start( 1000 )
    catchEvent
end


def updateCaption()

    s = QString.new
    s.sprintf( "forever - %d rectangles/second", @rectangles )
    @rectangles = 0
    setCaption( s )
end


#//
#// Handles timer events for the Forever widget.
#//

def timerEvent( e )

    if(@paint.nil?)
	  @paint = QPainter.new #( self )			#// painter object
    end
	@paint.begin(self)
	@paint.setPen( NoPen )			#// do not draw outline
    w = width()
    h = height()
    for i in 0..99 #( int i=0 i<100 i++ )
	  @paint.setBrush( @colors[i % NumColors]) #// set random brush color
	  p1 = QPoint.new( (rand()*w).to_i, (rand()*h).to_i )	#// p1 = top left
	  p2 = QPoint.new( (rand()*w).to_i, (rand()*h).to_i )	#// p2 = bottom right
	  r = QRect.new( p1, p2 )
	  @paint.drawRect( r )			#// draw filled rectangle
	  @rectangles += 1
    end
	@paint.end
end

end

#//
#// Create and display Forever widget.
#//

    a = QApplication.new( [$0]+ARGV )		#// create application object
    always = Forever.new				#// create widget
    a.setMainWidget( always )			#// set as main widget
    always.show()				#// show widget
    a.exec()				#// run event loop

