=begin
/****************************************************************************
** $Id: qt/examples/hello/hello.cpp   2.3.0   edited 2001-01-26 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include "hello.h"
#include <qpushbutton.h>
#include <qtimer.h>
#include <qpainter.h>
#include <qpixmap.h>

=begin
/*
  Constructs a Hello widget. Starts a 40 ms animation timer.
*/
=end
require "qt2"
include Qt2

    Sin_tbl = [
        0, 38, 71, 92, 100, 92, 71, 38,	0, -38, -71, -92, -100, -92, -71, -38 ]


class Hello < QWidget
attr_reader :click
def initialize (parent = nil,name = "")
   super
   @b = 0
   @click = RSignal.new("")

    @timer = QTimer.new(self)
    Qt2::connect( @timer, QSIGNAL("timeout()"), self, "animate()" )
    @timer.start( 40 )

    resize( 260, 130 )
    catchEvent
end

def setText(text)
   @t = text
end

=begin
/*
  This private slot is called each time the timer fires.
*/
=end
def animate()

    @b = (@b + 1) & 15
    repaint( FALSE )
end

=begin
/*
  Handles mouse button release events for the Hello widget.

  We emit the clicked() signal when the mouse is released inside
  the widget.
*/
=end
def mouseReleaseEvent( e )

    if ( rect().contains( e.pos() ) )
        @click.send
    end
end

=begin
/*
  Handles paint events for the Hello widget.

  Flicker-free update. The text is first drawn in the pixmap and the
  pixmap is then blt'ed to the screen.
*/
=end
def paintEvent( e )


    if ( @t.size == 0 )
        return
    end
    #// 1: Compute some sizes, positions etc.
    fm = fontMetrics()
    w = fm.width(@t) + 20
    h = fm.height() * 2
    pmx = width()/2 - w/2
    pmy = height()/2 - h/2

    #// 2: Create the pixmap and fill it with the widget's background
    pm = QPixmap.new( w, h )
    pm.fill( self, pmx, pmy )

    #// 3: Paint the pixmap. Cool wave effect
    p = QPainter.new
    x = 10
    y = h/2 + fm.descent()
    i = 0
    p.begin( pm )
    p.setFont( font() )
    while ( @t[i] != nil )
        i16 = (@b+i) & 15
        p.setPen( QColor.new((15-i16)*16,255,255,QColor::Hsv) )
        p.drawText( QPoint.new(x, y-Sin_tbl[i16]*h/800), @t[i,1],1 )
        x += fm.width( @t[i].chr )
        i += 1
    end
    p.end()

    #// 4: Copy the pixmap to the Hello widget
    bitBlt( self, pmx, pmy, pm )
end
end
    a = QApplication.new([$0]+ARGV)
    argc = ARGV.size + 1
    s = ""
    for i in 1..argc #( int i=1 i<argc i++ )
	s += "#{ARGV[i]}"
	if ( i<argc-1 )
	    s += " "
             end
    end
    if ( s.size == 0 )
	s = "Hello, World"
    end
    h = Hello.new
    h.setText( s )
    h.setCaption( "Qt says hello" )
    connect( h.click, a, QSLOT("quit()") )
    h.setFont( QFont.new("times",32,QFont::Bold) )		#// default font
    h.setBackgroundColor( Qt::white )			#// default bg color
    a.setMainWidget( h )
    h.show()
    a.exec()




