=begin
/****************************************************************************
** $Id: qt/examples/helpviewer/helpwindow.cpp   2.2.2   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include "helpwindow.h"
#include <qstatusbar.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qiconset.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstylesheet.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qapplication.h>
#include <qcombobox.h>
#include <qevent.h>
#include <qlineedit.h>
#include <qobjectlist.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qdatastream.h>
#include <qprinter.h>
#include <qsimplerichtext.h>
#include <qpaintdevicemetrics.h>

#include <ctype.h>
require "qt2"
include Qt2

IconDir= "./" #"/usr/share/icons/"

class HelpWindow < QMainWindow

def setHomePath( home_, _path)
    qsl = QStringList.new
    qsl.append(_path)
    @browser.mimeSourceFactory().setFilePath( qsl )

    if ( home_.size > 0 )
	@browser.setSource( home_ )
    end

    @pathCombo.insertItem( home_ )

end

def initialize( parent=nil, name="", f=WDestructiveClose )
    super( parent, name, WDestructiveClose )
    #  @pathCombo( 0 ), @selectedURL()
    @history = []
    @bookmarks = []
    @mHistory = Hash.new
    @mBookmarks = Hash.new

    readHistory()
    readBookmarks()

    @browser = QTextBrowser.new( self )
 #   @browser.mimeSourceFactory().setFilePath( _path )
    @browser.setFrameStyle( QFrame::Panel | QFrame::Sunken )
    connect( @browser, QSIGNAL( "textChanged()" ),self, "textChanged()"  )

    setCentralWidget( @browser )

    #if ( !home_.isEmpty() )
#	@browser.setSource( home_ )

    connect( @browser, QSIGNAL( "highlighted( const QString&)" ),statusBar(), QSLOT( "message( const QString&)") )

    resize( 640,700 )

    file = QPopupMenu.new( self )
    file.insertItem( tr("&New Window"), self, "newWindow()" , ALT | Key_N )
    file.insertItem( tr("&Open File"), self, "openFile()", ALT | Key_O )
    file.insertItem( tr("&Print"), self, "print()", ALT | Key_P )
    file.insertSeparator()
    file.insertItem( tr("&Close"), self, "close()", ALT | Key_Q )
    file.insertItem( tr("E&xit"), QApplication::qApp, "closeAllWindows()", ALT | Key_X )

    #// The same three icons are used twice each.
    icon_back=QIconSet.new( QPixmap.new(IconDir+"back.xpm") )
    icon_forward=QIconSet.new( QPixmap.new(IconDir+"forward.xpm") )
    icon_home=QIconSet.new( QPixmap.new(IconDir+"home.xpm") )

    go = QPopupMenu.new( self )
    @backwardId = go.insertItem( icon_back, tr("&Backward"), @browser, "backward()",
				 ALT | Key_Left )
    @forwardId = go.insertItem( icon_forward, tr("&Forward"), @browser, "forward()",
				ALT | Key_Right )
    go.insertItem( icon_home, tr("&Home"), @browser, "home()")

    help = QPopupMenu.new( self )
    help.insertItem( tr("&About ..."), self, "about()" )
    help.insertItem( tr("About &Qt ..."), self, "aboutQt()" )

    @hist = QPopupMenu.new( self )
    for it in 0..(@history.size - 1)
       @mHistory[ @hist.insertItem(@history[it]) ] = @history[it]
    end

    #QStringList::Iterator it = @history.begin()
    #for (  it != @history.end() ++it )
    #	@mHistory[ @hist.insertItem( *it ) ] = *it
    connect( @hist, QSIGNAL( "activated( int )" ),  self, "histChosen( int )")

    @bookm = QPopupMenu.new( self )
    @bookm.insertItem( tr( "Add Bookmark" ), self, "addBookmark()" )
    @bookm.insertSeparator()
    for it in 0..(@bookmarks.size - 1)
       @mBookmarks[ @bookm.insertItem(@bookmarks[it])]  = @bookmarks[it]
    end
    #QStringList::Iterator it2 = @bookmarks.begin()
    #for (  it2 != @bookmarks.end() ++it2 )
    #	@mBookmarks[ @bookm.insertItem( *it2 ) ] = *it2
    connect( @bookm, QSIGNAL( "activated( int )" ),   self, "bookmChosen( int )" )

    menuBar().insertItem( tr("&File"), file )
    menuBar().insertItem( tr("&Go"), go )
    menuBar().insertItem( tr( "History" ), @hist )
    menuBar().insertItem( tr( "Bookmarks" ), @bookm )
    menuBar().insertSeparator()
    menuBar().insertItem( tr("&Help"), help )

    menuBar().setItemEnabled( @forwardId, FALSE)
    menuBar().setItemEnabled( @backwardId, FALSE)
    connect( @browser, QSIGNAL("backwardAvailable( bool )") ,  self, "setBackwardAvailable( bool )" )
    connect( @browser, QSIGNAL("forwardAvailable( bool )") ,   self, "setForwardAvailable( bool )"  )


    toolbar = QToolBar.new( self )
    addToolBar( toolbar, "Toolbar")

    button = QToolButton.new( icon_back, tr("Backward"), "", @browser, "backward()", toolbar )
    connect( @browser, QSIGNAL("backwardAvailable(bool)"), button, QSLOT("setEnabled(bool)") )
    button.setEnabled( FALSE )
    button = QToolButton.new( icon_forward, tr("Forward"), "", @browser, "forward()", toolbar )
    connect( @browser, QSIGNAL("forwardAvailable(bool)"), button, QSLOT( "setEnabled(bool)" ) )
    button.setEnabled( FALSE )
    button = QToolButton.new( icon_home, tr("Home"), "", @browser, "home()", toolbar )

    toolbar.addSeparator()

    @pathCombo = QComboBox.new( TRUE, toolbar )
    connect( @pathCombo, QSIGNAL( "activated( const QString & )" ),  self, "pathSelected( const QString & )" )
    toolbar.setStretchableWidget( @pathCombo )
    setRightJustification( TRUE )
    setDockEnabled( Left, FALSE )
    setDockEnabled( Right, FALSE )

#    @pathCombo.insertItem( home_ )

    @browser.setFocus()
    catchEvent
end


def setBackwardAvailable( b)

    menuBar().setItemEnabled( @backwardId, b)
end

def setForwardAvailable( b)

    menuBar().setItemEnabled( @forwardId, b)
end


def textChanged()

    if ( @browser.documentTitle().isNull() )
	setCaption( @browser.context() )
    else
	setCaption( @browser.documentTitle() )
    end
    @selectedURL = caption()
    if ( !@selectedURL.isEmpty() && !(@pathCombo.nil?) )
	exists = FALSE
	#int i
	for i in 0..(@pathCombo.count() - 1) #( i = 0 i < @pathCombo.count() ++i )
	    if ( @pathCombo.text( i ) == @selectedURL )
		exists = TRUE
		break
	    end
	end
	if ( !exists )
	    @pathCombo.insertItem( @selectedURL, 0 )
	    @pathCombo.setCurrentItem( 0 )
	    @mHistory[ @hist.insertItem( @selectedURL ) ] = @selectedURL
	else
	    @pathCombo.setCurrentItem( i )
             end
	@selectedURL = QString::null
    end
end

#def exitHelpWindow()
def closeEvent(e)
    @history.clear()
    @mHistory.each_value {|url|
        @history.push(url)
    }
    #QMap<int, QString>::Iterator it = mHistory.begin()
    #for (  it != @mHistory.end() ++it )
    #	@history.append( *it )

    f = File.new( (QDir::currentDirPath().to_str + "/.history"),"w" )
    #f.open( IO_WriteOnly )
    #QDataStream s( &f )
    #s << @history
    @history.each{|l|
        f << l.to_str << "\n"
    }
    f.close()

    @bookmarks.clear()
    @mBookmarks.each_value {|url|
       @bookmarks.push(url)
    }
    #QMap<int, QString>::Iterator it2 = @mBookmarks.begin()
    #for (  it2 != @mBookmarks.end() ++it2 )
    #	@bookmarks.append( *it2 )
    f2 = File.new(QDir::currentDirPath().to_str + "/.bookmarks","w")
    @bookmarks.each {|l|
       f2 << l.to_str << "\n"
    }
    #QFile f2( QDir::currentDirPath() + "/.bookmarks" )
    #f2.open( IO_WriteOnly )
    #QDataStream s2( &f2 )
    #s2 << @bookmarks
    f2.close()
    QApplication::qApp.quit()
end

def about()

    QMessageBox::about( self, "HelpViewer Example",
			("<p>This example implements a simple HTML help viewer " +"using Qt's rich text capabilities</p>"  + "<p>It's just about 100 lines of C++ code, so don't expect too much :-)</p>"))
end


def aboutQt()

    QMessageBox::aboutQt( self, "QBrowser" )
end

def openFile()

#ifndef QT_NO_FILEDIALOG 
    fn = QFileDialog::getOpenFileName( QString::null, QString::null, self )
    if ( !fn.isEmpty() )
	@browser.setSource( fn )
    end
#endif
end

def newWindow()

    ( new HelpWindow(@browser.source(), "qbrowser") ).show()
end

def print()

#ifndef QT_NO_PRINTER
    printer = QPrinter.new
    printer.setFullPage(TRUE)
    if ( printer.setup() ) 
	p = QPainter.new( printer )
	metrics = QPaintDeviceMetrics.new(p.device())
	dpix = metrics.logicalDpiX()
	dpiy = metrics.logicalDpiY()
	margin = 72 #// pt
	body = QRect.new(margin*dpix/72, margin*dpiy/72,
		   metrics.width()-margin*dpix/72*2,
		   metrics.height()-margin*dpiy/72*2 )
	font = QFont.new("times", 10)
        font.setCharSet(QFont::Unicode)
	richText = QSimpleRichText.new( @browser.text(), font, @browser.context(), @browser.styleSheet(), @browser.mimeSourceFactory(), body.height() )
	richText.setWidthQPainter( p, body.width() )
	view = QRect.new( body )
	page = 1
	begin
	    richText.draw( p, body.left(), body.top(), view, colorGroup() )
	    view.moveBy( 0, body.height() )
	    p.translate( 0 , -body.height() )
	    p.setFont( font )
	    p.drawText( view.right() - p.fontMetrics().width( QString::number(page) ),(view.bottom() + p.fontMetrics().ascent() + 5), QString::number(page) )
	    if ( view.top()  >= richText.height() )
		break
                 end
	    printer.newPage()
	    page += 1
	end while (TRUE)
    end
#endif
end

def pathSelected( _path )
    exists = FALSE
    @browser.setSource( _path )
    @mHistory.each_value {|url|
       if(url == _path)
          exists = TRUE
          break
       end
    }

#    QMap<int, QString>::Iterator it = @mHistory.begin()
#    bool exists = FALSE
#    for (  it != @mHistory.end() ++it )
#	if ( *it == _path )
#	    exists = TRUE
#	    break
#	end
#    end
    if ( !exists )
	@mHistory[ @hist.insertItem( _path ) ] = _path
    end
end

def readHistory()

    if ( File::exist?( QDir::currentDirPath().to_str + "/.history" ) )
	f = File.new( QDir::currentDirPath().to_str + "/.history","r" )
	#f.open( IO_ReadOnly )
	#QDataStream s( &f )
	@history = f.readlines
	f.close()
             @history.each {|l| l.chop!}
	while ( @history.size > 20 )
	    @history.shift
             end
    end
end

def readBookmarks()

    if ( File::exists?( QDir::currentDirPath().to_str + "/.bookmarks" ) )
	f = File.new( QDir::currentDirPath().to_str + "/.bookmarks" )
	#f.open( IO_ReadOnly )
	#QDataStream s( &f )
	@bookmarks = f.readlines
	f.close()
             @bookmarks.each{|l| l.chop! }
    end
end

def histChosen( i )

    if ( @mHistory.key?( i ) )
	@browser.setSource( @mHistory[ i ] )
    end
end

def bookmChosen( i )

    if ( @mBookmarks.key?( i ) )
	@browser.setSource( @mBookmarks[ i ] )
    end
end

def addBookmark()
    @mBookmarks[ @bookm.insertItem( caption() ) ] = caption()
end

end
