=begin
/****************************************************************************
** $Id: qt/examples/layout/layout.cpp   2.2.2   edited 2000-11-06 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include <qapplication.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
require "qt2"
include Qt2

class ExampleWidget < QWidget
def initialize( parent=nil, name="" )
    super( parent, name )

    #// Make the top-level layout a vertical box to contain all widgets
    #// and sub-layouts.
    topLayout = QVBoxLayout.new( self, 5 )

    #// Create a menubar...
    menubar = QMenuBar.new( self )
    menubar.setSeparator( QMenuBar::InWindowsStyle )
    #QPopupMenu* popup
    popup = QPopupMenu.new( self )
    popup.insertItem( "&Quit", QApplication::qApp, "quit()" )
    menubar.insertItem( "&File", popup )

    #// ...and tell the layout about it.
    topLayout.setMenuBar( menubar )

    #// Make an hbox that will hold a row of buttons.
    buttons = QHBoxLayout.new( topLayout)
    #int i
    for i in 1..4 #( i = 1 i <= 4 i++ )
	but = QPushButton.new("", self )
	#QString s
	s = "Button #{i}"
	but.setText( s )

	#// Set horizontal stretch factor to 10 to let the buttons
	#// stretch horizontally. The buttons will not stretch
	#// vertically, since bigWidget below will take up vertical
	#// stretch.
	buttons.addWidget( but, 10 )
	#// (Actually, the result would have been the same with a
	#// stretch factor of 0 if no items in a layout have non-zero
	#// stretch, the space is divided equally between members.)
    end

    #// Make another hbox that will hold a left-justified row of buttons.
    buttons2 = QHBoxLayout.new( topLayout )

    but = QPushButton.new( "Button five", self )
    buttons2.addWidget( but )

    but = QPushButton.new( "Button 6", self )
    buttons2.addWidget( but )

    #// Fill up the rest of the hbox with stretchable space, so that
    #// the buttons get their minimum width and are pushed to the left.
    buttons2.addStretch( 10 )

    #// Make  a big widget that will grab all space in the middle.
    bigWidget = QMultiLineEdit.new( self )
    bigWidget.setText( "This widget will get all the remaining space" )
    bigWidget.setFrameStyle( QFrame::Panel | QFrame::Plain )

    #// Set vertical stretch factor to 10 to let the bigWidget stretch
    #// vertically. It will stretch horizontally because there are no
    #// widgets beside it to take up horizontal stretch.
    #//    topLayout.addWidget( bigWidget, 10 )
    topLayout.addWidget( bigWidget) #//###

    #// Make a grid that will hold a vertical table of QLabel/QLineEdit
    #// pairs next to a large QMultiLineEdit.

    #// Don't use hard-coded row/column numbers in QGridLayout, you'll
    #// regret it when you have to change the layout.
    numRows = 3
    labelCol = 0
    linedCol = 1
    multiCol = 2

    #// Let the grid-layout have a spacing of 10 pixels between
    #// widgets, overriding the default from topLayout.
    grid = QGridLayout.new( topLayout, 0, 0, 10 )
    #int row

    for row in 0..(numRows - 1) #( row = 0 row < numRows row++ )
	ed = QLineEdit.new("", self )
	#// The line edit goes in the second column
	grid.addWidget( ed, row, linedCol )	

	#// Make a label that is a buddy of the line edit
	#QString s
	s = "Line #{row+1}"
	label = QLabel.new( s, self )
             label.setBuddy(ed)
	#// The label goes in the first column.
	grid.addWidget( label, row, labelCol )
    end

    #// The multiline edit will cover the entire vertical range of the
    #// grid (rows 0 to numRows) and stay in column 2.

    med = QMultiLineEdit.new( self )
    grid.addMultiCellWidget( med, 0, -1, multiCol, multiCol )

    #// The labels will take the space they need. Let the remaining
    #// horizontal space be shared so that the multiline edit gets
    #// twice as much as the line edit.
        grid.setColStretch( linedCol, 10 )
        grid.setColStretch( multiCol, 20 )

    #// Add a widget at the bottom.
    sb = QLabel.new("", self )
    sb.setText("Let's pretend self is a status bar")
    sb.setFrameStyle( QFrame::Panel | QFrame::Sunken )
    #// This widget will use all horizontal space, and have a fixed height.

    #// we should have made a subclass and implemented sizePolicy there...
    sb.setFixedHeight( sb.sizeHint().height() )

    sb.setAlignment( AlignVCenter | AlignLeft )
    topLayout.addWidget( sb )

    topLayout.activate()
end
end

    a =QApplication.new( [$0]+ARGV )

    f = ExampleWidget.new
    a.setMainWidget(f)
    f.show()

    a.exec()

