=begin
/****************************************************************************
** $Id: movies.rb,v 1.2 2000/09/21 07:14:34 horie Exp $
**
** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
require "qt2"
include Qt2

class MovieScreen < QFrame
def initialize
    super
    @p = QPainter.new(nil)
    catchEvent
end
def setContents( fname, m)
   @filename = fname
   @movie = m
   setCaption(fname);
   @movie.setBackgroundColor(backgroundColor());
   #// Set a frame around the movie.
   setFrameStyle(QFrame::WinPanel|QFrame::Sunken);

   #// No background needed, since we draw on the whole widget.
   setBackgroundMode(NoBackground);

   #// Get the movie to tell use when interesting things happen.
   @movie.connectUpdate(self, "movieUpdated");
   @movie.connectResize(self, "movieResized");
   @movie.connectStatus(self, "movieStatus");
end
def paintEvent e
   drawContents(nil)
   #GC.start
end
#def resizeEvent e
#   movieResized self.size
#end
#protected:

    #// Draw the contents of the QFrame - the movie and on-screen-display
def drawContents( p)
        @p.begin(self)
	#// Get the current movie frame.
	@pm = @movie.framePixmap

	#// Get the area we have to draw in.
	r = contentsRect
	#// Only rescale is we need to - it can take CPU!
	if ( r.size != @pm.size )

	    m = QWMatrix.new;
            if (@pm.width !=0)
	       m.scale(1.0 * (r.width) / (@pm.width) , 1.0 * (r.height)  / (@pm.height) );
            end
	    pm = @pm.xForm(m);
	end

	#// Draw the [possibly scaled] frame.  movieUpdated() below calls
	#// repaint with only the changed area, so clipping will ensure we
	#// only do the minimum amount of rendering.
	#//
	@p.drawPixmap(r.x, r.y, pm);

	#// The on-screen display
	message = "";

	if (@movie.paused())
	    message = "PAUSED";
	elsif (@movie.finished())
	    message = "THE END";
	elsif (@movie.steps() > 0)
	    message = "FF >>";
	end

	if (message != "")
	    #// Find a good font size...
	    @p.setFont(QFont.new("Helvetica", 24));

	    fm = @p.fontMetrics();
	    if ( fm.width(message) > r.width()-10 )
		@p.setFont(QFont.new("Helvetica", 18));
            end

	    fm = @p.fontMetrics();
	    if ( fm.width(message) > r.width()-10 )
		@p.setFont(QFont("Helvetica", 14));
            end

	    fm = @p.fontMetrics();
	    if ( fm.width(message) > r.width()-10 )
		@p.setFont(QFont("Helvetica", 12));
            end

	    fm = @p.fontMetrics();
	    if ( fm.width(message) > r.width()-10 )
		@p.setFont(QFont("Helvetica", 10));
            end
	    #// "Shadow" effect.
	    @p.setPen(QColor("black"));
	    @p.drawText(1, 1, width()-1, height()-1, AlignCenter, message);
	    @p.setPen(QColor("white"));
	    @p.drawText(0, 0, width()-1, height()-1, AlignCenter, message);
	end

    @p.end
    #GC.start
    end

    def mouseReleaseEvent(event)

	#// Do what the Help says...
	if (event.state == ShiftButton + 1)
	    @movie.restart

	elsif (!@movie.paused)
	    @movie.pause;
	elsif (event.button == LeftButton )  # &->==
               GC.start
		if (event.state == ControlButton + 1)
			st = 10
    		else
			st =1
		end
                @movie.step(st)
	elsif ((event.button == MidButton) ||(event.button == RightButton))
	     @movie.unpause;

	end

	repaint(); #// To hide/show "PAUSED".
        #GC.start
    end

#private slots:
    def movieUpdated ( area )
	if (!isVisible())
	    show();
        end
	#// The given area of the movie has changed.

	r = contentsRect

	if ( r.size() != @movie.framePixmap.size )
	    #// Need to scale - redraw whole frame.
	    repaint( r );
 	else
	    #// Only redraw the changed area of the frame
	    repaint( area.x+r.x, area.y+r.x,
		area.width, area.height );
	end
    end

    def movieResized( size )
	#// The movie changed size, probably from its initial zero size.

	fw = frameWidth;

	resize( size.width + fw * 2, size.height + fw * 2 )

#	QApplication::qApp.setMainWidget(self); #// Just geometry, etc.
#	QApplication::qApp.setMainWidget(0); #// Not Close==Quit
    end

    def movieStatus( status)
	#// The movie has sent us a status message.

	if (status < 0)
	    msg = "Could not play movie \"#{@filename}\"";
	    QMessageBox::message("Error", msg);
	elsif (status == QMovie::Paused || status == QMovie::EndOfMovie)
	    repaint; #// Ensure status text is displayed
	end
    end
end

#// A QFileDialog that chooses movies.
#//
class MovieStarter  < QRFileDialog
def initialize( dir , str = "*.gif")
      super (dir, "*.gif")  # no effect?
      setSelf(self)
       # //behave as in getOpenFilename
      setMode( QFileDialog::ExistingFile);
        #// When a file is selected, show it as a movie.
      #rs = RSignal.new("const QString &")
      Qt2::connect(self,QSIGNAL("fileSelected(const QString&)"),self,"startMovie")
      #Qt2::connect(rs,self,"startMovie")
end
def startMovie filename
      if(!filename.nil?)
      @mv = MovieScreen.new #(filename,QMovie.new(filename),0,0,WDestructiveClose)
      @movie = QRMovie.new(filename);
      @mv.setContents(filename,@movie);

      @mv.resize(128,64)
      @mv
      end
end
def done(r)
      if(r != Accepted)
         QApplication::qApp.quit();
      end
      setResult(r);
end
end


    a = QApplication.new(ARGC = [$0] + ARGV);

    QApplication::setFont(QFont.new("Helvetica"));

    if (ARGC.size > 1)
	#// Commandline mode - show movies given on the command line
	#//
	for arg in.1..(ARGC.size - 1)
	    mv = MovieScreen.new( "", nil, WDestructiveClose);
            mv.setContent(ARGC[arg], QMovie(ARGC[arg]))
        end
	QObject::connect(QApplication::qApp, QSIGNAL("lastWindowClosed()"),QApplication::qApp, QSLOT("quit()"));

    else

	#// GUI mode - open a chooser for movies
	#//
        fd = MovieStarter.new(".","*.gif")
        fd.show()
=begin
        mv = MovieScreen.new  #(nil, "", WDestructiveClose);  # ? "" -> nil
        filename = "trolltech.gif"
        @movie = QRMovie.new(filename);
        mv.setContents(filename,@movie);

        mv.resize(128,64)
        mv.show
=end
	#// Some help text to explain the `hidden' features.
	help = QLabel.new(
	    "Mouse controls movie (also start GC).\n\n" + "Shift-click to Restart.\n" +"Click to Pause,\n" +"then left-click to Step,\n" +"control-left-click to Step 10,\n" +"right-click to Unpause\n\n" +"Windows may be resized to enlarge movie.\n\nThis program was rewritten for Ruby/Qt",nil);
	help.setCaption("movies - Help");
	help.setMargin(10);
	help.adjustSize();
	help.show();
    end
    Qt::connect(QApplication::qApp, QSIGNAL("lastWindowClosed()"),QApplication::qApp, QSLOT("quit()"));
    #// Go!
    a.setMainWidget(help)
    a.exec();


