=begin
/****************************************************************************
** $Id: qt/examples/popup/popup.cpp   2.2.2   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
require "qt2"
include Qt2
#include "popup.h"
#include <qapplication.h>
#include <qkeycode.h>
#include <qlayout.h>
class FancyPopup < QLabel

#public:
def initialize( l, parent, name , w=WType_Popup)
    super( l, parent, name, w )
        setFrameStyle( WinPanel|Raised )
        setAlignment( AlignCenter )
        resize(150,100)
        @moves = 0
        setMouseTracking( TRUE )
    catchEvent
end

def popup( parent = nil)
    @popupParent = parent
    setText("Move the mouse!")
    if (@popupParent != nil)
        move( @popupParent.mapToGlobal( @popupParent.rect().bottomLeft() ) )
   end
    show()
end

#protected:
def  mouseMoveEvent( e )
    @moves += 1
    s= "#{e.pos().x()}, #{e.pos().y()}"
    if (e.state() & QMouseEvent::LeftButton)
        s += " (down)"
    end
    setText(s)
end

def mouseReleaseEvent( e )
    if  (rect().contains( e.pos() ) || @moves > 5)
        close()
    end
end

def closeEvent( e )
    e.accept()
    @moves = 0
    if (@popupParent == nil)
        return
     end
    #// remember that we (as a popup) might recieve the mouse release
    #// event instead of the popupParent. This is due to the fact that
    #// the popupParent popped us up in its mousePressEvent handler. To
    #// avoid the button remaining in pressed state we simply send a
    #// faked mouse button release event to it.
    me = QMouseEvent.new(  QEvent::MouseButtonRelease, QPoint.new(0,0), QMouseEvent::LeftButton,  QMouseEvent::NoButton)
    #me = QMouseEvent.new( QEvent::MouseButtonRelease, QPoint.new(0,0), QPoint.new(0,0), QMouseEvent::LeftButton, QMouseEvent::NoButton)
    QApplication::sendEvent( @popupParent, me )
end
end

 class Frame < QFrame

#public:
def initialize( parent=nil, name="")
   super
    @button1 = QPushButton.new("Simple Popup", self)
    Qt2::connect ( @button1, QSIGNAL( "clicked()" ), self, "button1Clicked()" )
    @button2 = QPushButton.new("Fancy Popup", self)
    connect ( @button2, QSIGNAL( "pressed()" ), self, "button2Pressed()" )

    l = QHBoxLayout.new( self )
    @button1.setMaximumSize(@button1.sizeHint())
    @button2.setMaximumSize(@button2.sizeHint())
    l.addWidget( @button1 )
    l.addWidget( @button2 )
    l.activate()

#//     button1.setGeometry(20,20,100,30)
#//     button2.setGeometry(140,20,100,30)
    resize(270, 70)

    #//create a very simple popup: it is just composed with other
    #//widget and will be shown after clicking on button1

    @popup1 = QFrame.new( self ,"", WType_Popup)
    @popup1.setFrameStyle( WinPanel|Raised )
    @popup1.resize(150,100)
    tmpE = QLineEdit.new( "",@popup1,"" )
    connect( tmpE, QSIGNAL( "returnPressed()" ), @popup1, QSLOT( "hide()" ) )
    tmpE.setGeometry(10,10, 130, 30)
    tmpE.setFocus()
    tmpB = QPushButton.new("Click me!", @popup1)
    connect( tmpB, QSIGNAL( "clicked()" ), @popup1, QSLOT( "close()" ) )
    tmpB.setGeometry(10, 50, 130, 30)

    #// the fancier version uses its own class. It will be shown when
    #// pressing button2, so they behavior is more like a modern menu
    #// or toolbar.

    @popup2 = FancyPopup.new("", self ,"",WType_Popup)
    #// you might also add new widgets to the popup, just like you do
    #// it with any other widget.  The next four lines (if not
    #// commented out) will for instance add a line edit widget.

#//     tmpE = new QLineEdit( popup2 )
#//     tmpE.setFocus()
#//     connect( tmpE, SIGNAL( returnPressed() ), popup2, SLOT( close() ) )
#//     tmpE.setGeometry(10, 10, 130, 30)
    catchEvent
end


 #protected:

 #private slots:
def button1Clicked()
    @popup1.move( mapToGlobal( @button1.geometry().bottomLeft() ) )
    @popup1.show()
end


def button2Pressed()
    @popup2.popup(@button2)
end


 end

   a = QApplication.new([$0]+ARGV)

    frame = Frame.new
    frame.setCaption("Custom Popups")
    a.setMainWidget(frame)
    frame.show()
    a.exec()

