=begin
Library for using ui file of Qt designer
=end

require "qt2"
include Qt2
require "qt2xml"
include Qt2xml
require "formmaker.rb"

class Uic
def initialize ( uifile)
   @i18nfunc="tr"
   @doc = QDomDocument.new( "ui" )
   if ( !(f = File::open( uifile,"r" ) ) )
      STDERR.print "can't open file:#{uifile}\n"
      exit(1)
   end

   if ( !(@doc.setContent( f.read )) )
      STDERR.print "can't read file:#{uifile}\n"
      f.close()
      exit (1)
   end
end

def setI18nFunc( i18nfunc )
   @i18nfunc = i18nfunc
end

def getSource( withMain=true)
   form = FormMaker.new(@doc,true,@i18nfunc)
   source = form.getHeader
   source += form.getComment
   if(@enableUtfTr)
      source += @utfTrCode
   end
   source += form.rootForm.toString
   if(withMain)
      source += form.getMainProgram
   end
   source
end

def getFormClassName
  form = FormMaker.new(@doc)
  form.className
end

def saveSource( output ,withMain=true)
   file = File.new(output,"w")
   file << getSource(withMain)
   file.close
end

def execSource
   form = FormMaker.new(@doc,true,@i18nfunc)
   source = form.rootForm.getExtraRequires
   if(@enableUtfTr)
      source += @utfTrCode
   end 
   source += form.rootForm.toString
   source += form.getMainProgram
   source
   #eval(source)
end
end

alias require_orig require
def require file
  if /\.ui/ =~ file
    requireUI file
  else
    require_orig file
  end
end

def requireUI file
  uic = Uic.new(file)
  formClass = uic.getFormClassName
  ret = false
  begin
    eval(formClass)
  rescue NameError
   source = uic.getSource(false)
    eval(source)
    ret = true
  end
  ret
end

  
