
def int2bool(int)
  # 1 is true, 0 is false.
  if int != 0
    true
  else
    false
  end
end

class FormMaker
attr_reader :className, :rootwidget, :rootConnections, :rootForm, :rootSlots
def initialize( domdoc , enableUtf8=false, i18nfunc="tr")
   @enableUtf8 = enableUtf8
   @i18nfunc=i18nfunc
   self.parse(domdoc)
end

def parse( domdoc )
   connections = [[],[]]
   images = []
   tabstops = []
   @comment = ""
   dom = domdoc.firstChild.firstChild
   while(dom.toElement.tagName.to_str != "")
       case dom.toElement.tagName.to_str
       when "class"
       @className = dom.firstChild.toText.data.to_str
       when "comment"
       @comment = dom.firstChild.toText.data.to_str
       when "widget"
       @rootWidget = RWidget::makeRWidget(dom,"self")
       when "connections"
        connections = RConnections::connectionList(dom,@className)
       when "images"
        images = RImage::imageList(dom)
       when "tabstops"
        tabstops = RTabStop::tabstopList(dom)
       end
       dom = dom.nextSibling
    end
   @rootConnections = connections[0]
   @rootSlots = connections[1]
   @rootForm = RootForm.new(@className, @rootWidget, @rootConnections, @rootSlots, images, tabstops,@i18nfunc)

end

def getComment
   str = ""
   comments = @comment.split("\n")
   comments.each{|l|
      str += "#" + l + "\n"
   }
   str
end

def getHeader
   str = ""
   str += "#!/usr/bin/env ruby\n"
   str += header_comment
   str += @rootForm.getRequires
   str
end

def header_comment
  str = "# This code was generated automatically by ui2rb-ui compiler written by ruby.\n"
  str += "# Generated date: #{Time.now} \n"
  str
end
def getMainProgram
   str = "#main roop for displaying form\n\n"
   str += "a = QApplication.new([$0]+ARGV)\n"
   if(@enableUtf8)
      str +=  "codec = QTextCodec.codecForName(\'UTF-8\')\n"
      str += "a.setDefaultCodec(codec)\n"
   end
   str += "#for close to quit program\n"
   str += "Qt2::connect(QApplication::qApp,QSIGNAL(\"lastWindowClosed()\"),\n"
   str += "   QApplication::qApp,QSLOT(\"quit()\"))\n"
   str += "myform = #{@className}.new\n"
   str += "a.setMainWidget(myform)\n"
   str += "myform.show()\n"
   str += "a.exec\n"
   str
end
end

class RootForm
attr_reader :className
ExtraModules = {"QCanvas" => "Qt2canvas",
                        "QGLWidget"=>"Qt2gl",
                        "QRGLWidget"=>"Qt2gl",
                        "QTable"=>"Qt2table",
                         "QXml"=>"Qt2xml",
                        "QDom"=>"Qt2xml",
                        "QSound"=>"Qt2sound"}
@@extraModules = []
def RootForm.extraModules
   @@extraModules
end

def initialize(className, rwidget, rconnections, rslots, images, tabstops,i18nfunc="tr")
      @className = className
      @isWizard = false
      @isDialog = false
      @isWidget = false
      extra = ExtraModules[@className]
      if(extra)
          @@extraModules.push(extra)
      end
      @rootWidget = rwidget
      @connections = rconnections
      @slots = rslots
      @images = images
      @tabstops = tabstops
      @i18nfunc=i18nfunc
      
      if(@rootWidget.qclass == "QWizard")
         @isWizard = true
      elsif(@rootWidget.qclass == "QDialog")
         @isDialog = true
      elsif (@rootWidget.qclass == "QWidget")
         @isWidget = true
      end
      
      @rootWidget.properties.each {|p|
         p.setOwner("")
      }
      @rootWidget.setParent("self")
      @rootWidget.setName("")
      @rootWidget.childWidgets.each {|w|
         w.setParent("self")
      }
      @rootWidget.layouts.each {|l|
         l.setParent("self")
      }
     
end

def toString
   str = "\n"
#    str = "#!/usr/bin/env ruby\n\n#This is for Ruby/Qt2 program\n"
#    str += "require  \"qt2\"\n"
#    str += "include Qt2\n"
#    str += getRequires
#    str += "\n#class definition for custom Form\n"
    str +=  getDefClass
#    str += "\n#define initialize function\n"
    if(@isWizard or @isDialog)
       str += "def initialize(parent=nil,name=\"\",modal=false,f=0)\n"
    elsif (@isWidget)
       str +=  "def initialize(parent=nil,name=\"\",f=0)\n"
    else
       str += "def initialize"
    end
     str += "   super\n"
#    str += "\n#image definitions\n"
    str += getDefImages
#    str += "\n#properties of main form\n"
    str += getDefProperties
#    str += "\n#child widgets\n"
    str += getDefChildWidgets
    str += "\n#connections of main form\n"
    str += getDefConnections
    str += "\n\n#taborders\n"
    str += getDefTabstops
    str += "\nend\n\n"
    str += getDefSlots
    str += "\nend\n"
end

def getRequires
#   str = "#required modules\n\n"
   str = ""
   str += "require \"qt2\"\n"
   str += "include Qt2\n"
   str += getExtraRequires
   str
end

def getExtraRequires
   str = ""
   @@extraModules.each{|mod|
      str += "require \"#{mod.downcase}\"\n"
      str += "include #{mod}\n"
   }
   str
end

def write( file )
   file << toString
end

def getDefClass
      str = "class #{@className} < #{@rootWidget.qclass}\n"
end

def getDefProperties
      properties = @rootWidget.properties
      str = ""
      properties.each {|p|
         str += "   " + p.toString(@i18nfunc)
      }
      str
end

def getDefChildWidgets
      str = ""
      @rootWidget.childWidgets.each {|c|
          str += c.toString(@i18nfunc)
          if(@isWizard)
             title_attrib = c.attributes.find{|p| p.itemName == "title"}
             if(title_attrib)
                title = title_attrib.args["string"]
             else
                title = c.name.gsub(/^@/,"")
             end
          str += "   addPage(#{c.name},#{@i18nfunc}(#{title}))\n"
          end
      }
      @rootWidget.layouts.each {|l|
          str += l.toString(@i18nfunc)
      }
      str
end

def getDefConnections
      str = ""
      @connections.each{|conn|
         str += "   " + conn.toString(@i18nfunc)
      }
      str
end

def getDefSlots
   str = ""
   @slots.each{|slot|
      str += slot.toString(@i18nfunc)
   }
   str
end

def getDefImages
   str = ""
   @images.each{|pixmap|
      str += pixmap.toString(@i18nfunc)
   }
   str
end 

def getDefTabstops
   str = ""
   @tabstops.each{|t|
      str += t.toString(@i18nfunc)
   }
   str
end
end


class RWidget
@@property_ignored = ["layoutMargin","layoutSpacing","vAlign","hAlign"]
@@id = 0
def RWidget.makeRWidget(domwidget,parent=nil)
   wattribute = Hash.new
   keys = ["row","column","rowspan","colspan"]
   keys.each{|key|
      qstr = domwidget.toElement.attribute(key)
      if(qstr.length() > 0)
         wattribute[key] = qstr.toInt[0]
      end
   }
   domnode = domwidget.firstChild
   tagname = domnode.toElement.tagName.to_str
   while(tagname != "")
      case tagname
      when "class"
         classname = domnode.firstChild.toText.data.to_str
         end
      domnode = domnode.nextSibling
      tagname = domnode.toElement.tagName.to_str
   end

   extra = RootForm::ExtraModules[classname]
 
   if(extra)
      RootForm::extraModules.push(extra)
   end
   case classname
   when "Line"
      RLine.new(domwidget,parent,wattribute)
   when "QLayoutWidget"
      RLayoutWidget.new(domwidget,parent,wattribute)
   when "QListBox"
      RListBox.new(domwidget,parent,wattribute)
   when "QComboBox"
      RComboBox.new(domwidget,parent,wattribute)
   when "QListView"
      RListView.new(domwidget,parent,wattribute)
   when "QIconView"
      RIconView.new(domwidget,parent,wattribute)
   when "QTabWidget"
      RTabWidget.new(domwidget,parent,wattribute)
   when "QWizard"
      RWizard.new(domwidget,parent,wattribute)
   else
      RWidget.new(domwidget,parent,wattribute)
   end
end

attr_reader :qclass, :properties,:attributes, :childWidgets, :layouts, :miscs
attr_reader :parent,:wattribute,:layoutParent,:name,:is_item,:isLayout,:haveName

def initialize ( domwidget, parent=nil, wattr=nil)
   @parent = parent
   @wattribute = wattr
   @layoutParent = nil
   @name = nil
   @haveName = false
   @qclass = nil
   @is_item = false
   @attributes = []
   @properties = []
   @childWidgets = []
   @layouts = []
   @miscs = []
   @isLayout = false
   @isLine = false
   textId = 0

   if(@wattribute.nil?)
     wattribute = Hash.new
     keys = ["row","column","rowspan","colspan"]
     keys.each{|key|
      qstr = domwidget.toElement.attribute(key)
      if(qstr.length() > 0)
         wattribute[key] = qstr.toInt[0]
      end
     }
     @wattribute = wattribute
   end

   domnode = domwidget.firstChild
   tagname = domnode.toElement.tagName.to_str
   while(tagname != "")
      case tagname
      when "class"
         if(@qclass.nil?)
            @qclass = domnode.firstChild.toText.data.to_str
         end
      when "property"
         if(is_a?(RListViewItem))
	    property = RListViewItemProperty.new(domnode,@qclass,textId)
	    if((@@property_ignored.find{|t| t == property.itemName}).nil?)
               @properties.push(property)
               textId += 1
	    end
         else
	    property = RProperty.new(domnode,@qclass)
	    if((@@property_ignored.find{|t| t == property.itemName}).nil?)
               @properties.push(property)
	    end
         end
      when "attribute"
         @attributes.push(RAttribute.new(domnode))
      when "widget"
         @childWidgets.push(RWidget::makeRWidget(domnode))
      when "vbox"
         @layouts.push(RVBox.new(domnode))
      when "hbox"
         @layouts.push(RHBox.new(domnode))
      when "spacer"
         @childWidgets.push(RSpacer.new(domnode))
      when "grid"
         @layouts.push(RGridLayout.new(domnode))
      else
          @miscs.push(domnode)
      end
      domnode = domnode.nextSibling
      tagname = domnode.toElement.tagName.to_str
   end
   #set my name ( @name ) from property
   @properties.each{|p|
      if(p.isName)
         setName("@" + p.args["cstring"].gsub("\"",""))
         @haveName = true
      end
   }
   if(!haveName)
      setName("#{self.class().to_s().downcase()}_#{@@id}")
      @@id += 1
   end
end

def toString(i18nfunc="tr")
   str = "\n"
   str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   str +=  "   " + l.toString(i18nfunc)
   }

#   str += "\n#layouts of widget\n"
   @layouts.each{|l|
      str += l.toString(i18nfunc)
   }
#   str += "\n#child widget\n"
   @childWidgets.each{|w|
      str += w.toString(i18nfunc)
   }
   str
end

def setName(name)
   @name = name
   @childWidgets.each{|w|
      w.setParent(@name)
   }
   @layouts.each{|l|
      l.setParent(@name)
   }
   @properties.each{|p| p.setOwner(@name)}
end

def setParent(parent)
   @parent = parent
end

def setLayoutParent(lparent)
   @layoutParent = lparent
end
end


class RListBox < RWidget
attr_reader :items
attr_accessor :lastItem	
def initialize ( domwidget, parent=nil, wattr=nil)
   super
   @items = []
   @lastItem = nil
   @miscs.each{|domnode|
      tagname = domnode.toElement.tagName.to_str
      case tagname
      when "item"
         @items.push(RListBoxItem.new(domnode,self))
      end
   }
end

def toString(i18nfunc="tr")
   str = super
   
   @items.each { |i|
 #     str += "\n# QListBoxItems \n"
      p_text = i.properties.find{|p| p.itemName == "text"}
      if(p_text)
         text = p_text.args["string"]
      else
         text = ""
      end
      p_pixmap = i.properties.find{|p| p.itemName == "pixmap"}
      if(p_pixmap)
         pixmap = p_pixmap.args["pixmap"]
	 str += "   #{@name}.insertItem(#{pixmap},#{i18nfunc}(#{text}))\n"
      else
         str += "   #{@name}.insertItem(#{i18nfunc}(#{text}))\n"
      end
   }
   str
end
end



class RComboBox < RWidget
attr_reader :items
attr_accessor :lastItem	
def initialize ( domwidget, parent=nil, wattr=nil)
   super
   @items = []
   @lastItem = nil
   @miscs.each{|domnode|
      tagname = domnode.toElement.tagName.to_str
      case tagname
      when "item"
         @items.push(RListBoxItem.new(domnode,self))
      end
   }
end

def toString(i18nfunc="tr")
   str = super
   
   @items.each { |i|
 #     str += "\n# QComboBoxItems \n"
      p_text = i.properties.find{|p| p.itemName == "text"}
      if(p_text)
         text = p_text.args["string"]
      else
         text = ""
      end
      p_pixmap = i.properties.find{|p| p.itemName == "pixmap"}
      if(p_pixmap)
         pixmap = p_pixmap.args["pixmap"]
	 str += "   #{@name}.insertItem(#{pixmap},#{i18nfunc}(#{text}))\n"
      else
         str += "   #{@name}.insertItem(#{i18nfunc}(#{text}))\n"
      end
   }
   str
end
end


class RIconView < RWidget
attr_reader :items
attr_accessor :lastItem
def initialize ( domwidget, parent=nil, wattr=nil)
   super
   @items = []
   @lastItem = nil
   @miscs.each{|domnode|
      tagname = domnode.toElement.tagName.to_str
      case tagname
      when "item"
         @items.push(RIconViewItem.new(domnode,self))
      end
   }
end

def toString(i18nfunc="tr")
   str = super
   @items.each { |i|
#      str += "\n# QIconViewItems \n"
      str += i.toString(i18nfunc)
   }
   str
end
end

class RListBoxItem < RWidget
attr_reader :after
attr_accessor :lastItem
def initialize(domnode,itemParent)
   super(domnode,itemParent.name)
   @text =nil
   @pixmap = nil
   p_text = @properties.find{|p| p.itemName == "text"}
   if(p_text)
      @text = p_text.args["string"]
   else
      @text = ""
   end
   p_pixmap = @properties.find{|p| p.itemName == "pixmap"}
   if(p_pixmap)
      @pixmap = p_pixmap.args["pixmap"]
      @qclass = "QListBoxPixmap"
   else
      @qclass = "QListBoxText"
   end

   @items = []
   @lastItem = nil
   @itemParent = itemParent
   if(@name.nil? or @name=="")
      @name="qlistBoxItem_#{@@id}"
      @@id += 1
   end
   @after = itemParent.lastItem
   itemParent.lastItem = self.name

   @miscs.each{|domnode|
      tagname = domnode.toElement.tagName.to_str
      case tagname
      when "item"
         @items.push(RListViewItem.new(domnode,self))
      end
   }

end

def toString(i18nfunc="tr")
   str = "\n"
   if(@after)
      str += "   #{@name} = #{@qclass}.new(#{@parent},#{@after})\n"
   else
      str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
   end
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   str +=  "   " + l.toString(i18nfunc)
   }


   if(@items.size > 0)
      str += "\n   #{@name}.setOpen(TRUE)\n"
#      str += "\n#child items\n"
      @items.each{|w|
         str += w.toString(i18nfunc)
      }
   end
   str
end
end



class RListView < RWidget
attr_reader :columns, :items
attr_accessor :lastItem
def initialize ( domwidget, parent=nil, wattr=nil)
   super
   @columns = []
   @items = []
   @lastItem = nil
   @miscs.each{|domnode|
      tagname = domnode.toElement.tagName.to_str
      case tagname
      when "column"
         @columns.push(RListViewColumn.new(domnode))
      when "item"
         @items.push(RListViewItem.new(domnode,self))
      end
   }
end

def toString(i18nfunc="tr")
   str = super
   @columns.each{|c|
      str += "\n   #{@name}.addColumn( #{i18nfunc}(#{c.text}))\n"
   }
   @items.each { |i|
#      str += "\n# QListViewItems \n"
      str += i.toString(i18nfunc)
   }
   str
end
end

class RListViewColumn < RWidget
def initialize(domnode)
   super
end
def text
   p_text = @properties.find{|p| p.itemName == "text"}
   if(p_text)
      p_text.args["string"]
   else
      "No Text"
   end
end
end

class RIconViewItem < RWidget
attr_reader :after
attr_accessor :lastItem
def initialize(domnode,itemParent)
   super(domnode,itemParent.name)
   @qclass = "QIconViewItem"
   @items = []
   @lastItem = nil
   @itemParent = itemParent
   if(@name.nil? or @name=="")
      @name="qIconViewItem_#{@@id}"
      @@id += 1
   end
   @after = itemParent.lastItem
   itemParent.lastItem = self.name

end

def toString(i18nfunc="tr")
   str = "\n"
   if(@after)
      str += "   #{@name} = #{@qclass}.new(#{@parent},#{@after})\n"
   else
      str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
   end
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   str +=  "   " + l.toString(i18nfunc)
   }
   str
end
end


class RListViewItem < RWidget
attr_reader :after
attr_accessor :lastItem
def initialize(domnode,itemParent)
   super(domnode,itemParent.name)
   @qclass = "QListViewItem"
   @items = []
   @lastItem = nil
   @itemParent = itemParent
   if(@name.nil? or @name=="")
      @name="qlistViewItem_#{@@id}"
      @@id += 1
   end
   @after = itemParent.lastItem
   itemParent.lastItem = self.name

   @miscs.each{|domnode|
      tagname = domnode.toElement.tagName.to_str
      case tagname
      when "item"
         @items.push(RListViewItem.new(domnode,self))
      end
   }

end

def toString(i18nfunc="tr")
   str = "\n"
   if(@after)
      str += "   #{@name} = #{@qclass}.new(#{@parent},#{@after})\n"
   else
      str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
   end
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   str +=  "   " + l.toString(i18nfunc)
   }

#   str += "\n#layouts of widget\n"
#   @layouts.each{|l|
#      str += l.toString+"\n"
#   }
   if(@items.size > 0)
      str += "\n   #{@name}.setOpen(TRUE)\n"
#      str += "\n#child items\n"
      @items.each{|w|
         str += w.toString(i18nfunc)
      }
   end
   str
end
end

class RTabWidget < RWidget
def initialize( domwidget,parent=nil,wattrib=nil)
   super
end

def toString(i18nfunc="tr")
   str = super
   title = ""
   @childWidgets.each{|w|
      a_title = w.attributes.find {|a| a.itemName == "title"}
      if(a_title)
         title = a_title.args["string"]
      else
         title = "\"No Title\""
      end
      str += "\n   #{@name}.insertTab(#{w.name},#{i18nfunc}(#{title}))\n"
   }
   str
end
end

class RWizard < RWidget
def initialize( domwidget,parent=nil,wattrib=nil)
   super
end

def toString(i18nfunc="tr")
   str = super
   title = ""
   @childWidgets.each{|w|
   p w.properties
      title_attrib = w.attributes.find{|p| p.itemName == "title"}
      if(title_attrib)
         title = title_attrib.args["string"]
      else
         title = c.name.gsub(/^@/,"")
      end 
      str += "\n   #{@name}.addPage(#{w.name},#{i18nfunc}(#{title}))\n"
   }
   str
end
end

class RLayoutWidget < RWidget
@@id = 0
attr_reader :layoutName

 def initialize ( domwidget, parent=nil,wattrib=nil)
   super
   @qclass = "QWidget"

   @isLayout = true
#   if(!haveName)
#      setName("rlayout_#{@@id}")
#   end
   @name = "@privateLayoutWidget_#{@@id}"
   @@id += 1

   @layouts.each {|l|
      l.setParent(@name)
#      l.setLayoutParent(@layoutName)
      l.childWidgets.each{|w|
         w.setParent(@name)
      }
   }
   @childWidgets.each{|w|
         w.setParent(@name)
    }
   @properties.each{|p| p.setOwner(@name)}
end

def setName(name)
   @layoutName = name
   if(layouts.size > 1)
      #print "#   Error something happen in RLayoutWidget.setName!\n"
   end
   @layouts.each {|l|
      l.setName(name)
      l.properties.each{|p| p.setOwner(name)}
   }
end

def toString(i18nfunc="tr")
   str = "\n"
   if(@layoutParent)
       if ((/grid/ =~ @layoutParent.downcase) and (@parent == "self") and (@wattribute["rowspan"]))
#   if(@parent == "self")
         str += "   #{@name} = self\n"
      else
      str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
      end
   else
      str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
   end
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   str +=  "   " + l.toString(i18nfunc)
   }

#   str += "\n#layouts of widget\n"
   @layouts.each{|l|
      str += l.toString(i18nfunc)
   }

#   str += "\n#child widget\n"
   @childWidgets.each{|w|
      str += w.toString(i18nfunc)
      str += "\n   #{@layoutName}.addWdiget(#{w.name})\n"
   }
   str
end

def setLayoutParent(lparent)
   @layoutParent = lparent
   @layouts.each{|l|
#      if(@parent == "self")
      if(@layoutParent)
         if((/grid/ =~ @layoutParent.downcase) and (@parent == "self") and @wattribute["rowspan"])
            l.setParent("nil")
         else
            l.setParent(@name)
         end
      else
      l.setParent(@name)
      end
      l.childWidgets.each{|w|
         w.setParent(@name)
      }
   }
end

def setParent(parent)
   super
   setLayoutParent(@layoutParent)
end
end

class RLayout < RWidget
@@id=0
def initialize(domwidget,parent=nil,wattr=nil)
   super
   @qclass = "QLayout"

   @childWidgets.each{|w| w.setLayoutParent(@name)}
   @layouts.each{|l| l.setLayoutParent(@name)}

end
def setName(name)
   @name = name
   @properties.each{|p|
      p.setOwner(@name)
   }
end

def setParent(parent)
   if(@layoutParent.nil?)
      @parent = parent
   else
      @parent =nil
   end
   @childWidgets.each{|w|
      w.setParent(@parent)
   }
end
=begin
def setLayoutParent(lparent)
   @layoutParent = lparent
   @parent = nil
end
=end
def toString(i18nfunc="tr")
   str = "\n"
   str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   str +=  "   " + l.toString(i18nfunc)
   }

#   str += "\n#layouts of widget\n"
   @layouts.each{|l|
      str += l.toString(i18nfunc)
      str += "\n   #{@name}.addLayout(#{l}.name)\n"
   }
#   str += "\n#child widget\n"
   @childWidgets.each{|w|
      str += w.toString(i18nfunc)
      if(w.is_item)
         str += "\n   #{@name}.addItem(#{w.name})\n"
      else
         str += "\n   #{@name}.addWidget(#{w.name},0)\n"
      end
   }
   str
end
end

class RHBox < RLayout
@@id=0
def initialize(domwidget,parent=nil)
   super(domwidget,parent)
   @qclass = "QHBoxLayout"

end
end

class RVBox < RHBox
@@id=0
def initialize(domwidget,parent=nil)
   super(domwidget,parent)
   @qclass = "QVBoxLayout"


end
end


class RGridLayout < RLayout
@@id=0
def initialize(domwidget,parent=nil)
   super(domwidget,parent)
   @qclass = "QGridLayout"

end

def toString(i18nfunc="tr")
   row=nil
   column=nil
   rowspan=nil
   colspan=nil
   toRow=nil
   toCol=nil
   str = "\n"
   str += "   #{@name} = #{@qclass}.new(#{@parent})\n"
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   str +=  "   " + l.toString(i18nfunc)
   }

#   str += "\n#layouts of widget\n"
   @layouts.each{|l|
      str += l.toString(i18nfunc)
   }
#   str += "\n#child widget\n"
   @childWidgets.each{|w|
      wattr = w.wattribute
      if(wattr)
         row = wattr["row"]
         column = wattr["column"]
         rowspan = wattr["rowspan"]
         colspan = wattr["colspan"]
         if(rowspan and colspan)
            toRow = row + rowspan - 1
            toCol = column + colspan - 1
        end
      end
      str += w.toString(i18nfunc)
      if(w.is_item)
         if(rowspan and colspan)
	    str+= "   #{name}.addMultiCell(#{w.name},#{row},#{toRow},#{column},#{toCol})\n"
	 else
            str += "   #{@name}.addItem(#{w.name},#{row},#{column})\n"
	 end
      else
         if(rowspan and colspan)
            if(w.isLayout)
               str += "   #{@name}.addMultiCellLayout(#{w.layoutName},#{row},#{toRow},#{column},#{toCol})\n"
            else
               str += "   #{@name}.addMultiCellWidget(#{w.name},#{row},#{toRow},#{column},#{toCol})\n"
            end
         else
            str += "   #{@name}.addWidget(#{w.name},#{row},#{column})\n"
         end
      end
   }
   str
end

end


class RLine < RWidget
def initialize(domwidget,parent=nil,wattr=nil)
   super

   @qclass = "QFrame"
   @isLine = true
   @properties.each{|l|
   if(l.itemName == "orientation")
       if(/Vertical/ =~ l.args["enum"])
          @style="QFrame::VLine"
       else
          @style="QFrame::HLine"
       end
  end
  }

end
def toString(i18nfunc="tr")
   str = "\n"
   str += "   #{@name} = #{@qclass}.new(#{@parent},\"#{@name}\")\n"
   str += "   #{@name}.setFrameStyle( #{@style} | QFrame::Sunken)\n"
#   str += "\n#properties of widget\n"
   @properties.each{|l|
   if(l.itemName == "geometry")
      str +=  "   " + l.toString(i18nfunc)
  end
   }
#   str += "\n#child widget\n"
   @childWidgets.each{|w|
      str += w.toString(i18nfunc)
   }
   str
end
end



class RSpacer < RWidget
@@id=0
def initialize(domwidget,parent=nil,wattr=nil)
   super
   @qclass = "QSpacerItem"
   @is_item = true
   name =  @name.gsub(/\ /,"_")
   name = name + "_#{@@id}"
   @@id += 1

   setName(name)

end

def toString(i18nfunc="tr")
   orientation = "QFrame::Horizontal"
   sizeType = "SizePolicy::Expanding"
   shWidth = 0
   shHeight = 0
   @properties.each{|p|
      case p.itemName
      when "orientation"
         orientation = p.args["enum"]
      when "sizeType"
         sizeType = p.args["enum"]
      when "sizeHint"
         shWidth = p.args["width"]
         shHeight = p.args["height"]
      end
   }
   str = "\n"
   str += "   #{name} = #{@qclass}.new( #{shWidth}, #{shHeight}, #{sizeType}, QSizePolicy::Minimum )\n"
   #no property needed
   str
end
end


class RConnections
def RConnections.connectionList(domconnections, selfClass)
   connections = []
   slots = []
   domnode = domconnections.firstChild
   tagname = domnode.toElement.tagName.to_str
   while(tagname != "")
      case tagname
      when "connection"
         connections.push(RConnection.new(domnode,selfClass))
      when "slot"
         slots.push(RQSlot.new(domnode,selfClass))
      end
      domnode = domnode.nextSibling
      tagname = domnode.toElement.tagName.to_str
   end
   connections.each{|c| c.checkSlot(slots)}
   [connections, slots]
end
end

class RConnection
def initialize( domconnection,selfClass)
   @isQtSlot = true
   domnode = domconnection.firstChild
   tagname = domnode.toElement.tagName.to_str
   while(tagname != "")
      case tagname
         when "sender"
            sender = domnode.firstChild.toText.data.to_str
            if(sender == selfClass)
              @sender = "self"
            else
               @sender = "@"+sender
            end
         when "signal"
            @signal = "\""+domnode.firstChild.toText.data.to_str+"\""
         when "receiver"
            receiver = domnode.firstChild.toText.data.to_str
            if(receiver == selfClass)
               @receiver = "self"
            else
               @receiver = "@"+receiver
            end
         when "slot"
            @slot = "\""+domnode.firstChild.toText.data.to_str+"\""
      end
      domnode = domnode.nextSibling
      tagname = domnode.toElement.tagName.to_str
   end
end
def checkSlot( slots )
   if(slots.find{|s| "\"#{s.slotName}\"" == @slot })
      @isQtSlot = false
   end

end

def toString(i18nfunc="tr")
   str = "\n"
   if(@isQtSlot)
    str += "   Qt2::connect(#{@sender}, QSIGNAL(#{@signal}), #{@receiver}, QSLOT(#{@slot}))"
   else
    str += "   Qt2::connect(#{@sender}, QSIGNAL(#{@signal}), #{@receiver}, #{@slot})"
   end
   str
end
end

class RQSlot
attr_reader :slotName
@@ignored_slot = ["close()","show()","hide()"]
def initialize ( domnode, selfClass )
   @scope = domnode.toElement.attribute("access").to_str
   @slotName = domnode.firstChild.toText.data.to_str
   @rslotName = ""
   @comarg = ""
   if(/\(\)/ =~ @slotName)
      @rslotName = @slotName
      @comarg = ""
   else
      @rslotName = @slotName.gsub(/\(.*\)/,"(arg = nil)")
      @comarg = "# #{$&} expected"
   end
end
def toString(i18nfunc="tr")
   comment = ""
   if(@@ignored_slot.find{|s| s == @slotName})
      comment = "#"
   end
   str = comment + "\n"
   str += comment + "def #{@rslotName}   #{@comarg}\n"
   str += comment + "   QMessageBox::information(nil,\"Unimplemented slot\",\"#{@slotName} is not implemented.\")\n"
   str += comment + "end\n"
end
end

class RAttribute
attr_reader :itemName, :args
def initialize( domattribute)
   @args = Hash.new
   domnode = domattribute.firstChild
   tagname = domnode.toElement.tagName.to_str
   if(tagname != "name")
      print "#Error in RAttribute:1\n"
   end
   @itemName = domnode.firstChild.toText.data.to_str
   domnode = domnode.nextSibling
   @type = domnode.toElement.tagName.to_str
   if(/string/ =~ @type)
      @args[@type] = (  "\"" + domnode.firstChild.toText.data.to_str + "\"" )
   end
   if(@itemName == "title")
      @args["string"] = @args["string"].gsub(/&amp;/,"&")
   end
end
end

class RProperty
@@function_alias = {"setIntValue"=>"display"}
attr_reader :itemName, :args
def initialize( domproperty,qclass=nil )
   @qclass = qclass
   @args = Hash.new
   domnode = domproperty.firstChild
   tagname = domnode.toElement.tagName.to_str
   if(tagname != "name")
      print "#Error in RProperty:1\n"
   end
   @itemName = domnode.firstChild.toText.data.to_str
   domnode = domnode.nextSibling
   @type = domnode.toElement.tagName.to_str
   if(/string/ =~ @type)
      @args[@type] = (  "\"" + domnode.firstChild.toText.data.to_str + "\"" )
   elsif(@type == "pixmap")
      pixname = domnode.firstChild.toText.data.to_str
      if(pixname != "")
         @args[@type] = "@" + pixname
      end
   elsif(@type == "enum" or @type == "set")
      str = domnode.firstChild.toText.data.to_str
      str = checkEnum(str)
      if(str.nil?)
          #print "#Error:#{domnode.firstChild.toText.data.to_str} not defienend!\n"
          @args[@type] = domnode.firstChild.toText.data.to_str
      else
         @args[@type] = str
      end
   elsif(@type == "comment")
      @comment = domnode.firstChild.toText.data.to_str
   elsif(@type == "bool")
      @args[@type] = domnode.firstChild.toText.data.to_str
   elsif(@type == "number")
      @args[@type] =  domnode.firstChild.toText.data.to_str
   elsif(@type == "cursor")
      @args[@type] = "QCursor.new(" + domnode.firstChild.toText.data.to_str + ")"
   elsif(@type == "palette")
      domnode = domnode.firstChild
      tagname = domnode.toElement.tagName.to_str
      while(tagname != "")
         color = []
	 colnode = domnode.firstChild
	 for i in 0..13 
	    ctagname = colnode.toElement.tagName.to_str
	    if(ctagname != "color")
	       print "#Error:#not color tag in palette\n"
	    end
	    rgb = ""
	    parnode = colnode.firstChild
	    for j in 0..2 
	       parnum = parnode.firstChild.toText.data.to_str
	       rgb += parnum + ","
	       parnode = parnode.nextSibling
	    end
	    rgb.chop!
	    color[i] = "QColor.new(" + rgb + ")"
	    colnode = colnode.nextSibling
	 end
	 @args[tagname] = color.dup
	 domnode = domnode.nextSibling
	 tagname = domnode.toElement.tagName.to_str
      end
	
   else
      domnode = domnode.firstChild
      tagname = domnode.toElement.tagName.to_str
      while(tagname != "")
         @args[tagname] = domnode.firstChild.toText.data.to_str
         domnode = domnode.nextSibling
         tagname = domnode.toElement.tagName.to_str
      end
   end
end

def checkEnum( str )
   result = ""
   enums = str.split("|")
   enums.each{| enumv |
     if(result != "")
       result += " | "
     end
     if(!(eval("defined?(#{enumv})").nil?))
        res = enumv
     elsif(!(eval("defined?(Qt2::#{enumv})").nil?))
        res = "Qt2::"+enumv
     elsif(!(eval("defined?(Qt::#{enumv})").nil?))
        res = "Qt::"+enumv
     elsif(!(eval("defined?(QSizePolicy::#{enumv})").nil?))
        res = "QSizePolicy::"+enumv
     elsif(!(eval("defined?(QFrame::#{enumv})").nil?))
        res = "QFrame::"+enumv
     elsif(!(eval("defined?(QWidget::#{enumv})").nil?))
        res = "QWidget::"+enumv
     elsif(!(eval("defined?(#{@qclass}::#{enumv})").nil?))
        res = @qclass + "::" + enumv
     else
        res = nil
     end
     if(res.nil?)
       print "#Error: \"#{str}\" is not defiend! Please check output .rb file.\n"
     else
       result += res
     end
     }
   result
end

def toString(i18nfunc="tr")
   str = ""
   owner = ""
   case @itemName
   when "buddy"
      if(@owner == "")
         owner = "self"
      else
         owner = @owner
      end
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      str = "#{@owner}.set" + tstr
      str += "(@"
      str += @args["cstring"].gsub(/\"/,"")
      str += ")\n"
   when "toolTip","whatsThis"
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      str = "Q" + tstr + "::add"
      str += "("
      if(@owner == "")
         owner = "self"
      else
         owner = @owner
      end
      str += "#{owner}," + @args["string"]
      str += ")\n"
   when "text","caption"
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      str = "set" + tstr
      if(@owner != "")
         str = "#{@owner}." + str
      end
      str += "(#{i18nfunc}("
      str += @args["string"].gsub(/"/,'\\\"').gsub(/^\\\"/,'"').gsub(/\\\"$/,'"')
      str += "))\n"
    when "font"
     str += "#{@owner}_font = #{@owner}.font()\n"
     str += "   #{@owner}_font.setFamily(\"#{@args[\"family\"]}\")\n"
     if @args.has_key?('pointsize')
       str += "   #{@owner}_font.setPointSize(#{@args['pointsize']})\n"
     end
     if @args.has_key?('bold')
       str += "   #{@owner}_font.setBold(#{int2bool(@args['bold'])})\n"
     end
     if @args.has_key?('italic')
       str += "   #{@owner}_font.setItalic(#{int2bool(@args['italic'])})\n"
     end
     if @args.has_key?('underline')
       str += "   #{@owner}_font.setUnderline(#{int2bool(@args['underline'])})\n"
     end
     if @args.has_key?('strikeout')
       str += "   #{@owner}_font.setStrikeOut(#{int2bool(@args['strikeout'])})\n"
     end
     str += "   #{@owner}.setFont(#{@owner}_font)\n"
   when "geometry"
      if(@owner == "")  #for windows
	    str = "resize( " + @args["width"] + "," + @args["height"] + ")\n"
	  else
        tstr = @itemName.dup
        tstr[0] = tstr[0].chr.upcase
        str = "set" + tstr
        if(@owner != "")
          str = "#{@owner}." + str
        end
        str += "("
        str += @args["x"]+","+@args["y"]+","+@args["width"]+","+@args["height"]
        str += ")\n"
	  end
   when "minimumSize","maximumSize"
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      str = "set" + tstr
      if(@owner != "")
         str = "#{@owner}." + str
      end
      str += "("
      str += @args["width"]+","+@args["height"]
      str += ")\n"

   when "hAlign"
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      str = "set" + str
      if(@owner != "")
         str = "#   #{@owner}." + str
      end
      str += "("
      str += @args.values.join(",")
      str += ")\n"
   when "sizePolicy"
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      str = "set" + tstr
      if(@owner != "")
         str = "#{@owner}." + str
      end
      str += "("
      str += "QSizePolicy.new(" + @args["hsizetype"]+","+@args["vsizetype"]+",sizePolicy::hasHeightForWidth())"
      str += ")\n"
   when "palette"
      str = "pal = QPalette.new()\n"
      str += "   cg = QColorGroup.new()\n"
      str += "   cg.setColor(QColorGroup::Foreground," + @args["active"][0] + ")\n"
      str += "   cg.setColor(QColorGroup::Button," + @args["active"][1] + ")\n"
      str += "   cg.setColor(QColorGroup::Light," + @args["active"][2] + ")\n"
      str += "   cg.setColor(QColorGroup::Midlight," + @args["active"][3] + ")\n"
      str += "   cg.setColor(QColorGroup::Dark," + @args["active"][4] + ")\n"
      str += "   cg.setColor(QColorGroup::Mid," + @args["active"][5] + ")\n"
      str += "   cg.setColor(QColorGroup::Text," + @args["active"][6] + ")\n"
      str += "   cg.setColor(QColorGroup::BrightText," + @args["active"][7] + ")\n"
      str += "   cg.setColor(QColorGroup::ButtonText," + @args["active"][8] + ")\n"
      str += "   cg.setColor(QColorGroup::Base," + @args["active"][9] + ")\n"
      str += "   cg.setColor(QColorGroup::Background," + @args["active"][10] + ")\n"
      str += "   cg.setColor(QColorGroup::Shadow," + @args["active"][11] + ")\n"
      str += "   cg.setColor(QColorGroup::Highlight," + @args["active"][12] + ")\n"
      str += "   cg.setColor(QColorGroup::HighlightedText," + @args["active"][13] + ")\n"
      str += "   pal.setActive(cg)\n"
      
      str += "   cg.setColor(QColorGroup::Foreground," + @args["inactive"][0] + ")\n"
      str += "   cg.setColor(QColorGroup::Button," + @args["inactive"][1] + ")\n"
      str += "   cg.setColor(QColorGroup::Light," + @args["inactive"][2] + ")\n"
      str += "   cg.setColor(QColorGroup::Midlight," + @args["inactive"][3] + ")\n"
      str += "   cg.setColor(QColorGroup::Dark," + @args["inactive"][4] + ")\n"
      str += "   cg.setColor(QColorGroup::Mid," + @args["inactive"][5] + ")\n"
      str += "   cg.setColor(QColorGroup::Text," + @args["inactive"][6] + ")\n"
      str += "   cg.setColor(QColorGroup::BrightText," + @args["inactive"][7] + ")\n"
      str += "   cg.setColor(QColorGroup::ButtonText," + @args["inactive"][8] + ")\n"
      str += "   cg.setColor(QColorGroup::Base," + @args["inactive"][9] + ")\n"
      str += "   cg.setColor(QColorGroup::Background," + @args["inactive"][10] + ")\n"
      str += "   cg.setColor(QColorGroup::Shadow," + @args["inactive"][11] + ")\n"
      str += "   cg.setColor(QColorGroup::Highlight," + @args["inactive"][12] + ")\n"
      str += "   cg.setColor(QColorGroup::HighlightedText," + @args["inactive"][13] + ")\n"
      str += "   pal.setInactive(cg)\n"

      str += "   cg.setColor(QColorGroup::Foreground," + @args["disabled"][0] + ")\n"
      str += "   cg.setColor(QColorGroup::Button," + @args["disabled"][1] + ")\n"
      str += "   cg.setColor(QColorGroup::Light," + @args["disabled"][2] + ")\n"
      str += "   cg.setColor(QColorGroup::Midlight," + @args["disabled"][3] + ")\n"
      str += "   cg.setColor(QColorGroup::Dark," + @args["disabled"][4] + ")\n"
      str += "   cg.setColor(QColorGroup::Mid," + @args["disabled"][5] + ")\n"
      str += "   cg.setColor(QColorGroup::Text," + @args["disabled"][6] + ")\n"
      str += "   cg.setColor(QColorGroup::BrightText," + @args["disabled"][7] + ")\n"
      str += "   cg.setColor(QColorGroup::ButtonText," + @args["disabled"][8] + ")\n"
      str += "   cg.setColor(QColorGroup::Base," + @args["disabled"][9] + ")\n"
      str += "   cg.setColor(QColorGroup::Background," + @args["disabled"][10] + ")\n"
      str += "   cg.setColor(QColorGroup::Shadow," + @args["disabled"][11] + ")\n"
      str += "   cg.setColor(QColorGroup::Highlight," + @args["disabled"][12] + ")\n"
      str += "   cg.setColor(QColorGroup::HighlightedText," + @args["disabled"][13] + ")\n"
      str += "   pal.setDisabled(cg)\n"
      if(@owner == "")
         str += "   setPalette(pal)\n"
      else
         str += "   #{@owner}.setPalette(pal)\n"
      end
   when "buttonGroupId"
      str = "#{@owner}.group.insert(" + @owner + "," + @args["number"] + ")\n"
   else
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      func = "set" + tstr
      a_func = @@function_alias[func]
      if(a_func)
         func = a_func
      end
      str += func
      if(@owner != "")
         str = "#{@owner}." + str
      end
      str += "("
      str += @args.values.join(",")
      str += ")\n"
   end
   if(!(@comment.nil?))
      str += "#{@comment}\n" + str
   end
   str
end

def isName
   (@itemName == "name")
end

def setOwner str
   @owner = str
end

def setQClass qclass
   @qclass = qclass
end

end

class RListViewItemProperty < RProperty
def initialize( domproperty,qclass,textId )
   super(domproperty,qclass)
   @textId = textId
end

def toString(i18nfunc="tr")
   str = ""
   case @itemName
   when "text"
      tstr = @itemName.dup
      tstr[0] = tstr[0].chr.upcase
      str += "set" + tstr
      if(@owner != "")
         str = "#{@owner}." + str
      end
      str += "(#{@textId}, #{i18nfunc}("
      str += @args["string"]
      str += "))\n"
   when "pixmap"
         if(args.size > 0)
         tstr = @itemName.dup
         tstr[0] = tstr[0].chr.upcase
         str += "set" + tstr
         if(@owner != "")
            str = "#{@owner}." + str
         end
         str += "(0,"
         str += @args["pixmap"]
         str += ")\n"
      end
   else
      str += super
   end
   if(!(@comment.nil?))
      str += "#{@comment}\n" + str
   end
   str
end
end

class RImage
   @@zlibLoaded = false
def RImage.imageList(dom)
   imageList = []
   domimage = dom.firstChild
   tagname = domimage.toElement.tagName.to_str
   if(tagname != "image")
      print "#Error in RImage:1\n"
   end
   while(tagname != "")
      imageList.push(RImage.new(domimage))
      domimage = domimage.nextSibling
      tagname = domimage.toElement.tagName.to_str
   end
   imageList
end
def initialize(domimage)
   domnode = domimage.firstChild
   tagname = domnode.toElement.tagName.to_str
   while(tagname != "")
      case tagname
      when "name"
         @name = "@" + domnode.firstChild.toText.data.to_str
      when "data"
         @format = domnode.toElement.attribute("format").to_str
         @length = domnode.toElement.attribute("length").to_str.to_i
         @data = domnode.firstChild.toText.data.to_str
      end
      domnode = domnode.nextSibling
      tagname = domnode.toElement.tagName.to_str
   end
   gzdata = []
   if(@format == "XPM.GZ")
      i = 0
      while(c = @data[i * 2])
         byte_string = "0x" + @data[i * 2].chr + @data[i * 2 + 1].chr
         gzdata.push( byte_string.hex )
         i += 1
      end
     gzdata_string = " " * i
     i = 0
     gzdata.each{|h|
         gzdata_string[i] = h
         i += 1
      }
      if(!@@zlibLoaded)
      begin
         require "zlib"
      rescue LoadError
            raise("You need zlib extension. See Ruby Home Page or  http://www.blue.sky.or.jp/atelier/ \n")
      end    
      @@zlibLoaded = true
      end
      data_string = Zlib::Inflate.inflate(gzdata_string)
   else
      data_string = @data
   end
   @data_array = data_string.split("\n")
end
def toString(i18nfunc="tr")
   str = "\n"
   str += "   #{@name}_data = ["
   @data_array.each{|l|
      if(!((/char/ =~ l) or (/XPM/ =~ l)))
         if(/};/ =~ l)
            str += "   " + l.gsub(/};/,"") + "]\n"
	 else
	    str += "   " + l + "\n"
	 end
      end
   }
   str += "\n"
   str += "   #{@name} = QPixmap.new(#{@name}_data)\n"
   str
end
end


class RTabStop
@@lastTab=nil
def RTabStop.tabstopList(domnode)
   tabstopList = []
   domtabstop = domnode.firstChild
   tagname = domtabstop.toElement.tagName.to_str
   if(tagname != "tabstop")
      print "#Error in RImage:1\n"
   end
   @@lastTab = "@" + domtabstop.firstChild.toText.data.to_str
   domtabstop = domtabstop.nextSibling
   tagname = domtabstop.toElement.tagName.to_str
   while(tagname != "")
      second = "@" + domtabstop.firstChild.toText.data.to_str
      tabstopList.push(RTabStop.new(@@lastTab,second))
      @@lastTab = second.dup
      domtabstop = domtabstop.nextSibling
      tagname = domtabstop.toElement.tagName.to_str
   end
   tabstopList
end
def initialize(first,second)
   @first = first
   @second = second
   
end

def toString(i18nfunc="tr")
   str = "\n"
   str += "   QWidget::setTabOrder(#{@first},#{@second})"
   str
end
end
