=begin
/****************************************************************************
** $Id: qt/examples/xmlquotes/richtext.cpp   2.2.2   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include "richtext.h"

#include <qhbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qtextview.h>
#include <qbrush.h>
#include <qapplication.h>
require "qt2"
include Qt2
Sayings = [ 
   ( "<b>Saying 1:</b><br>" +
    "<hr><br><br>" +
    "<big>Evil is that which one believes of others.  It is a sin to believe evil "+
    "of others, but it is seldom a mistake.</big><br><br>"+
    "<center><i>-- H.L. Mencken</i></center>" ),

   ( "<b>Saying 2:</b><br>"+
    "<hr><br><br>"+
    "<big>A well-used door needs no oil on its hinges.<br>"+
    "A swift-flowing steam does not grow stagnant.<br>"+
    "Neither sound nor thoughts can travel through a vacuum.<br>"+
    "Software rots if not used.<br><br>"+
    "These are great mysteries.</big><br><br>"+
    "<center><i>-- Geoffrey James, \"The Tao of Programming\"</i></center>"),

   ("<b>Saying 3:</b><br>"+
    "<hr><br><br>"+
    "<big>Show business is just like high school, except you get paid.</big><br><br>"+
    "<center><i>-- Martin Mull</i></center>"),

   ( "<b>Saying 4:</b><br>"+
    "<hr><br><br>"+
    "<big><b>The Least Successful Executions</b><br>" +
    "<twocolumn><p>      History has furnished us with two executioners worthy of attention. "+
    "The first performed in Sydney in Australia.  In 1803 three attempts were "+
    "made to hang a Mr. Joseph Samuels.  On the first two of these the rope "+
    "snapped, while on the third Mr. Samuels just hung there peacefully until he "+
    "and everyone else got bored.  Since he had proved unsusceptible to capital "+
    "punishment, he was reprieved.</p>"+
    "<p>        The most important British executioner was Mr. James Berry who "+
    "tried three times in 1885 to hang Mr. John Lee at Exeter Jail, but on each "+
    "occasion failed to get the trap door open.<!p>"+
    "<p>        In recognition of self achievement, the Home Secretary commuted "+
    "Lee's sentence to \"life\" imprisonment.  He was released in 1917, emigrated " +
    "to America and lived until 1933.</p></twocolumn></big><br><br>" +
    "<center><i>-- Stephen Pile, \"The Book of Heroic Failures\"</i></center>"),

   ( "<b>Saying 5:</b><br>"+
    "<hr><br><br>"+
    "<big>If you can, help others.  If you can't, at least don't hurt others.</big><br><br>"+
    "<center><i>-- the Dalai Lama</i></center>"),

   ( "<b>Saying 6:</b><br>"+
    "<hr><br><br>"+
    "<big>Television has brought back murder into the home -- where it belongs.</big><br><br>"+
    "<center><i>-- Alfred Hitchcock</i></center>"),

   ( "<b>Saying 7:</b><br>"+
    "<hr><br><br>"+
    "<big>I don't know who my grandfather was I am much more concerned to know "+
    "what his grandson will be.</big><br><br>"+
    "<center><i>-- Abraham Lincoln</i></center>")]


class MyRichText < QVBox
def setStrings( s )
   @sayings = s
   @view.setText( QString::fromLocal8Bit(@sayings[0]) )
end
def initialize( parent=nil, name="" )
    super( parent, name )

    setMargin( 5 )

    @view = QTextView.new("","", self )
    @view.setText( "This is a <b>Test</b> with <i>italic</i> <u>stuff</u>" )
    @paper = QBrush.new(Qt::black)
    @paper.setPixmap( QPixmap.new( "marble.png" ) )
    @view.setPaper( @paper )

    @view.setMinimumSize( 450, 250 )

    @buttons = QHBox.new( self )
    @buttons.setMargin( 5 )

    @bClose = QPushButton.new( "&Close", @buttons )
    @bPrev = QPushButton.new( "<< &Prev", @buttons )
    @bNext = QPushButton.new( "&Next >>", @buttons )

    @bPrev.setEnabled( FALSE )

    connect( @bClose, QSIGNAL( "clicked()" ), QApplication::qApp, QSLOT( "quit()" ) )
    connect( @bPrev, QSIGNAL( "clicked()" ), self, "prev()" )
    connect( @bNext, QSIGNAL( "clicked()" ), self, "next()" )

    @num = 0
    setStrings(Sayings)
end

def prev()

    if ( @num <= 0 )
        return
    end
    @num -= 1

    @view.setText( QString::fromLocal8Bit(@sayings[@num]) )

    if ( @num == 0 )
        @bPrev.setEnabled( FALSE )
    end
    @bNext.setEnabled( TRUE )
end

def next()

    if ( @num >= @sayings.size()-1 )
        return
    end
    @num += 1

    @view.setText( QString::fromLocal8Bit(@sayings[@num]) )

    if ( @num >= @sayings.size()-1 )
        @bNext.setEnabled( FALSE )
    end
    @bPrev.setEnabled( TRUE )
end

end
