=begin
/****************************************************************************
** $Id: qt/examples/sound/sound.cpp   2.2.4   edited 2000-08-31 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
require "qt2"
include Qt2
require "qt2sound"
include Qt2sound
#//
#// Very simple example of QSound::play(filename)
#//
#// 99% of self program is just boilerplate Qt code to put up a nice
#// window so you think something special is happening.
#//

#include "sound.h"
#include <qmessagebox.h>
#include <qmenubar.h>

class SoundPlayer < QMainWindow

def initialize
   super
   @bucket3 = QSound.new("sounds/3.wav")
   @bucket4 = QSound.new("sounds/4.wav")

    if (!QSound::available()) 
	#// Bail out.  Programs in which sound is not critical
	#// could just silently (hehe) ignore the lack of a server.
	#//
	QMessageBox::warning(self,"No Sound","<p><b>Sorry, you are not running the Network Audio System.</b>"+"<p>If you have the `au' command, run it in the background before self program. "+"The latest release of the Network Audio System can be obtained from:"+"<pre>\n"+" &nbsp\n"+"   ftp.ncd.com:/pub/ncd/technology/src/nas\n"+"   ftp.x.org:/contrib/audio/nas\n"+"</pre>"+"<p>Release 1.2 of NAS is also included with the X11R6"+"contrib distribution."+"<p>After installing NAS, you will then need to reconfigure Qt with NAS sound support")
    end

    file = QPopupMenu.new
    file.insertItem("Play &1",  self, "doPlay1()", CTRL+Key_1)
    file.insertItem("Play &2",  self, "doPlay2()", CTRL+Key_2)
    file.insertItem("Play from bucket &3",  self, "doPlay3()", CTRL+Key_3)
    file.insertItem("Play from bucket &4",  self, "doPlay4()", CTRL+Key_4)
    file.insertSeparator()
    file.insertItem("Play 3 and 4 together",  self, "doPlay34()")
    file.insertItem("Play all together",  self, "doPlay1234()")
    file.insertSeparator()
    file.insertItem("E&xit",  QApplication::qApp, "quit()")
    menuBar().insertItem("&File", file)
end

def doPlay1()

    QSound::playFile("sounds/1.wav")
end

def doPlay2()

    QSound::playFile("sounds/2.wav")
end

def doPlay3()
p @bucket3
    @bucket3.play()
end

def doPlay4()

    @bucket4.play()
end

def doPlay34()

    #// Some sound platforms will only play one sound at a time
    @bucket3.play()
    @bucket4.play()
end

def doPlay1234()

    #// Some sound platforms will only play one sound at a time
    QSound::playFile("sounds/1.wav")
    QSound::playFile("sounds/2.wav")
    @bucket3.play()
    @bucket4.play()
end
end

    app = QApplication.new([$0]+ARGV)
    sp = SoundPlayer.new
    app.setMainWidget(sp)
    sp.show()
    app.exec()


